/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def;

import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.loading.CacheDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.cache.def.loading.rs435.VarPlayerDefinitionLoader;
import org.runejs.client.io.Buffer;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;

public class VarPlayerDefinition
extends CachedNode
implements CacheDefinition {
    public static DefinitionLoader<VarPlayerDefinition> loader = new VarPlayerDefinitionLoader();
    private static NodeCache varPlayerDefinitionCache = new NodeCache(64);
    private static CacheArchive gameDefinitionsCacheArchive;
    public static int varPlayerDefinitionsSize;
    public static int[] varpCache;
    public int type = 0;
    public int id;
    public static int[] varPlayers;

    public static VarPlayerDefinition getDefinition(int id) {
        VarPlayerDefinition definition = (VarPlayerDefinition)varPlayerDefinitionCache.get(id);
        if (definition != null) {
            return definition;
        }
        byte[] data = gameDefinitionsCacheArchive.getFile(16, id);
        definition = new VarPlayerDefinition();
        definition.id = id;
        if (data != null) {
            loader.load(definition, new Buffer(data));
        }
        varPlayerDefinitionCache.put(id, definition);
        return definition;
    }

    public static void initializeVarPlayerDefinitionCache(CacheArchive cacheArchive) {
        gameDefinitionsCacheArchive = cacheArchive;
        varPlayerDefinitionsSize = gameDefinitionsCacheArchive.fileLength(16);
    }

    public static void clearVarPlayerDefinitionCache() {
        varPlayerDefinitionCache.clear();
    }

    @Override
    public int getId() {
        return this.id;
    }

    static {
        varpCache = new int[2000];
        varPlayers = new int[2000];
    }
}

