/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def;

import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.loading.CacheDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.cache.def.loading.rs435.UnderlayDefinitionLoader;
import org.runejs.client.io.Buffer;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;

public class UnderlayDefinition
extends CachedNode
implements CacheDefinition {
    public static DefinitionLoader<UnderlayDefinition> loader = new UnderlayDefinitionLoader();
    private static NodeCache definitionCache = new NodeCache(64);
    private static CacheArchive definitionArchive;
    public int id;
    public int lightness;
    public int hue;
    public int hueMultiplier;
    public int saturation;
    public int color = 0;

    public static void initializeUnderlayDefinitionCache(CacheArchive cacheArchive) {
        definitionArchive = cacheArchive;
    }

    public static UnderlayDefinition getDefinition(int underlayId) {
        UnderlayDefinition underlayDefinition = (UnderlayDefinition)definitionCache.get(underlayId);
        if (underlayDefinition != null) {
            return underlayDefinition;
        }
        byte[] data = definitionArchive.getFile(1, underlayId);
        underlayDefinition = new UnderlayDefinition();
        underlayDefinition.id = underlayId;
        if (data != null) {
            loader.load(underlayDefinition, new Buffer(data));
        }
        underlayDefinition.calculateHsl();
        definitionCache.put(underlayId, underlayDefinition);
        return underlayDefinition;
    }

    public static void clearUnderlayDefinitionCache() {
        definitionCache.clear();
    }

    public void calculateHsl() {
        double cmax;
        double r = (double)(this.color >> 16 & 0xFF) / 256.0;
        double g = (double)((this.color & 0xFF68) >> 8) / 256.0;
        double b = (double)(this.color & 0xFF) / 256.0;
        double cmin = r;
        if (cmin > g) {
            cmin = g;
        }
        if (b < cmin) {
            cmin = b;
        }
        if ((cmax = r) < g) {
            cmax = g;
        }
        double h = 0.0;
        if (cmax < b) {
            cmax = b;
        }
        double l = (cmax + cmin) / 2.0;
        this.lightness = (int)(l * 256.0);
        double s = 0.0;
        if (cmax != cmin) {
            if (l < 0.5) {
                s = (cmax - cmin) / (cmax + cmin);
            }
            if (l >= 0.5) {
                s = (-cmin + cmax) / (-cmin + (-cmax + 2.0));
            }
            if (r == cmax) {
                h = (-b + g) / (-cmin + cmax);
            } else if (cmax == g) {
                h = 2.0 + (b - r) / (cmax - cmin);
            } else if (cmax == b) {
                h = (r - g) / (-cmin + cmax) + 4.0;
            }
        }
        h /= 6.0;
        if (this.lightness >= 0) {
            if (this.lightness > 255) {
                this.lightness = 255;
            }
        } else {
            this.lightness = 0;
        }
        this.hueMultiplier = l > 0.5 ? (int)((-l + 1.0) * s * 512.0) : (int)(l * s * 512.0);
        this.saturation = (int)(256.0 * s);
        if (this.hueMultiplier < 1) {
            this.hueMultiplier = 1;
        }
        this.hue = (int)(h * (double)this.hueMultiplier);
        if (this.saturation >= 0) {
            if (this.saturation > 255) {
                this.saturation = 255;
            }
        } else {
            this.saturation = 0;
        }
    }

    @Override
    public int getId() {
        return this.id;
    }
}

