/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def;

import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.loading.CacheDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.cache.def.loading.rs435.SpotAnimDefinitionLoader;
import org.runejs.client.cache.media.AnimationSequence;
import org.runejs.client.io.Buffer;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;

public class SpotAnimDefinition
extends CachedNode
implements CacheDefinition {
    public static DefinitionLoader<SpotAnimDefinition> loader = new SpotAnimDefinitionLoader();
    private static CacheArchive definitionArchive;
    private static NodeCache definitionCache;
    private static NodeCache modelCache;
    private static CacheArchive modelArchive;
    public int animationId = -1;
    public int modelId;
    public int contrast = 0;
    public int ambient = 0;
    public int resizeX = 128;
    public int rotaton = 0;
    public int[] recolorToFind = new int[6];
    public int id;
    public int[] recolorToReplace = new int[6];
    public int resizeY = 128;

    public static SpotAnimDefinition forId(int id) {
        SpotAnimDefinition spotAnimDefinition = (SpotAnimDefinition)definitionCache.get(id);
        if (spotAnimDefinition != null) {
            return spotAnimDefinition;
        }
        byte[] data = definitionArchive.getFile(13, id);
        spotAnimDefinition = new SpotAnimDefinition();
        spotAnimDefinition.id = id;
        if (data != null) {
            loader.load(spotAnimDefinition, new Buffer(data));
        }
        definitionCache.put(id, spotAnimDefinition);
        return spotAnimDefinition;
    }

    public static void clearSpotAnimCache() {
        definitionCache.clear();
        modelCache.clear();
    }

    public static void initializeSpotAnimCache(CacheArchive arg1, CacheArchive arg2) {
        modelArchive = arg1;
        definitionArchive = arg2;
    }

    public Model getModel(int arg0) {
        Model model = (Model)modelCache.get(this.id);
        if (model == null) {
            model = Model.getModel(modelArchive, this.modelId);
            if (model == null) {
                return null;
            }
            for (int i = 0; i < 6; ++i) {
                if (this.recolorToFind[0] == 0) continue;
                model.replaceColor(this.recolorToFind[i], this.recolorToReplace[i]);
            }
            model.createBones();
            model.applyLighting(64 + this.ambient, this.contrast + 850, -30, -50, -30, true);
            modelCache.put(this.id, model);
        }
        Model class40_sub5_sub17_sub5_0_ = this.animationId == -1 || arg0 == -1 ? model.method806(true) : AnimationSequence.getAnimationSequence(this.animationId).method597((byte)-87, model, arg0);
        if (this.resizeX != 128 || this.resizeY != 128) {
            class40_sub5_sub17_sub5_0_.scaleT(this.resizeX, this.resizeY, this.resizeX);
        }
        if (this.rotaton != 0) {
            if (this.rotaton == 90) {
                class40_sub5_sub17_sub5_0_.method813();
            }
            if (this.rotaton == 180) {
                class40_sub5_sub17_sub5_0_.method813();
                class40_sub5_sub17_sub5_0_.method813();
            }
            if (this.rotaton == 270) {
                class40_sub5_sub17_sub5_0_.method813();
                class40_sub5_sub17_sub5_0_.method813();
                class40_sub5_sub17_sub5_0_.method813();
            }
        }
        return class40_sub5_sub17_sub5_0_;
    }

    @Override
    public int getId() {
        return this.id;
    }

    static {
        definitionCache = new NodeCache(64);
        modelCache = new NodeCache(30);
    }
}

