/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def;

import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.loading.CacheDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.cache.def.loading.rs435.OverlayDefinitionLoader;
import org.runejs.client.io.Buffer;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;

public class OverlayDefinition
extends CachedNode
implements CacheDefinition {
    public static DefinitionLoader<OverlayDefinition> loader = new OverlayDefinitionLoader();
    private static NodeCache definitionCache = new NodeCache(64);
    private static CacheArchive definitionArchive;
    public int saturation;
    public int texture = -1;
    public int otherSaturation;
    public int hue;
    public int otherHue;
    public int secondaryColor = -1;
    public int lightness;
    public boolean hideOverlay = true;
    public int color = 0;
    public int otherLightness;
    public int id;

    public static OverlayDefinition getDefinition(int id, int archiveGroupId) {
        OverlayDefinition overlayDefinition = (OverlayDefinition)definitionCache.get(id);
        if (overlayDefinition != null) {
            return overlayDefinition;
        }
        byte[] data = definitionArchive.getFile(archiveGroupId, id);
        overlayDefinition = new OverlayDefinition();
        overlayDefinition.id = id;
        if (data != null) {
            loader.load(overlayDefinition, new Buffer(data));
        }
        overlayDefinition.calculateHsl();
        definitionCache.put(id, overlayDefinition);
        return overlayDefinition;
    }

    public static void initializeOverlayDefinitionCache(CacheArchive cacheArchive) {
        definitionArchive = cacheArchive;
    }

    public static void clearOverlayDefinitionCache() {
        definitionCache.clear();
    }

    public void calculateHsl() {
        if (this.secondaryColor != -1) {
            this.calculateHsl(this.secondaryColor);
            this.otherSaturation = this.saturation;
            this.otherLightness = this.lightness;
            this.otherHue = this.hue;
        }
        this.calculateHsl(this.color);
    }

    public void calculateHsl(int color) {
        double var11;
        double r = (double)(0xFF & color >> 16) / 256.0;
        double g = (double)((0xFF2D & color) >> 8) / 256.0;
        double b = (double)(0xFF & color) / 256.0;
        double var10 = r;
        if (g < var10) {
            var10 = g;
        }
        if (var10 > b) {
            var10 = b;
        }
        if (g > (var11 = r)) {
            var11 = g;
        }
        double var12 = 0.0;
        double var16 = 0.0;
        if (b > var11) {
            var11 = b;
        }
        double var14 = (var11 + var10) / 2.0;
        if (var10 != var11) {
            if (var14 < 0.5) {
                var16 = (var11 - var10) / (var11 + var10);
            }
            if (var14 >= 0.5) {
                var16 = (-var10 + var11) / (-var10 + (2.0 - var11));
            }
            if (var11 != r) {
                if (g == var11) {
                    var12 = 2.0 + (b - r) / (var11 - var10);
                } else if (var11 == b) {
                    var12 = (-g + r) / (-var10 + var11) + 4.0;
                }
            } else {
                var12 = (g - b) / (var11 - var10);
            }
        }
        this.hue = (int)((var12 /= 6.0) * 256.0);
        this.saturation = (int)(256.0 * var14);
        this.lightness = (int)(var16 * 256.0);
        if (this.lightness < 0) {
            this.lightness = 0;
        } else if (this.lightness > 255) {
            this.lightness = 255;
        }
        if (this.saturation < 0) {
            this.saturation = 0;
        } else if (this.saturation > 255) {
            this.saturation = 255;
        }
    }

    @Override
    public int getId() {
        return this.id;
    }
}

