/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def;

import org.runejs.client.MovedStatics;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.EntityDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.cache.def.loading.rs435.ItemDefinitionLoader;
import org.runejs.client.cache.media.ImageRGB;
import org.runejs.client.io.Buffer;
import org.runejs.client.language.English;
import org.runejs.client.media.Rasterizer;
import org.runejs.client.media.Rasterizer3D;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;

public class ItemDefinition
extends CachedNode
implements EntityDefinition {
    public static DefinitionLoader<ItemDefinition> loader = new ItemDefinitionLoader();
    public static int count;
    public static int[] lineOffsets;
    private static CacheArchive definitionArchive;
    private static NodeCache definitionCache;
    private static NodeCache modelCache;
    private static NodeCache imageCache;
    private static CacheArchive modelArchive;
    public int stackable = 0;
    public String name = "null";
    public String[] interfaceOptions = new String[]{null, null, null, null, English.drop};
    public int primaryMaleHeadPiece = -1;
    public int[] originalColours;
    public String[] groundOptions = new String[]{null, null, English.take, null, null};
    public int inventoryModelId;
    public int xOffset2d = 0;
    public int noteTemplateId = -1;
    public int yOffset2d = 0;
    public int notedId = -1;
    public int groundScaleX = 128;
    public int[] destColors;
    public int zoom2d = 2000;
    public int maleOffset = 0;
    public int femaleModel1 = -1;
    public int maleModel1 = -1;
    public int secondaryFemaleHeadPiece = -1;
    public int teamIndex = 0;
    public int maleModel2 = -1;
    public int ambient = 0;
    public int zan2d = 0;
    public int cost = 1;
    public int femaleOffset = 0;
    public int yan2d = 0;
    public int[] stackIds;
    public int groundScaleZ = 128;
    public int[] stackableAmounts;
    public int maleModel0 = -1;
    public int contrast = 0;
    public int secondaryMaleHeadPiece = -1;
    public int xan2d = 0;
    public int femaleModel2 = -1;
    public int femaleModel0 = -1;
    public boolean members = false;
    public int primaryFemaleHeadPiece = -1;
    public int id;
    public int groundScaleY = 128;

    public static ItemDefinition forId(int id, int archiveGroupId) {
        ItemDefinition definition = (ItemDefinition)definitionCache.get(id);
        if (definition != null) {
            return definition;
        }
        byte[] data = definitionArchive.getFile(archiveGroupId, id);
        definition = new ItemDefinition();
        definition.id = id;
        if (data != null) {
            definition = loader.load(definition, new Buffer(data));
        }
        if (definition.noteTemplateId != -1) {
            definition.itemToNote(ItemDefinition.forId(definition.noteTemplateId, 10), ItemDefinition.forId(definition.notedId, 10));
        }
        if (!MovedStatics.membersServer && definition.members) {
            definition.interfaceOptions = null;
            definition.teamIndex = 0;
            definition.groundOptions = null;
            definition.name = English.membersObject;
        }
        definitionCache.put(id, definition);
        return definition;
    }

    public static ImageRGB sprite(int stackSize, int id, int backColour) {
        Model model;
        if (backColour == 0) {
            ImageRGB sprite = (ImageRGB)imageCache.get(id);
            if (sprite != null && sprite.maxHeight != stackSize && sprite.maxHeight != -1) {
                sprite.unlink();
                sprite = null;
            }
            if (sprite != null) {
                return sprite;
            }
        }
        ItemDefinition definition = ItemDefinition.forId(id, 10);
        if (definition.stackIds == null) {
            stackSize = -1;
        }
        if (stackSize > 1) {
            int stackId = -1;
            for (int i = 0; i < 10; ++i) {
                if (stackSize < definition.stackableAmounts[i] || definition.stackableAmounts[i] == 0) continue;
                stackId = definition.stackIds[i];
            }
            if (stackId != -1) {
                definition = ItemDefinition.forId(stackId, 10);
            }
        }
        if ((model = definition.asGroundStack(true, 1)) == null) {
            return null;
        }
        ImageRGB notedSprite = null;
        if (definition.noteTemplateId != -1 && (notedSprite = ItemDefinition.sprite(10, definition.notedId, -1)) == null) {
            return null;
        }
        int[] pixels = Rasterizer.destinationPixels;
        int i = Rasterizer.destinationHeight;
        int i_1_ = Rasterizer.destinationWidth;
        int i_2_ = Rasterizer.viewportLeft;
        int i_4_ = Rasterizer.viewportRight;
        int i_5_ = Rasterizer.viewportTop;
        int i_6_ = Rasterizer.viewportBottom;
        int[] lineOffsets = Rasterizer3D.getLineOffsets();
        int i_8_ = Rasterizer3D.bottomY;
        int i_9_ = Rasterizer3D.viewportRx;
        ImageRGB rendered = new ImageRGB(32, 32);
        Rasterizer.prepare(rendered.pixels, 32, 32);
        ItemDefinition.lineOffsets = Rasterizer3D.setLineOffsets(ItemDefinition.lineOffsets);
        Rasterizer.drawFilledRectangle(0, 0, 32, 32, 0);
        int i_11_ = definition.zoom2d;
        if (backColour == -1) {
            i_11_ = (int)((double)i_11_ * 1.5);
        }
        if (backColour > 0) {
            i_11_ = (int)((double)i_11_ * 1.04);
        }
        Rasterizer3D.notTextured = false;
        int i_12_ = Rasterizer3D.sinetable[definition.xan2d] * i_11_ >> 16;
        int i_13_ = i_11_ * Rasterizer3D.cosinetable[definition.xan2d] >> 16;
        model.method799();
        model.drawModel(0, definition.yan2d, definition.zan2d, definition.xan2d, definition.xOffset2d, definition.yOffset2d + model.modelHeight / 2 + i_12_, i_13_ + definition.yOffset2d);
        for (int i_14_ = 31; i_14_ >= 0; --i_14_) {
            for (i_13_ = 31; i_13_ >= 0; --i_13_) {
                if (rendered.pixels[i_14_ + 32 * i_13_] != 0) continue;
                if (i_14_ > 0 && rendered.pixels[i_13_ * 32 + -1 + i_14_] > 1) {
                    rendered.pixels[i_13_ * 32 + i_14_] = 1;
                    continue;
                }
                if (i_13_ > 0 && rendered.pixels[i_14_ + (i_13_ + -1) * 32] > 1) {
                    rendered.pixels[i_13_ * 32 + i_14_] = 1;
                    continue;
                }
                if (i_14_ < 31 && rendered.pixels[i_13_ * 32 + i_14_ + 1] > 1) {
                    rendered.pixels[i_14_ + i_13_ * 32] = 1;
                    continue;
                }
                if (i_13_ >= 31 || rendered.pixels[(i_13_ + 1) * 32 + i_14_] <= 1) continue;
                rendered.pixels[i_14_ + 32 * i_13_] = 1;
            }
        }
        if (backColour > 0) {
            for (int i_15_ = 31; i_15_ >= 0; --i_15_) {
                for (i_13_ = 31; i_13_ >= 0; --i_13_) {
                    if (rendered.pixels[i_15_ + i_13_ * 32] != 0) continue;
                    if (i_15_ > 0 && rendered.pixels[32 * i_13_ + -1 + i_15_] == 1) {
                        rendered.pixels[i_15_ + i_13_ * 32] = backColour;
                        continue;
                    }
                    if (i_13_ <= 0 || rendered.pixels[i_15_ + (i_13_ + -1) * 32] != 1) {
                        if (i_15_ >= 31 || rendered.pixels[1 + i_15_ + i_13_ * 32] != 1) {
                            if (i_13_ >= 31 || rendered.pixels[i_15_ + 32 + 32 * i_13_] != 1) continue;
                            rendered.pixels[i_13_ * 32 + i_15_] = backColour;
                            continue;
                        }
                        rendered.pixels[i_15_ + i_13_ * 32] = backColour;
                        continue;
                    }
                    rendered.pixels[i_15_ + i_13_ * 32] = backColour;
                }
            }
        } else if (backColour == 0) {
            for (int i_16_ = 31; i_16_ >= 0; --i_16_) {
                for (i_13_ = 31; i_13_ >= 0; --i_13_) {
                    if (rendered.pixels[i_13_ * 32 + i_16_] != 0 || i_16_ <= 0 || i_13_ <= 0 || rendered.pixels[i_16_ - (1 + -((-1 + i_13_) * 32))] <= 0) continue;
                    rendered.pixels[i_16_ + 32 * i_13_] = 0x302020;
                }
            }
        }
        if (definition.noteTemplateId != -1) {
            int i_17_ = notedSprite.maxHeight;
            int i_18_ = notedSprite.maxWidth;
            notedSprite.maxHeight = 32;
            notedSprite.maxWidth = 32;
            notedSprite.drawImage(0, 0);
            notedSprite.maxWidth = i_18_;
            notedSprite.maxHeight = i_17_;
        }
        if (backColour == 0) {
            imageCache.put(id, rendered);
        }
        Rasterizer.prepare(pixels, i_1_, i);
        Rasterizer.setBounds(i_2_, i_5_, i_4_, i_6_);
        Rasterizer3D.setLineOffsets(lineOffsets);
        Rasterizer3D.bottomY = i_8_;
        Rasterizer3D.viewportRx = i_9_;
        Rasterizer3D.resetBoundsTo3dViewport();
        Rasterizer3D.notTextured = true;
        rendered.maxWidth = definition.stackable == 1 ? 33 : 32;
        rendered.maxHeight = stackSize;
        return rendered;
    }

    public static void clearItemCache() {
        definitionCache.clear();
        modelCache.clear();
        imageCache.clear();
    }

    public static void initializeItemDefinitionCache(CacheArchive definitionCache, boolean arg1, CacheArchive arg2) {
        MovedStatics.membersServer = arg1;
        modelArchive = arg2;
        definitionArchive = definitionCache;
        count = definitionArchive.fileLength(10);
    }

    public static void clearImageCache() {
        imageCache.clear();
    }

    public boolean headPieceReady(boolean female) {
        int primaryId = this.primaryMaleHeadPiece;
        int secondaryId = this.secondaryMaleHeadPiece;
        if (female) {
            secondaryId = this.secondaryFemaleHeadPiece;
            primaryId = this.primaryFemaleHeadPiece;
        }
        if (primaryId == -1) {
            return true;
        }
        boolean ready = true;
        if (!modelArchive.loaded(primaryId, 0)) {
            ready = false;
        }
        if (secondaryId != -1 && !modelArchive.loaded(secondaryId, 0)) {
            ready = false;
        }
        return ready;
    }

    public boolean equipmentReady(boolean arg0) {
        int i = this.maleModel0;
        int i_1_ = this.maleModel1;
        int i_2_ = this.maleModel2;
        if (arg0) {
            i_2_ = this.femaleModel2;
            i_1_ = this.femaleModel1;
            i = this.femaleModel0;
        }
        if (i == -1) {
            return true;
        }
        boolean bool = true;
        if (!modelArchive.loaded(i, 0)) {
            bool = false;
        }
        if (i_1_ != -1 && !modelArchive.loaded(i_1_, 0)) {
            bool = false;
        }
        if (i_2_ != -1 && !modelArchive.loaded(i_2_, 0)) {
            bool = false;
        }
        return bool;
    }

    public Model asEquipment(boolean isFemale) {
        int primaryId = this.maleModel0;
        int secondaryId = this.maleModel1;
        int tertiaryId = this.maleModel2;
        if (isFemale) {
            primaryId = this.femaleModel0;
            secondaryId = this.femaleModel1;
            tertiaryId = this.femaleModel2;
        }
        if (primaryId == -1) {
            return null;
        }
        Model primary = Model.getModel(modelArchive, primaryId);
        if (secondaryId != -1) {
            Model secondary = Model.getModel(modelArchive, secondaryId);
            if (tertiaryId == -1) {
                Model[] tertiary = new Model[]{primary, secondary};
                primary = new Model(tertiary, 2);
            } else {
                Model model3 = Model.getModel(modelArchive, tertiaryId);
                Model[] models = new Model[]{primary, secondary, model3};
                primary = new Model(models, 3);
            }
        }
        if (!isFemale && this.maleOffset != 0) {
            primary.translate(0, this.maleOffset, 0);
        }
        if (isFemale && this.femaleOffset != 0) {
            primary.translate(0, this.femaleOffset, 0);
        }
        if (this.originalColours != null) {
            for (int i_8_ = 0; this.originalColours.length > i_8_; ++i_8_) {
                primary.replaceColor(this.originalColours[i_8_], this.destColors[i_8_]);
            }
        }
        return primary;
    }

    public ItemDefinition method743(int arg1) {
        if (this.stackIds != null && arg1 > 1) {
            int i = -1;
            for (int i_9_ = 0; i_9_ < 10; ++i_9_) {
                if (arg1 < this.stackableAmounts[i_9_] || this.stackableAmounts[i_9_] == 0) continue;
                i = this.stackIds[i_9_];
            }
            if (i != -1) {
                return ItemDefinition.forId(i, 10);
            }
        }
        return this;
    }

    public Model asHeadPiece(boolean female) {
        int primaryId = this.primaryMaleHeadPiece;
        int secondaryId = this.secondaryMaleHeadPiece;
        if (female) {
            primaryId = this.primaryFemaleHeadPiece;
            secondaryId = this.secondaryFemaleHeadPiece;
        }
        if (primaryId == -1) {
            return null;
        }
        Model primary = Model.getModel(modelArchive, primaryId);
        if (secondaryId != -1) {
            Model secondary = Model.getModel(modelArchive, secondaryId);
            Model[] models = new Model[]{primary, secondary};
            primary = new Model(models, 2);
        }
        if (this.originalColours != null) {
            for (int j = 0; this.originalColours.length > j; ++j) {
                primary.replaceColor(this.originalColours[j], this.destColors[j]);
            }
        }
        return primary;
    }

    public void itemToNote(ItemDefinition noteTemplate, ItemDefinition note) {
        this.xan2d = noteTemplate.xan2d;
        this.xOffset2d = noteTemplate.xOffset2d;
        this.zan2d = noteTemplate.zan2d;
        this.name = note.name;
        this.cost = note.cost;
        this.stackable = 1;
        this.zoom2d = noteTemplate.zoom2d;
        this.members = note.members;
        this.destColors = noteTemplate.destColors;
        this.originalColours = noteTemplate.originalColours;
        this.yan2d = noteTemplate.yan2d;
        this.yOffset2d = noteTemplate.yOffset2d;
        this.inventoryModelId = noteTemplate.inventoryModelId;
    }

    public Model asGroundStack(boolean arg0, int amount) {
        Model model;
        int i;
        if (this.stackIds != null && amount > 1) {
            int id = -1;
            for (i = 0; i < 10; ++i) {
                if (amount < this.stackableAmounts[i] || this.stackableAmounts[i] == 0) continue;
                id = this.stackIds[i];
            }
            if (id != -1) {
                return ItemDefinition.forId(id, 10).asGroundStack(arg0, 1);
            }
        }
        if ((model = (Model)modelCache.get(this.id)) != null) {
            return model;
        }
        model = Model.getModel(modelArchive, this.inventoryModelId);
        if (model == null) {
            return null;
        }
        if (this.groundScaleX != 128 || this.groundScaleY != 128 || this.groundScaleZ != 128) {
            model.scaleT(this.groundScaleX, this.groundScaleY, this.groundScaleZ);
        }
        if (this.originalColours != null) {
            for (i = 0; i < this.originalColours.length; ++i) {
                model.replaceColor(this.originalColours[i], this.destColors[i]);
            }
        }
        if (arg0) {
            model.applyLighting(this.ambient + 64, 768 + this.contrast, -50, -10, -50, true);
            model.singleTile = true;
            modelCache.put(this.id, model);
        }
        return model;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        definitionCache = new NodeCache(64);
        modelCache = new NodeCache(50);
        imageCache = new NodeCache(100);
    }
}

