/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def;

import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.loading.CacheDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.cache.def.loading.rs435.IdentityKitDefinitionLoader;
import org.runejs.client.io.Buffer;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;

public class IdentityKit
extends CachedNode
implements CacheDefinition {
    public static DefinitionLoader<IdentityKit> loader = new IdentityKitDefinitionLoader();
    public int id;
    private static CacheArchive identityKitArchive;
    private static NodeCache identityKitCache;
    public static int count;
    private static CacheArchive modelArchive;
    public int[] recolorToFind = new int[6];
    public int[] recolorToReplace;
    public int bodyPartId = -1;
    public int[] modelId;
    public boolean nonSelectable = false;
    public int[] models = new int[]{-1, -1, -1, -1, -1};

    public IdentityKit() {
        this.recolorToReplace = new int[6];
    }

    public static IdentityKit cache(int id) {
        IdentityKit identityKit = (IdentityKit)identityKitCache.get(id);
        if (identityKit != null) {
            return identityKit;
        }
        byte[] data = identityKitArchive.getFile(3, id);
        identityKit = new IdentityKit();
        identityKit.id = id;
        if (data != null) {
            loader.load(identityKit, new Buffer(data));
        }
        identityKitCache.put(id, identityKit);
        return identityKit;
    }

    public static void clearIdentityKitCache() {
        identityKitCache.clear();
    }

    public static void initializeIdentityKitDefinitionCache(CacheArchive definitionCache, CacheArchive arg2) {
        modelArchive = arg2;
        identityKitArchive = definitionCache;
        count = identityKitArchive.fileLength(3);
    }

    public boolean isBodyModelCached() {
        if (this.modelId == null) {
            return true;
        }
        boolean isCached = true;
        for (int i = 0; this.modelId.length > i; ++i) {
            if (modelArchive.loaded(this.modelId[i], 0)) continue;
            isCached = false;
        }
        return isCached;
    }

    public boolean method624() {
        boolean bool = true;
        for (int i = 0; i < 5; ++i) {
            if (this.models[i] == -1 || modelArchive.loaded(this.models[i], 0)) continue;
            bool = false;
        }
        return bool;
    }

    public Model method629() {
        Model[] class40_sub5_sub17_sub5s = new Model[5];
        int i = 0;
        for (int i_7_ = 0; i_7_ < 5; ++i_7_) {
            if (this.models[i_7_] == -1) continue;
            class40_sub5_sub17_sub5s[i++] = Model.getModel(modelArchive, this.models[i_7_]);
        }
        Model class40_sub5_sub17_sub5 = new Model(class40_sub5_sub17_sub5s, i);
        for (int i_8_ = 0; i_8_ < 6 && this.recolorToFind[i_8_] != 0; ++i_8_) {
            class40_sub5_sub17_sub5.replaceColor(this.recolorToFind[i_8_], this.recolorToReplace[i_8_]);
        }
        return class40_sub5_sub17_sub5;
    }

    public Model getBodyModel() {
        if (this.modelId == null) {
            return null;
        }
        Model[] models = new Model[this.modelId.length];
        for (int i = 0; i < this.modelId.length; ++i) {
            models[i] = Model.getModel(modelArchive, this.modelId[i]);
        }
        Model model = models.length == 1 ? models[0] : new Model(models, models.length);
        for (int i = 0; i < 6 && this.recolorToFind[i] != 0; ++i) {
            model.replaceColor(this.recolorToFind[i], this.recolorToReplace[i]);
        }
        return model;
    }

    @Override
    public int getId() {
        return this.id;
    }

    static {
        identityKitCache = new NodeCache(64);
    }
}

