/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def;

import java.io.IOException;
import org.runejs.OldEngine.ObjectDecompressor;
import org.runejs.client.MovedStatics;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.EntityDefinition;
import org.runejs.client.cache.def.VarPlayerDefinition;
import org.runejs.client.cache.def.VarbitDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.cache.def.loading.rs435.GameObjectDefinitionLoader;
import org.runejs.client.cache.media.AnimationSequence;
import org.runejs.client.io.Buffer;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;
import org.runejs.client.scene.InteractiveObjectTemporary;

public class GameObjectDefinition
extends CachedNode
implements EntityDefinition {
    public static DefinitionLoader<GameObjectDefinition> loader = new GameObjectDefinitionLoader();
    public static int count;
    public static int[] OBJECT_TYPES;
    private static boolean lowMemory;
    private static CacheArchive definitionArchive;
    private static CacheArchive modelArchive;
    private static NodeCache definitionCache;
    private static NodeCache modelCacheStatic;
    private static Model[] objectModelHolder;
    private static NodeCache modelCacheDynamic;
    private static NodeCache animatedObjectModelCache;
    public int unkn1 = 0;
    public int offsetX = 0;
    public boolean solid = true;
    public int ambientSoundHearDistance = 0;
    public int sizeX = 1;
    public int offsetY = 0;
    public int setDecorDisplacement = 16;
    public int animationId = -1;
    public int modelSizeX = 128;
    public String[] actions = new String[5];
    public int[] recolorToReplace;
    public int icon = -1;
    public int blockingMask = 0;
    public int ambientSoundId = -1;
    public int sizeY = 1;
    public int[] recolorToFind;
    public int modelSizeY = 128;
    public boolean hollow = false;
    public int offsetHeight = 0;
    public boolean nonFlatShading = false;
    public boolean wall = false;
    public int[] objectTypes;
    public int[] soundEffectIds;
    public int[] objectModels;
    public int ambient = 0;
    public boolean walkable = true;
    public boolean adjustToTerrain = false;
    public int supportsItems = -1;
    public int[] childIds;
    public int configId = -1;
    public int mapSceneID = -1;
    public int id;
    public int modelSizeHeight = 128;
    public boolean castsShadow = true;
    public int unkn2 = 0;
    public int contrast = 0;
    public int hasActions = -1;
    public boolean obstructsGround = false;
    public int varbitId = -1;
    public String name = "null";
    public boolean rotated = false;

    public static void addTemporaryObject(int objectId, int x, int orientation, int duration, int plane, int y, int typeKey, int type, int delay) {
        InteractiveObjectTemporary obj = null;
        InteractiveObjectTemporary other = (InteractiveObjectTemporary)MovedStatics.interactiveObjectTemporaryNodeCache.peekFirst();
        while (other != null) {
            if (other.plane == plane && x == other.x && other.y == y && other.typeKey == typeKey) {
                obj = other;
                break;
            }
            other = (InteractiveObjectTemporary)MovedStatics.interactiveObjectTemporaryNodeCache.pollFirst();
        }
        if (obj == null) {
            obj = new InteractiveObjectTemporary();
            obj.x = x;
            obj.typeKey = typeKey;
            obj.plane = plane;
            obj.y = y;
            InteractiveObjectTemporary.setPrevousObjectDetails(obj);
            MovedStatics.interactiveObjectTemporaryNodeCache.addLast(obj);
        }
        obj.id = objectId;
        obj.duration = duration;
        obj.delay = delay;
        obj.orientation = orientation;
        obj.type = type;
    }

    public static GameObjectDefinition getDefinition(int id) {
        GameObjectDefinition gameObjectDefinition = (GameObjectDefinition)definitionCache.get(id);
        if (gameObjectDefinition != null) {
            return gameObjectDefinition;
        }
        byte[] data = definitionArchive.getFile(6, id);
        gameObjectDefinition = new GameObjectDefinition();
        gameObjectDefinition.id = id;
        if (data == null) {
            try {
                Buffer buffer = ObjectDecompressor.grabObjectDef(id);
                if (buffer != null) {
                    loader.load(gameObjectDefinition, buffer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            loader.load(gameObjectDefinition, new Buffer(data));
        }
        gameObjectDefinition.method605();
        if (gameObjectDefinition.hollow) {
            gameObjectDefinition.solid = false;
            gameObjectDefinition.walkable = false;
        }
        definitionCache.put(id, gameObjectDefinition);
        return gameObjectDefinition;
    }

    public static void clearGameObjectModelCache() {
        definitionCache.clear();
        modelCacheStatic.clear();
        modelCacheDynamic.clear();
        animatedObjectModelCache.clear();
    }

    public static void clearStaticModelCache() {
        modelCacheStatic.clear();
    }

    public static void initializeGameObjectDefinitionCache(CacheArchive modelCache, boolean lowMemory, CacheArchive definitionCache) {
        definitionArchive = definitionCache;
        count = definitionArchive.fileLength(6);
        GameObjectDefinition.lowMemory = lowMemory;
        modelArchive = modelCache;
    }

    public static boolean isObjectLoaded(int type, int id) {
        GameObjectDefinition gameObjectDefinition = GameObjectDefinition.getDefinition(id);
        if (type == 11) {
            type = 10;
        }
        if (type >= 5 && type <= 8) {
            type = 4;
        }
        return gameObjectDefinition.isTypeModelLoaded(type);
    }

    public Model createTerrainObjectModel(int arg0, int arg1, int arg2, int arg3, int arg4, int arg6) {
        long l = this.objectTypes == null ? (long)((this.id << 10) + arg2) : (long)(arg2 + (this.id << 10) + (arg4 << 3));
        Model model = (Model)modelCacheDynamic.get(l);
        if (model == null) {
            model = this.createObjectModel(!this.nonFlatShading, false, arg2, arg4);
            if (model == null) {
                return null;
            }
            modelCacheDynamic.put(l, model);
        }
        if (this.adjustToTerrain || this.nonFlatShading) {
            model = new Model(this.adjustToTerrain, this.nonFlatShading, model);
        }
        if (this.adjustToTerrain) {
            int i = (arg0 + arg6 + arg3 + arg1) / 4;
            int i_0_ = 0;
            while (model.vertexCount > i_0_) {
                int i_1_ = model.verticesX[i_0_];
                int i_2_ = model.verticesZ[i_0_];
                int i_3_ = arg3 + (64 + i_1_) * (arg6 + -arg3) / 128;
                int i_4_ = arg1 + (64 + i_1_) * (-arg1 + arg0) / 128;
                int i_5_ = i_3_ + (i_2_ + 64) * (-i_3_ + i_4_) / 128;
                int n = i_0_++;
                model.verticesY[n] = model.verticesY[n] + (i_5_ + -i);
            }
        }
        return model;
    }

    public boolean hasSounds() {
        if (this.childIds == null) {
            return this.ambientSoundId != -1 || this.soundEffectIds != null;
        }
        for (int i = 0; i < this.childIds.length; ++i) {
            if (this.childIds[i] == -1) continue;
            GameObjectDefinition gameObjectDefinition = GameObjectDefinition.getDefinition(this.childIds[i]);
            if (gameObjectDefinition.ambientSoundId == -1 && gameObjectDefinition.soundEffectIds == null) continue;
            return true;
        }
        return false;
    }

    public void method605() {
        if (this.hasActions == -1) {
            this.hasActions = 0;
            if (this.objectModels != null && (this.objectTypes == null || this.objectTypes[0] == 10)) {
                this.hasActions = 1;
            }
            for (int i = 0; i < 5; ++i) {
                if (this.actions[i] == null) continue;
                this.hasActions = 1;
                break;
            }
        }
        if (this.supportsItems == -1) {
            this.supportsItems = this.solid ? 1 : 0;
        }
    }

    public Model createObjectModel(boolean shaded, boolean hasBones, int orientation, int objectType) {
        boolean bool;
        Model model = null;
        if (this.objectTypes == null) {
            if (objectType != 10) {
                return null;
            }
            if (this.objectModels == null) {
                return null;
            }
            bool = orientation > 3 ^ this.rotated;
            int modelCount = this.objectModels.length;
            for (int modelIndex = 0; modelCount > modelIndex; ++modelIndex) {
                int modelId = this.objectModels[modelIndex];
                if (bool) {
                    modelId += 65536;
                }
                if ((model = (Model)modelCacheStatic.get(modelId)) == null) {
                    model = Model.getModel(modelArchive, modelId & 0xFFFF);
                    if (model == null) {
                        return null;
                    }
                    if (bool) {
                        model.method818();
                    }
                    modelCacheStatic.put(modelId, model);
                }
                if (modelCount <= 1) continue;
                GameObjectDefinition.objectModelHolder[modelIndex] = model;
            }
            if (modelCount > 1) {
                model = new Model(objectModelHolder, modelCount);
            }
        } else {
            int objectTypeIndex = -1;
            for (int typeIndex = 0; this.objectTypes.length > typeIndex; ++typeIndex) {
                if (objectType != this.objectTypes[typeIndex]) continue;
                objectTypeIndex = typeIndex;
                break;
            }
            if (objectTypeIndex == -1) {
                return null;
            }
            int modelId = this.objectModels[objectTypeIndex];
            boolean bool2 = this.rotated ^ orientation > 3;
            if (bool2) {
                modelId += 65536;
            }
            if ((model = (Model)modelCacheStatic.get(modelId)) == null) {
                model = Model.getModel(modelArchive, 0xFFFF & modelId);
                if (model == null) {
                    return null;
                }
                if (bool2) {
                    model.method818();
                }
                modelCacheStatic.put(modelId, model);
            }
        }
        bool = this.modelSizeX != 128 || this.modelSizeHeight != 128 || this.modelSizeY != 128;
        boolean bool_11_ = this.offsetX != 0 || this.offsetHeight != 0 || this.offsetY != 0;
        Model finalModel = new Model(model, orientation == 0 && !bool && !bool_11_, this.recolorToFind == null, true);
        if ((orientation &= 3) == 1) {
            finalModel.method813();
        } else if (orientation == 2) {
            finalModel.method819();
        } else if (orientation == 3) {
            finalModel.method824();
        }
        if (this.recolorToFind != null) {
            for (int i = 0; i < this.recolorToFind.length; ++i) {
                finalModel.replaceColor(this.recolorToFind[i], this.recolorToReplace[i]);
            }
        }
        if (bool) {
            finalModel.scaleT(this.modelSizeX, this.modelSizeHeight, this.modelSizeY);
        }
        if (bool_11_) {
            finalModel.translate(this.offsetX, this.offsetHeight, this.offsetY);
        }
        if (hasBones) {
            finalModel.createBones();
        }
        finalModel.applyLighting(this.ambient + 64, 768 + this.contrast * 5, -50, -10, -50, shaded);
        return finalModel;
    }

    public Model createAnimatedObjectModel(int vertexHeight, int vertexHeightRight, int arg3, int objectType, int orientation, AnimationSequence animationSequence, int vertexHeightTop, int vertexHeightTopRight) {
        long l = this.objectTypes == null ? (long)(orientation + (this.id << 10)) : (long)(orientation + (this.id << 10) + (objectType << 3));
        Model model = (Model)animatedObjectModelCache.get(l);
        if (model == null) {
            model = this.createObjectModel(true, true, orientation, objectType);
            if (model == null) {
                return null;
            }
            animatedObjectModelCache.put(l, model);
        }
        if (animationSequence == null && !this.adjustToTerrain) {
            return model;
        }
        model = animationSequence == null ? model.method817(true) : animationSequence.method593(arg3, false, model, orientation);
        if (this.adjustToTerrain) {
            int i = (vertexHeightRight + vertexHeight - (-vertexHeightTopRight + -vertexHeightTop)) / 4;
            int i_13_ = 0;
            while (i_13_ < model.vertexCount) {
                int i_14_ = model.verticesZ[i_13_];
                int i_15_ = model.verticesX[i_13_];
                int i_16_ = vertexHeight + (64 + i_15_) * (vertexHeightRight - vertexHeight) / 128;
                int i_17_ = vertexHeightTop + (64 + i_15_) * (vertexHeightTopRight + -vertexHeightTop) / 128;
                int i_18_ = i_16_ + (i_14_ + 64) * (-i_16_ + i_17_) / 128;
                int n = i_13_++;
                model.verticesY[n] = model.verticesY[n] + (-i + i_18_);
            }
        }
        return model;
    }

    public boolean isTypeModelLoaded(int type) {
        if (this.objectTypes != null) {
            for (int i = 0; this.objectTypes.length > i; ++i) {
                if (this.objectTypes[i] != type) continue;
                return modelArchive.loaded(this.objectModels[i] & 0xFFFF, 0);
            }
            return true;
        }
        if (this.objectModels == null) {
            return true;
        }
        if (type != 10) {
            return true;
        }
        boolean bool = true;
        for (int i = 0; this.objectModels.length > i; ++i) {
            bool &= modelArchive.loaded(0xFFFF & this.objectModels[i], 0);
        }
        return bool;
    }

    public GameObjectDefinition getChildDefinition() {
        int index = -1;
        if (this.varbitId == -1) {
            if (this.configId != -1) {
                index = VarPlayerDefinition.varPlayers[this.configId];
            }
        } else {
            index = VarbitDefinition.getVarbitValue(this.varbitId);
        }
        if (index < 0 || this.childIds.length <= index || this.childIds[index] == -1) {
            return null;
        }
        return GameObjectDefinition.getDefinition(this.childIds[index]);
    }

    public boolean method612() {
        if (this.objectModels == null) {
            return true;
        }
        boolean bool = true;
        for (int i = 0; this.objectModels.length > i; ++i) {
            bool &= modelArchive.loaded(0xFFFF & this.objectModels[i], 0);
        }
        return bool;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        OBJECT_TYPES = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3};
        lowMemory = false;
        definitionCache = new NodeCache(64);
        modelCacheStatic = new NodeCache(500);
        objectModelHolder = new Model[4];
        modelCacheDynamic = new NodeCache(10);
        animatedObjectModelCache = new NodeCache(30);
    }
}

