/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache.def;

import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.def.EntityDefinition;
import org.runejs.client.cache.def.VarPlayerDefinition;
import org.runejs.client.cache.def.VarbitDefinition;
import org.runejs.client.cache.def.loading.DefinitionLoader;
import org.runejs.client.cache.def.loading.rs435.ActorDefinitionLoader;
import org.runejs.client.cache.media.AnimationSequence;
import org.runejs.client.io.Buffer;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.node.CachedNode;
import org.runejs.client.node.NodeCache;

public class ActorDefinition
extends CachedNode
implements EntityDefinition {
    private static DefinitionLoader<ActorDefinition> loader = new ActorDefinitionLoader();
    public static int count;
    private static NodeCache actorDefinitionCache;
    private static NodeCache actorModelCache;
    private static CacheArchive actorDefinitionArchive;
    private static CacheArchive actorModelArchive;
    public boolean isClickable = true;
    public int boundaryDimension = 1;
    public int[] headModelIndexes;
    public String[] options = new String[5];
    public int headIcon = -1;
    public int stanceAnimation = -1;
    public int varPlayerIndex = -1;
    public int ambient = 0;
    public int rotateRightAnimation = -1;
    public int degreesToTurn = 32;
    public int combatLevel = -1;
    public int[] originalModelColors;
    public boolean hasRenderPriority = false;
    public String name = "null";
    public int[] models;
    public int rotate180Animation = -1;
    public int resizeX = 128;
    public int contrast = 0;
    public int varbitId = -1;
    public int rotate90LeftAnimation = -1;
    public int resizeY = 128;
    public int rotate90RightAnimation = -1;
    public int rotateLeftAnimation = -1;
    public int walkAnimation = -1;
    public int[] childIds;
    public int id;
    public int[] modifiedModelColors;
    public boolean renderOnMinimap = true;

    public static ActorDefinition getDefinition(int id) {
        ActorDefinition definition = (ActorDefinition)actorDefinitionCache.get(id);
        if (definition != null) {
            return definition;
        }
        byte[] data = actorDefinitionArchive.getFile(9, id);
        definition = new ActorDefinition();
        definition.id = id;
        if (data != null) {
            loader.load(definition, new Buffer(data));
        }
        actorDefinitionCache.put(id, definition);
        return definition;
    }

    public static void clearActorCache() {
        actorDefinitionCache.clear();
        actorModelCache.clear();
    }

    public static void initializeActorCache(CacheArchive models, CacheArchive definitions) {
        actorDefinitionArchive = definitions;
        count = actorDefinitionArchive.fileLength(9);
        actorModelArchive = models;
    }

    public Model getChildModel(AnimationSequence animation1, AnimationSequence animation2, int arg3, int arg4) {
        if (this.childIds != null) {
            ActorDefinition actorDefinition = this.getChildDefinition();
            if (actorDefinition == null) {
                return null;
            }
            return actorDefinition.getChildModel(animation1, animation2, arg3, arg4);
        }
        Model model1 = (Model)actorModelCache.get(this.id);
        if (model1 == null) {
            int i;
            boolean bool = false;
            for (int model : this.models) {
                if (actorModelArchive.loaded(model, 0)) continue;
                bool = true;
            }
            if (bool) {
                return null;
            }
            Model[] class40_sub5_sub17_sub5s = new Model[this.models.length];
            for (i = 0; this.models.length > i; ++i) {
                class40_sub5_sub17_sub5s[i] = Model.getModel(actorModelArchive, this.models[i]);
            }
            model1 = class40_sub5_sub17_sub5s.length == 1 ? class40_sub5_sub17_sub5s[0] : new Model(class40_sub5_sub17_sub5s, class40_sub5_sub17_sub5s.length);
            if (this.modifiedModelColors != null) {
                for (i = 0; i < this.modifiedModelColors.length; ++i) {
                    assert (model1 != null);
                    model1.replaceColor(this.modifiedModelColors[i], this.originalModelColors[i]);
                }
            }
            assert (model1 != null);
            model1.createBones();
            model1.applyLighting(this.ambient + 64, 850 + this.contrast, -30, -50, -30, true);
            actorModelCache.put(this.id, model1);
        }
        Model class40_sub5_sub17_sub5_0_ = animation1 != null && animation2 != null ? animation1.method590(model1, animation2, arg4, arg3, (byte)63) : (animation1 != null ? animation1.method599(arg4, model1, false) : (animation2 == null ? model1.method817(true) : animation2.method599(arg3, model1, false)));
        if (this.resizeX != 128 || this.resizeY != 128) {
            class40_sub5_sub17_sub5_0_.scaleT(this.resizeX, this.resizeY, this.resizeX);
        }
        return class40_sub5_sub17_sub5_0_;
    }

    public boolean isVisible() {
        if (this.childIds == null) {
            return true;
        }
        int index = -1;
        if (this.varbitId != -1) {
            index = VarbitDefinition.getVarbitValue(this.varbitId);
        } else if (this.varPlayerIndex != -1) {
            index = VarPlayerDefinition.varPlayers[this.varPlayerIndex];
        }
        return index >= 0 && this.childIds.length > index && this.childIds[index] != -1;
    }

    public Model getHeadModel() {
        if (this.childIds != null) {
            ActorDefinition definition = this.getChildDefinition();
            if (definition == null) {
                return null;
            }
            return definition.getHeadModel();
        }
        if (this.headModelIndexes == null) {
            return null;
        }
        boolean cached = false;
        for (int headModelIndex : this.headModelIndexes) {
            if (actorModelArchive.loaded(headModelIndex, 0)) continue;
            cached = true;
        }
        if (cached) {
            return null;
        }
        Model[] models = new Model[this.headModelIndexes.length];
        for (int i = 0; i < this.headModelIndexes.length; ++i) {
            models[i] = Model.getModel(actorModelArchive, this.headModelIndexes[i]);
        }
        Model headModel = models.length == 1 ? models[0] : new Model(models, models.length);
        if (this.modifiedModelColors != null) {
            for (int i = 0; i < this.modifiedModelColors.length; ++i) {
                assert (headModel != null);
                headModel.replaceColor(this.modifiedModelColors[i], this.originalModelColors[i]);
            }
        }
        return headModel;
    }

    public ActorDefinition getChildDefinition() {
        int childId = -1;
        if (this.varbitId != -1) {
            childId = VarbitDefinition.getVarbitValue(this.varbitId);
        } else if (this.varPlayerIndex != -1) {
            childId = VarPlayerDefinition.varPlayers[this.varPlayerIndex];
        }
        if (childId < 0 || childId >= this.childIds.length || this.childIds[childId] == -1) {
            return null;
        }
        return ActorDefinition.getDefinition(this.childIds[childId]);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        actorDefinitionCache = new NodeCache(64);
        actorModelCache = new NodeCache(50);
    }
}

