/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache;

public class NameHashCollection {
    private static final int NOT_FOUND = -1;
    private int[] hashTable;

    public NameHashCollection(int[] nameHashes) {
        int size = this.calculateInitialSize(nameHashes.length);
        this.hashTable = new int[size * 2];
        for (int i = 0; this.hashTable.length > i; ++i) {
            this.hashTable[i] = -1;
        }
        this.populateHashTable(size, nameHashes);
    }

    public int getIdByName(int nameHash) {
        int size = this.hashTable.length - 2;
        int current = nameHash << 1 & size;
        while (this.hashTable[current] != -1) {
            if (this.hashTable[current] == nameHash) {
                return this.hashTable[current + 1];
            }
            current = current + 2 & size;
        }
        return -1;
    }

    private void populateHashTable(int size, int[] nameHashes) {
        int nameHashIndex = 0;
        while (nameHashes.length > nameHashIndex) {
            int firstEmptySlot = this.findNextAvailableSlot(size, nameHashes[nameHashIndex]);
            this.hashTable[firstEmptySlot + firstEmptySlot] = nameHashes[nameHashIndex];
            this.hashTable[1 + firstEmptySlot + firstEmptySlot] = nameHashIndex++;
        }
    }

    private int findNextAvailableSlot(int size, int start) {
        int current = start & size - 1;
        while (this.hashTable[current * 2 + 1] != -1) {
            current = current + 1 & -1 + size;
        }
        return current;
    }

    private int calculateInitialSize(int length) {
        int size;
        for (size = 1; (length >> 1) + length >= size; size <<= 1) {
        }
        return size;
    }
}

