/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache;

import java.io.EOFException;
import java.io.IOException;
import org.runejs.client.cache.CacheFileChannel;

public class CacheIndex {
    public static byte[] buffer = new byte[520];
    public final CacheFileChannel dataChannel;
    public final CacheFileChannel metaChannel;
    public int maxLength;
    public int store;

    public CacheIndex(int store, CacheFileChannel metaChannel, CacheFileChannel dataChannel, int maxLength) {
        this.maxLength = maxLength;
        this.metaChannel = metaChannel;
        this.dataChannel = dataChannel;
        this.store = store;
    }

    public String toString() {
        return "CacheIndex:" + this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(int file) {
        CacheFileChannel cacheFileChannel = this.dataChannel;
        synchronized (cacheFileChannel) {
            try {
                if (this.metaChannel.getSize() < (long)file * 6L + 6L) {
                    return null;
                }
                this.metaChannel.seek((long)file * 6L);
                this.metaChannel.read(buffer, 0, 6);
                int sector = (0xFF00 & buffer[4] << 8) + ((0xFF & buffer[3]) << 16) + (0xFF & buffer[5]);
                int size = (0xFF & buffer[2]) + ((buffer[0] & 0xFF) << 16) + ((0xFF & buffer[1]) << 8);
                if (size < 0 || size > this.maxLength) {
                    return null;
                }
                if (sector <= 0 || this.dataChannel.getSize() / 520L < (long)sector) {
                    return null;
                }
                int position = 0;
                int part = 0;
                byte[] data = new byte[size];
                while (size > position) {
                    if (sector == 0) {
                        return null;
                    }
                    this.dataChannel.seek((long)sector * 520L);
                    int available = size - position;
                    if (available > 512) {
                        available = 512;
                    }
                    this.dataChannel.read(buffer, 0, 8 + available);
                    int sectorFile = (0xFF00 & buffer[0] << 8) + (0xFF & buffer[1]);
                    int nextSector = (buffer[6] & 0xFF) + ((0xFF & buffer[5]) << 8) + ((0xFF & buffer[4]) << 16);
                    int sectorPart = (0xFF00 & buffer[2] << 8) + (0xFF & buffer[3]);
                    int sectorStore = 0xFF & buffer[7];
                    if (file != sectorFile || part != sectorPart || this.store != sectorStore) {
                        return null;
                    }
                    if (nextSector < 0 || this.dataChannel.getSize() / 520L < (long)nextSector) {
                        return null;
                    }
                    for (int i = 0; i < available; ++i) {
                        data[position++] = buffer[8 + i];
                    }
                    ++part;
                    sector = nextSector;
                }
                return data;
            }
            catch (IOException ioexception) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(byte[] buffer, int file, int length, boolean overwrite) {
        CacheFileChannel cacheFileChannel = this.dataChannel;
        synchronized (cacheFileChannel) {
            try {
                int sector;
                if (overwrite) {
                    if (this.metaChannel.getSize() < (long)file * 6L + 6L) {
                        return false;
                    }
                    this.metaChannel.seek((long)file * 6L);
                    this.metaChannel.read(CacheIndex.buffer, 0, 6);
                    sector = (CacheIndex.buffer[5] & 0xFF) + ((CacheIndex.buffer[3] & 0xFF) << 16) + ((CacheIndex.buffer[4] & 0xFF) << 8);
                    if (sector <= 0 || this.dataChannel.getSize() / 520L < (long)sector) {
                        return false;
                    }
                } else {
                    sector = (int)((519L + this.dataChannel.getSize()) / 520L);
                    if (sector == 0) {
                        sector = 1;
                    }
                }
                CacheIndex.buffer[0] = (byte)(length >> 16);
                CacheIndex.buffer[1] = (byte)(length >> 8);
                CacheIndex.buffer[2] = (byte)length;
                CacheIndex.buffer[3] = (byte)(sector >> 16);
                CacheIndex.buffer[4] = (byte)(sector >> 8);
                CacheIndex.buffer[5] = (byte)sector;
                this.metaChannel.seek(file * 6);
                this.metaChannel.write(CacheIndex.buffer, 0, 6);
                int written = 0;
                int part = 0;
                while (written < length) {
                    int nextSector = 0;
                    if (overwrite) {
                        this.dataChannel.seek(520 * sector);
                        try {
                            this.dataChannel.read(CacheIndex.buffer, 0, 8);
                        }
                        catch (EOFException eofexception) {
                            break;
                        }
                        nextSector = (CacheIndex.buffer[6] & 0xFF) + (CacheIndex.buffer[4] << 16 & 0xFF0000) + (0xFF00 & CacheIndex.buffer[5] << 8);
                        int sectorFile = (CacheIndex.buffer[1] & 0xFF) + (CacheIndex.buffer[0] << 8 & 0xFF00);
                        int sectorStore = CacheIndex.buffer[7] & 0xFF;
                        int sectorPart = (CacheIndex.buffer[3] & 0xFF) + ((0xFF & CacheIndex.buffer[2]) << 8);
                        if (file != sectorFile || part != sectorPart || this.store != sectorStore) {
                            return false;
                        }
                        if (nextSector < 0 || this.dataChannel.getSize() / 520L < (long)nextSector) {
                            return false;
                        }
                    }
                    if (nextSector == 0) {
                        overwrite = false;
                        nextSector = (int)((519L + this.dataChannel.getSize()) / 520L);
                        if (nextSector == 0) {
                            ++nextSector;
                        }
                        if (sector == nextSector) {
                            ++nextSector;
                        }
                    }
                    if (length - written <= 512) {
                        nextSector = 0;
                    }
                    CacheIndex.buffer[0] = (byte)(file >> 8);
                    CacheIndex.buffer[1] = (byte)file;
                    CacheIndex.buffer[2] = (byte)(part >> 8);
                    CacheIndex.buffer[3] = (byte)part;
                    CacheIndex.buffer[4] = (byte)(nextSector >> 16);
                    CacheIndex.buffer[5] = (byte)(nextSector >> 8);
                    CacheIndex.buffer[6] = (byte)nextSector;
                    CacheIndex.buffer[7] = (byte)this.store;
                    this.dataChannel.seek(520 * sector);
                    this.dataChannel.write(CacheIndex.buffer, 0, 8);
                    int available = length - written;
                    if (available > 512) {
                        available = 512;
                    }
                    this.dataChannel.write(buffer, written, available);
                    written += available;
                    sector = nextSector;
                    ++part;
                }
                return true;
            }
            catch (IOException ioexception) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(byte[] data, int file, int length) {
        CacheFileChannel cacheFileChannel = this.dataChannel;
        synchronized (cacheFileChannel) {
            if (length < 0 || length > this.maxLength) {
                throw new IllegalArgumentException();
            }
            boolean written = this.write(data, file, length, true);
            if (!written) {
                written = this.write(data, file, length, false);
            }
            return written;
        }
    }
}

