/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache;

import java.io.EOFException;
import java.io.IOException;
import org.runejs.client.MovedStatics;
import org.runejs.client.SizedAccessFile;

public class CacheFileChannel {
    public long readPointer;
    public long writeIndex;
    public byte[] readPayload;
    public int readPayloadLength;
    public byte[] writePayload;
    public long writePointer = -1L;
    public int writePayloadLength = 0;
    public long aLong1596 = -1L;
    public long accessFilePointer;
    public long size;
    public SizedAccessFile accessFile;

    public CacheFileChannel(SizedAccessFile accessFile, int bufferSize) throws IOException {
        this.accessFile = accessFile;
        this.size = this.writeIndex = accessFile.length();
        this.writePayload = new byte[0];
        this.readPayload = new byte[bufferSize];
        this.readPointer = 0L;
    }

    public void seek(long pointer) {
        if (pointer >= 0L) {
            this.readPointer = pointer;
        }
    }

    public long getSize() {
        return this.size;
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        try {
            if (this.size < (long)length + this.readPointer) {
                this.size = (long)length + this.readPointer;
            }
            if (this.writePointer != -1L && (this.readPointer < this.writePointer || this.writePointer + (long)this.writePayloadLength < this.readPointer)) {
                this.save();
            }
            if (this.writePointer != -1L && this.writePointer + (long)this.writePayload.length < (long)length + this.readPointer) {
                int i = (int)(this.writePointer - (this.readPointer - (long)this.writePayload.length));
                length -= i;
                MovedStatics.copyBytes(b, offset, this.writePayload, (int)(this.readPointer - this.writePointer), i);
                this.readPointer += (long)i;
                this.writePayloadLength = this.writePayload.length;
                offset += i;
                this.save();
            }
            if (length > this.writePayload.length) {
                if (this.accessFilePointer != this.readPointer) {
                    this.accessFile.seek(this.readPointer);
                    this.accessFilePointer = this.readPointer;
                }
                this.accessFile.write(b, offset, length);
                this.accessFilePointer += (long)length;
                if (this.accessFilePointer > this.writeIndex) {
                    this.writeIndex = this.accessFilePointer;
                }
                long l = -1L;
                long l_0_ = -1L;
                if (this.readPointer >= this.aLong1596 && this.readPointer < (long)this.readPayloadLength + this.aLong1596) {
                    l_0_ = this.readPointer;
                } else if (this.readPointer <= this.aLong1596 && this.aLong1596 < this.readPointer + (long)length) {
                    l_0_ = this.aLong1596;
                }
                if (this.aLong1596 < this.readPointer + (long)length && this.aLong1596 + (long)this.readPayloadLength >= (long)length + this.readPointer) {
                    l = (long)length + this.readPointer;
                } else if (this.aLong1596 + (long)this.readPayloadLength > this.readPointer && (long)length + this.readPointer >= (long)this.readPayloadLength + this.aLong1596) {
                    l = (long)this.readPayloadLength + this.aLong1596;
                }
                if (l_0_ > -1L && l_0_ < l) {
                    int i = (int)(l - l_0_);
                    MovedStatics.copyBytes(b, (int)((long)offset + l_0_ - this.readPointer), this.readPayload, (int)(l_0_ + -this.aLong1596), i);
                }
                this.readPointer += (long)length;
            } else if (length > 0) {
                if (this.writePointer == -1L) {
                    this.writePointer = this.readPointer;
                }
                MovedStatics.copyBytes(b, offset, this.writePayload, (int)(this.readPointer - this.writePointer), length);
                this.readPointer += (long)length;
                if ((long)this.writePayloadLength < this.readPointer - this.writePointer) {
                    this.writePayloadLength = (int)(this.readPointer - this.writePointer);
                }
            }
        }
        catch (IOException ioexception) {
            this.accessFilePointer = -1L;
            throw ioexception;
        }
    }

    public void read(byte[] b, int offset, int length) throws IOException {
        try {
            if (offset + length > b.length) {
                throw new ArrayIndexOutOfBoundsException(length + offset - b.length);
            }
            if (this.writePointer != -1L && this.writePointer <= this.readPointer && (long)length + this.readPointer <= (long)this.writePayloadLength + this.writePointer) {
                MovedStatics.copyBytes(this.writePayload, (int)(this.readPointer - this.writePointer), b, offset, length);
                this.readPointer += (long)length;
                return;
            }
            int i = length;
            long l = this.readPointer;
            int i_2_ = offset;
            if (this.readPointer >= this.aLong1596 && (long)this.readPayloadLength + this.aLong1596 > this.readPointer) {
                int i_3_ = (int)((long)this.readPayloadLength + -this.readPointer + this.aLong1596);
                if (i_3_ > length) {
                    i_3_ = length;
                }
                MovedStatics.copyBytes(this.readPayload, (int)(-this.aLong1596 + this.readPointer), b, offset, i_3_);
                offset += i_3_;
                this.readPointer += (long)i_3_;
                length -= i_3_;
            }
            if (length <= this.readPayload.length) {
                if (length > 0) {
                    int i_4_ = length;
                    this.readRemaining();
                    if (i_4_ > this.readPayloadLength) {
                        i_4_ = this.readPayloadLength;
                    }
                    MovedStatics.copyBytes(this.readPayload, 0, b, offset, i_4_);
                    this.readPointer += (long)i_4_;
                    offset += i_4_;
                    length -= i_4_;
                }
            } else {
                int i_5_;
                this.accessFile.seek(this.readPointer);
                this.accessFilePointer = this.readPointer;
                while (length > 0 && (i_5_ = this.accessFile.read(b, length, offset)) != -1) {
                    this.readPointer += (long)i_5_;
                    this.accessFilePointer += (long)i_5_;
                    offset += i_5_;
                    length -= i_5_;
                }
            }
            if (this.writePointer != -1L) {
                if (this.writePointer > this.readPointer && length > 0) {
                    int i_6_ = (int)(-this.readPointer + this.writePointer) + offset;
                    if (i_6_ > offset + length) {
                        i_6_ = offset + length;
                    }
                    while (offset < i_6_) {
                        --length;
                        b[offset++] = 0;
                        ++this.readPointer;
                    }
                }
                long l_7_ = -1L;
                if (l < this.writePointer + (long)this.writePayloadLength && this.writePointer + (long)this.writePayloadLength <= (long)i + l) {
                    l_7_ = (long)this.writePayloadLength + this.writePointer;
                } else if (l + (long)i > this.writePointer && l + (long)i <= (long)this.writePayloadLength + this.writePointer) {
                    l_7_ = (long)i + l;
                }
                long l_8_ = -1L;
                if (this.writePointer < l || this.writePointer >= (long)i + l) {
                    if (this.writePointer <= l && l < this.writePointer + (long)this.writePayloadLength) {
                        l_8_ = l;
                    }
                } else {
                    l_8_ = this.writePointer;
                }
                if (l_8_ > -1L && l_7_ > l_8_) {
                    int i_9_ = (int)(-l_8_ + l_7_);
                    MovedStatics.copyBytes(this.writePayload, (int)(l_8_ - this.writePointer), b, (int)(-l + l_8_) + i_2_, i_9_);
                    if (this.readPointer < l_7_) {
                        length = (int)((long)length - (l_7_ - this.readPointer));
                        this.readPointer = l_7_;
                    }
                }
            }
        }
        catch (IOException ioexception) {
            this.accessFilePointer = -1L;
            throw ioexception;
        }
        if (length > 0) {
            throw new EOFException();
        }
    }

    public void close() throws IOException {
        this.save();
        this.accessFile.close();
    }

    public void readRemaining() throws IOException {
        int read;
        this.readPayloadLength = 0;
        if (this.readPointer != this.accessFilePointer) {
            this.accessFile.seek(this.readPointer);
            this.accessFilePointer = this.readPointer;
        }
        this.aLong1596 = this.readPointer;
        while (this.readPayloadLength < this.readPayload.length && (read = this.accessFile.read(this.readPayload, this.readPayload.length - this.readPayloadLength, this.readPayloadLength)) != -1) {
            this.accessFilePointer += (long)read;
            this.readPayloadLength += read;
        }
    }

    public void save() throws IOException {
        if (this.writePointer != -1L) {
            if (this.writePointer != this.accessFilePointer) {
                this.accessFile.seek(this.writePointer);
                this.accessFilePointer = this.writePointer;
            }
            this.accessFile.write(this.writePayload, 0, this.writePayloadLength);
            this.accessFilePointer += (long)this.writePayloadLength;
            if (this.accessFilePointer > this.writeIndex) {
                this.writeIndex = this.accessFilePointer;
            }
            long l = -1L;
            if (this.aLong1596 > this.writePointer || this.aLong1596 + (long)this.readPayloadLength <= this.writePointer) {
                if (this.writePointer <= this.aLong1596 && this.writePointer + (long)this.writePayloadLength > this.aLong1596) {
                    l = this.aLong1596;
                }
            } else {
                l = this.writePointer;
            }
            long l_10_ = -1L;
            if ((long)this.writePayloadLength + this.writePointer <= this.aLong1596 || (long)this.readPayloadLength + this.aLong1596 < this.writePointer + (long)this.writePayloadLength) {
                if (this.writePointer < (long)this.readPayloadLength + this.aLong1596 && this.aLong1596 + (long)this.readPayloadLength <= (long)this.writePayloadLength + this.writePointer) {
                    l_10_ = (long)this.readPayloadLength + this.aLong1596;
                }
            } else {
                l_10_ = this.writePointer + (long)this.writePayloadLength;
            }
            if (l > -1L && l < l_10_) {
                int i = (int)(-l + l_10_);
                MovedStatics.copyBytes(this.writePayload, (int)(l - this.writePointer), this.readPayload, (int)(l - this.aLong1596), i);
            }
            this.writePayloadLength = 0;
            this.writePointer = -1L;
        }
    }
}

