/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.cache;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import org.runejs.client.Game;
import org.runejs.client.LinkedList;
import org.runejs.client.MovedStatics;
import org.runejs.client.OnDemandRequestProcessor;
import org.runejs.client.RSString;
import org.runejs.client.cache.CacheIndex;
import org.runejs.client.cache.NameHashCollection;
import org.runejs.client.cache.bzip.BZip;
import org.runejs.client.io.Buffer;
import org.runejs.client.node.OnDemandRequest;

public class CacheArchive {
    public static CRC32 crc32 = new CRC32();
    public static CacheArchive gameInterfaceCacheArchive;
    public static CacheArchive gameDefinitionsCacheArchive;
    public static CacheArchive skeletonCacheArchive;
    public static CacheArchive skinDefinitionCacheArchive;
    public static CacheArchive soundEffectCacheArchive;
    public static CacheArchive gameWorldMapCacheArchive;
    public static CacheArchive musicCacheArchive;
    public static CacheArchive modelCacheArchive;
    public static CacheArchive gameImageCacheArchive;
    public static CacheArchive gameTextureCacheArchive;
    public static CacheArchive huffmanCacheArchive;
    public static CacheArchive jingleCacheArchive;
    public static CacheArchive clientScriptCacheArchive;
    public byte[][] groupContentCache;
    public int crc8;
    public NameHashCollection[] fileNames;
    public boolean clearEncryptableContent;
    public int size;
    public int[] groupVersions;
    public int[] groupIds;
    public boolean clearGroupContentCache;
    public int[][] fileNameHashes;
    public int[] nameHashes;
    public int[][] fileIds;
    public byte[][][] fileContentCache;
    public int[] groupChecksums;
    public NameHashCollection groupNames;
    public int[] groupSizes;
    public volatile boolean[] hasValidContents;
    public int lastReceivedGroupRequest = -1;
    public volatile boolean finishedReceiving = false;
    public CacheIndex idx255;
    public int cacheIndexId;
    public int archiveCrcValue;
    public boolean forceHighPriority;
    public CacheIndex dataIndex;

    public CacheArchive(int cacheIndexId, CacheIndex idx255, CacheIndex dataIndex, boolean clearGroupContentCache, boolean clearEncryptableContent, boolean forceHighPriority) {
        this.clearEncryptableContent = clearEncryptableContent;
        this.clearGroupContentCache = clearGroupContentCache;
        this.dataIndex = dataIndex;
        this.forceHighPriority = forceHighPriority;
        this.idx255 = idx255;
        this.cacheIndexId = cacheIndexId;
        Game.updateServerConnectionManager.updateServer.requestArchiveChecksum(this, this.cacheIndexId);
    }

    public static byte[] decompress(byte[] cacheData) {
        Buffer buffer = new Buffer(cacheData);
        int type = buffer.getUnsignedByte();
        int length = buffer.getIntBE();
        if (length < 0) {
            throw new RuntimeException();
        }
        if (type != 0) {
            int decompressedLength = buffer.getIntBE();
            if (decompressedLength < 0) {
                return new byte[100];
            }
            if (decompressedLength >= 2000000) {
                return new byte[100];
            }
            byte[] decompressed = new byte[decompressedLength];
            if (type != 1) {
                try {
                    DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(cacheData, 9, length)));
                    datainputstream.readFully(decompressed);
                    datainputstream.close();
                }
                catch (IOException error) {
                    error.printStackTrace();
                }
            } else {
                BZip.decompressBzip(decompressed, decompressedLength, cacheData, 9);
            }
            return decompressed;
        }
        byte[] decompressed = new byte[length];
        buffer.getBytes(length, 0, decompressed);
        return decompressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prioritiseDecodeGroup(CacheIndex index, int groupId) {
        byte[] dataFromQueue = null;
        LinkedList linkedList = OnDemandRequestProcessor.queue;
        synchronized (linkedList) {
            OnDemandRequest onDemandRequest = (OnDemandRequest)OnDemandRequestProcessor.queue.peekFirst();
            while (onDemandRequest != null) {
                if ((long)groupId == onDemandRequest.key && index == onDemandRequest.cacheIndex && onDemandRequest.type == 0) {
                    dataFromQueue = onDemandRequest.data;
                    break;
                }
                onDemandRequest = (OnDemandRequest)OnDemandRequestProcessor.queue.pollFirst();
            }
        }
        if (dataFromQueue == null) {
            byte[] dataFromIndex = index.read(groupId);
            this.attemptDecodeData(true, dataFromIndex, groupId, index);
        } else {
            this.attemptDecodeData(true, dataFromQueue, groupId, index);
        }
    }

    public int getIndexLoadedPercentage() {
        if (this.finishedReceiving) {
            return 100;
        }
        if (this.groupContentCache != null) {
            return 99;
        }
        return Math.min(99, Game.updateServerConnectionManager.updateServer.getLoadedPercentage(255, this.cacheIndexId));
    }

    public void attemptDecodeData(boolean highPriority, byte[] data, int key, CacheIndex cacheIndex) {
        if (cacheIndex == this.idx255) {
            if (this.finishedReceiving) {
                throw new RuntimeException();
            }
            if (data == null) {
                Game.updateServerConnectionManager.updateServer.enqueueFileRequest(this, 255, this.cacheIndexId, (byte)0, this.archiveCrcValue, true);
                return;
            }
            crc32.reset();
            crc32.update(data, 0, data.length);
            int actualChecksum = (int)crc32.getValue();
            if (actualChecksum != this.archiveCrcValue) {
                Game.updateServerConnectionManager.updateServer.enqueueFileRequest(this, 255, this.cacheIndexId, (byte)0, this.archiveCrcValue, true);
                return;
            }
            this.decodeIndex(data);
            this.postDecodeIndex();
            return;
        }
        if (!highPriority && this.lastReceivedGroupRequest == key) {
            this.finishedReceiving = true;
        }
        if (data == null || data.length <= 2) {
            this.hasValidContents[key] = false;
            if (this.forceHighPriority || highPriority) {
                Game.updateServerConnectionManager.updateServer.enqueueFileRequest(this, this.cacheIndexId, key, (byte)2, this.groupChecksums[key], highPriority);
            }
            return;
        }
        crc32.reset();
        crc32.update(data, 0, data.length - 2);
        int actualChecksum = (int)crc32.getValue();
        int actualVersion = ((data[data.length - 2] & 0xFF) << 8) + (0xFF & data[data.length - 1]);
        if (actualChecksum != this.groupChecksums[key] || actualVersion != this.groupVersions[key]) {
            this.hasValidContents[key] = false;
            if (this.forceHighPriority || highPriority) {
                Game.updateServerConnectionManager.updateServer.enqueueFileRequest(this, this.cacheIndexId, key, (byte)2, this.groupChecksums[key], highPriority);
            }
            return;
        }
        this.hasValidContents[key] = true;
        if (highPriority) {
            this.groupContentCache[key] = data;
        }
    }

    public void requestGroup(int groupId) {
        if (this.dataIndex != null && this.hasValidContents != null && this.hasValidContents[groupId]) {
            this.prioritiseDecodeGroup(this.dataIndex, groupId);
        } else {
            Game.updateServerConnectionManager.updateServer.enqueueFileRequest(this, this.cacheIndexId, groupId, (byte)2, this.groupChecksums[groupId], true);
        }
    }

    public void postDecodeIndex() {
        int i;
        this.hasValidContents = new boolean[this.groupContentCache.length];
        for (i = 0; i < this.hasValidContents.length; ++i) {
            this.hasValidContents[i] = false;
        }
        if (this.dataIndex == null) {
            this.finishedReceiving = true;
        } else {
            this.lastReceivedGroupRequest = -1;
            for (i = 0; this.hasValidContents.length > i; ++i) {
                if (this.groupSizes[i] <= 0) continue;
                OnDemandRequest.createCacheArchiveOnDemandRequest(i, this, this.dataIndex);
                this.lastReceivedGroupRequest = i;
            }
            if (this.lastReceivedGroupRequest == -1) {
                this.finishedReceiving = true;
            }
        }
    }

    public void receiveContent(boolean isIndex, int groupId, boolean highPriority, byte[] data) {
        if (isIndex) {
            if (this.finishedReceiving) {
                throw new RuntimeException();
            }
            if (this.idx255 != null) {
                OnDemandRequest.createByteArrayOnDemandRequest(data, this.idx255, this.cacheIndexId);
            }
            this.decodeIndex(data);
            this.postDecodeIndex();
        } else {
            data[data.length - 2] = (byte)(this.groupVersions[groupId] >> 8);
            data[data.length - 1] = (byte)this.groupVersions[groupId];
            if (this.dataIndex != null) {
                OnDemandRequest.createByteArrayOnDemandRequest(data, this.dataIndex, groupId);
                this.hasValidContents[groupId] = true;
            }
            if (highPriority) {
                this.groupContentCache[groupId] = data;
            }
        }
    }

    public void requestLatestVersion(int crcValue) {
        this.archiveCrcValue = crcValue;
        if (this.idx255 == null) {
            Game.updateServerConnectionManager.updateServer.enqueueFileRequest(this, 255, this.cacheIndexId, (byte)0, this.archiveCrcValue, true);
            return;
        }
        this.prioritiseDecodeGroup(this.idx255, this.cacheIndexId);
    }

    public int getGroupLoadedPercentage(int groupId) {
        if (this.groupContentCache[groupId] != null) {
            return 100;
        }
        if (this.hasValidContents[groupId]) {
            return 100;
        }
        return Game.updateServerConnectionManager.updateServer.getLoadedPercentage(this.cacheIndexId, groupId);
    }

    public int getGroupsLoadedPercentage() {
        int totalAvailablePercentage = 0;
        int totalPercentage = 0;
        for (int i = 0; i < this.groupContentCache.length; ++i) {
            if (this.groupSizes[i] <= 0) continue;
            totalAvailablePercentage += 100;
            totalPercentage += this.getGroupLoadedPercentage(i);
        }
        if (totalAvailablePercentage == 0) {
            return 100;
        }
        return totalPercentage * 100 / totalAvailablePercentage;
    }

    public void unloadGroup(int groupId) {
        for (int i = 0; i < this.fileContentCache[groupId].length; ++i) {
            this.fileContentCache[groupId][i] = null;
        }
    }

    public byte[] getFile(int groupId, int fileId) {
        return this.getEncryptableFileContents(groupId, fileId, null);
    }

    public byte[] getFile(int fileId) {
        if (this.fileContentCache.length == 1) {
            return this.getFile(0, fileId);
        }
        if (this.fileContentCache[fileId].length == 1) {
            return this.getFile(fileId, 0);
        }
        throw new RuntimeException();
    }

    public byte[] getFileByName(String groupName, String fileName) {
        groupName = groupName.toLowerCase();
        fileName = fileName.toLowerCase();
        int groupId = this.groupNames.getIdByName(RSString.stringHash(groupName));
        int fileId = this.fileNames[groupId].getIdByName(RSString.stringHash(fileName));
        return this.getFile(groupId, fileId);
    }

    public boolean loaded(int groupId, int fileId) {
        if (groupId < 0 || groupId >= this.fileContentCache.length || this.fileContentCache[groupId] == null || fileId < 0 || fileId >= this.fileContentCache[groupId].length) {
            return false;
        }
        if (this.fileContentCache[groupId][fileId] != null) {
            return true;
        }
        if (this.groupContentCache[groupId] != null) {
            return true;
        }
        this.requestGroup(groupId);
        return this.groupContentCache[groupId] != null;
    }

    public boolean loaded(String groupName, String fileName) {
        groupName = groupName.toLowerCase();
        fileName = fileName.toLowerCase();
        int groupId = this.groupNames.getIdByName(RSString.stringHash(groupName));
        int fileId = this.fileNames[groupId].getIdByName(RSString.stringHash(fileName));
        return this.loaded(groupId, fileId);
    }

    public int getLength() {
        return this.fileContentCache.length;
    }

    public void decodeIndex(byte[] data) {
        this.crc8 = MovedStatics.calculateCrc8(0, data.length, data);
        Buffer buffer = new Buffer(CacheArchive.decompress(data));
        int protocol = buffer.getUnsignedByte();
        if (protocol == 5) {
            int groupSize;
            int groupId;
            int i;
            int hasNames = buffer.getUnsignedByte();
            this.size = buffer.getUnsignedShortBE();
            this.groupIds = new int[this.size];
            int previousGroupId = 0;
            int highestGroupId = -1;
            for (int index = 0; this.size > index; ++index) {
                this.groupIds[index] = previousGroupId += buffer.getUnsignedShortBE();
                if (this.groupIds[index] <= highestGroupId) continue;
                highestGroupId = this.groupIds[index];
            }
            this.groupVersions = new int[highestGroupId + 1];
            this.groupChecksums = new int[highestGroupId + 1];
            this.groupSizes = new int[highestGroupId + 1];
            this.fileIds = new int[highestGroupId + 1][];
            this.fileContentCache = new byte[highestGroupId + 1][][];
            this.groupContentCache = new byte[highestGroupId + 1][];
            if (hasNames != 0) {
                this.nameHashes = new int[highestGroupId + 1];
                for (i = 0; this.size > i; ++i) {
                    groupId = this.groupIds[i];
                    this.nameHashes[groupId] = buffer.getIntBE();
                }
                this.groupNames = new NameHashCollection(this.nameHashes);
            }
            for (i = 0; i < this.size; ++i) {
                this.groupChecksums[this.groupIds[i]] = buffer.getIntBE();
            }
            for (i = 0; i < this.size; ++i) {
                this.groupVersions[this.groupIds[i]] = buffer.getIntBE();
            }
            for (i = 0; this.size > i; ++i) {
                this.groupSizes[this.groupIds[i]] = buffer.getUnsignedShortBE();
            }
            for (i = 0; i < this.size; ++i) {
                groupId = this.groupIds[i];
                groupSize = this.groupSizes[groupId];
                this.fileIds[groupId] = new int[groupSize];
                int previousFileId = 0;
                int highestFileId = -1;
                for (int fileId = 0; groupSize > fileId; ++fileId) {
                    this.fileIds[groupId][fileId] = previousFileId += buffer.getUnsignedShortBE();
                    if (this.fileIds[groupId][fileId] <= highestFileId) continue;
                    highestFileId = this.fileIds[groupId][fileId];
                }
                this.fileContentCache[groupId] = new byte[highestFileId + 1][];
            }
            if (hasNames != 0) {
                this.fileNames = new NameHashCollection[highestGroupId + 1];
                this.fileNameHashes = new int[1 + highestGroupId][];
                for (i = 0; this.size > i; ++i) {
                    groupId = this.groupIds[i];
                    groupSize = this.groupSizes[groupId];
                    this.fileNameHashes[groupId] = new int[this.fileContentCache[groupId].length];
                    for (int fileId = 0; groupSize > fileId; ++fileId) {
                        this.fileNameHashes[groupId][this.fileIds[groupId][fileId]] = buffer.getIntBE();
                    }
                    this.fileNames[groupId] = new NameHashCollection(this.fileNameHashes[groupId]);
                }
            }
        }
    }

    public int getFileIdByName(int groupId, String fileName) {
        fileName = fileName.toLowerCase();
        return this.fileNames[groupId].getIdByName(RSString.stringHash(fileName));
    }

    public boolean decodeGroup(int groupId, int[] xteaKeys) {
        byte[] compressedData;
        if (this.groupContentCache[groupId] == null) {
            return false;
        }
        int groupSize = this.groupSizes[groupId];
        byte[][] groupFileData = this.fileContentCache[groupId];
        int[] groupFileIds = this.fileIds[groupId];
        boolean allFilesPresent = true;
        for (int i = 0; i < groupSize; ++i) {
            if (groupFileData[groupFileIds[i]] != null) continue;
            allFilesPresent = false;
            break;
        }
        if (allFilesPresent) {
            return true;
        }
        if (xteaKeys == null || xteaKeys[0] == 0 && xteaKeys[1] == 0 && xteaKeys[2] == 0 && xteaKeys[3] == 0) {
            compressedData = this.groupContentCache[groupId];
        } else {
            compressedData = new byte[this.groupContentCache[groupId].length];
            MovedStatics.copyBytes(this.groupContentCache[groupId], 0, compressedData, 0, compressedData.length);
            Buffer buffer = new Buffer(compressedData);
            buffer.decryptXTEA(xteaKeys, 5, buffer.buffer.length);
        }
        byte[] decompressedData = CacheArchive.decompress(compressedData);
        if (this.clearGroupContentCache) {
            this.groupContentCache[groupId] = null;
        }
        if (groupSize > 1) {
            int dataLength = decompressedData.length;
            int stripeCount = decompressedData[--dataLength] & 0xFF;
            Buffer buffer = new Buffer(decompressedData);
            buffer.currentPosition = dataLength -= 4 * stripeCount * groupSize;
            int[] fileSizes = new int[groupSize];
            for (int stripe = 0; stripeCount > stripe; ++stripe) {
                int currentLength = 0;
                int f = 0;
                while (f < groupSize) {
                    int delta = buffer.getIntBE();
                    int n = f++;
                    fileSizes[n] = fileSizes[n] + (currentLength += delta);
                }
            }
            for (int f = 0; f < groupSize; ++f) {
                if (groupFileData[groupFileIds[f]] == null) {
                    groupFileData[groupFileIds[f]] = new byte[fileSizes[f]];
                }
                fileSizes[f] = 0;
            }
            buffer.currentPosition = dataLength;
            int decompressedDataPointer = 0;
            for (int stripe = 0; stripeCount > stripe; ++stripe) {
                int size = 0;
                int f = 0;
                while (f < groupSize) {
                    int stripeLength = fileSizes[f];
                    int delta = buffer.getIntBE();
                    MovedStatics.copyBytes(decompressedData, decompressedDataPointer, groupFileData[groupFileIds[f]], stripeLength, size += delta);
                    int n = f++;
                    fileSizes[n] = fileSizes[n] + size;
                    decompressedDataPointer += size;
                }
            }
        } else {
            groupFileData[groupFileIds[0]] = decompressedData;
        }
        return true;
    }

    public byte[] getEncryptableFileContents(int groupId, int fileId, int[] xteaKeys) {
        boolean loaded;
        if (groupId < 0 || groupId >= this.fileContentCache.length || this.fileContentCache[groupId] == null || fileId < 0 || fileId >= this.fileContentCache[groupId].length) {
            return null;
        }
        if (this.fileContentCache[groupId][fileId] == null && !(loaded = this.decodeGroup(groupId, xteaKeys))) {
            this.requestGroup(groupId);
            loaded = this.decodeGroup(groupId, xteaKeys);
            if (!loaded) {
                return null;
            }
        }
        byte[] data = this.fileContentCache[groupId][fileId];
        if (this.clearEncryptableContent) {
            this.fileContentCache[groupId][fileId] = null;
        }
        return data;
    }

    public byte[] getFileContents(int groupId, int fileId) {
        boolean bool;
        if (groupId < 0 || groupId >= this.fileContentCache.length || this.fileContentCache[groupId] == null || fileId < 0 || fileId >= this.fileContentCache[groupId].length) {
            return null;
        }
        if (this.fileContentCache[groupId][fileId] == null && !(bool = this.decodeGroup(groupId, null))) {
            this.requestGroup(groupId);
            bool = this.decodeGroup(groupId, null);
            if (!bool) {
                return null;
            }
        }
        return this.fileContentCache[groupId][fileId];
    }

    public byte[] getFileContents(int fileId) {
        if (this.fileContentCache.length == 1) {
            return this.getFileContents(0, fileId);
        }
        if (this.fileContentCache[fileId].length == 1) {
            return this.getFileContents(fileId, 0);
        }
        throw new RuntimeException();
    }

    public int getGroupIdByName(String name) {
        name = name.toLowerCase();
        return this.groupNames.getIdByName(RSString.stringHash(name));
    }

    public boolean areAllGroupsLoaded() {
        boolean bool = true;
        for (int i = 0; i < this.groupIds.length; ++i) {
            int groupId = this.groupIds[i];
            if (this.groupContentCache[groupId] != null) continue;
            this.requestGroup(groupId);
            if (this.groupContentCache[groupId] != null) continue;
            bool = false;
        }
        return bool;
    }

    public boolean groupExists(int groupId) {
        if (this.groupContentCache[groupId] != null) {
            return true;
        }
        this.requestGroup(groupId);
        return this.groupContentCache[groupId] != null;
    }

    public int fileLength(int fileId) {
        return this.fileContentCache[fileId].length;
    }

    public void clearFileContentCache() {
        for (int group = 0; group < this.fileContentCache.length; ++group) {
            if (this.fileContentCache[group] == null) continue;
            for (int file = 0; file < this.fileContentCache[group].length; ++file) {
                this.fileContentCache[group][file] = null;
            }
        }
    }

    public int[] getFileIds(int groupId) {
        return this.fileIds[groupId];
    }

    public void prioritiseByName(String fileName) {
        int groupId = this.groupNames.getIdByName(RSString.stringHash(fileName = fileName.toLowerCase()));
        if (groupId >= 0) {
            this.prioritiseRequest(groupId);
        }
    }

    private void prioritiseRequest(int groupId) {
        Game.updateServerConnectionManager.updateServer.prioritisePrefetchRequest(this.cacheIndexId, groupId);
    }
}

