/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.audio;

import java.util.Random;
import org.runejs.client.audio.Envelope;
import org.runejs.client.audio.Filter;
import org.runejs.client.io.Buffer;

public class Instrument {
    public static int[] sine;
    public static int[] output;
    public static int[] noise;
    public static int[] vol_step;
    public static int[] pitch_step;
    public static int[] delays;
    public static int[] pitch_base_step;
    public static int[] phases;
    public Filter filter;
    public int begin = 0;
    public int delay_time = 0;
    public int[] oscill_pitch_delta;
    public Envelope gating_attack_env;
    public Envelope vol_mod_amp_env;
    public int[] oscill_delay;
    public Envelope pitch_mod_env;
    public int[] oscill_vol = new int[5];
    public int delay_feedback = 100;
    public Envelope filter_env;
    public Envelope pitch_env;
    public Envelope vol_mod_env;
    public Envelope vol_env;
    public int duration = 500;
    public Envelope gating_release_env;
    public Envelope pitch_mod_amp_env;

    public Instrument() {
        this.oscill_delay = new int[5];
        this.oscill_pitch_delta = new int[5];
    }

    public static void initialize() {
        output = null;
        noise = null;
        sine = null;
        phases = null;
        delays = null;
        vol_step = null;
        pitch_step = null;
        pitch_base_step = null;
    }

    public void decode(Buffer buffer) {
        int i_1_;
        this.pitch_env = new Envelope();
        this.pitch_env.decode(buffer);
        this.vol_env = new Envelope();
        this.vol_env.decode(buffer);
        int option = buffer.getUnsignedByte();
        if (option != 0) {
            --buffer.currentPosition;
            this.pitch_mod_env = new Envelope();
            this.pitch_mod_env.decode(buffer);
            this.pitch_mod_amp_env = new Envelope();
            this.pitch_mod_amp_env.decode(buffer);
        }
        if ((option = buffer.getUnsignedByte()) != 0) {
            --buffer.currentPosition;
            this.vol_mod_env = new Envelope();
            this.vol_mod_env.decode(buffer);
            this.vol_mod_amp_env = new Envelope();
            this.vol_mod_amp_env.decode(buffer);
        }
        if ((option = buffer.getUnsignedByte()) != 0) {
            --buffer.currentPosition;
            this.gating_release_env = new Envelope();
            this.gating_release_env.decode(buffer);
            this.gating_attack_env = new Envelope();
            this.gating_attack_env.decode(buffer);
        }
        for (int i_0_ = 0; i_0_ < 10 && (i_1_ = buffer.getSmart()) != 0; ++i_0_) {
            this.oscill_vol[i_0_] = i_1_;
            this.oscill_pitch_delta[i_0_] = buffer.getUnsignedSmart();
            this.oscill_delay[i_0_] = buffer.getSmart();
        }
        this.delay_time = buffer.getSmart();
        this.delay_feedback = buffer.getSmart();
        this.duration = buffer.getUnsignedShortBE();
        this.begin = buffer.getUnsignedShortBE();
        this.filter = new Filter();
        this.filter_env = new Envelope();
        this.filter.decode(buffer, this.filter_env);
    }

    public int evaluateWave(int phase, int amplitude, int table) {
        if (table == 1) {
            if ((phase & Short.MAX_VALUE) < 16384) {
                return amplitude;
            }
            return -amplitude;
        }
        if (table == 2) {
            return sine[phase & Short.MAX_VALUE] * amplitude >> 14;
        }
        if (table == 3) {
            return ((phase & Short.MAX_VALUE) * amplitude >> 14) - amplitude;
        }
        if (table == 4) {
            return noise[phase / 2607 & Short.MAX_VALUE] * amplitude;
        }
        return 0;
    }

    private static void resetOutput(int[] dest, int counter, int length) {
        length = counter + length - 7;
        while (counter < length) {
            dest[counter++] = 0;
            dest[counter++] = 0;
            dest[counter++] = 0;
            dest[counter++] = 0;
            dest[counter++] = 0;
            dest[counter++] = 0;
            dest[counter++] = 0;
            dest[counter++] = 0;
        }
        length += 7;
        while (counter < length) {
            dest[counter++] = 0;
        }
    }

    public int[] synthesize(int n_s, int dt) {
        Instrument.resetOutput(output, 0, n_s);
        if (dt < 10) {
            return output;
        }
        double f_s = (double)n_s / ((double)dt + 0.0);
        this.pitch_env.reset();
        this.vol_env.reset();
        int pitch_mod_step = 0;
        int pitch_mod_base_step = 0;
        int pitch_mod_phase = 0;
        if (this.pitch_mod_env != null) {
            this.pitch_mod_env.reset();
            this.pitch_mod_amp_env.reset();
            pitch_mod_step = (int)((double)(this.pitch_mod_env.end - this.pitch_mod_env.start) * 32.768 / f_s);
            pitch_mod_base_step = (int)((double)this.pitch_mod_env.start * 32.768 / f_s);
        }
        int vol_mod_step = 0;
        int vol_mod_base_step = 0;
        int vol_mod_phase = 0;
        if (this.vol_mod_env != null) {
            this.vol_mod_env.reset();
            this.vol_mod_amp_env.reset();
            vol_mod_step = (int)((double)(this.vol_mod_env.end - this.vol_mod_env.start) * 32.768 / f_s);
            vol_mod_base_step = (int)((double)this.vol_mod_env.start * 32.768 / f_s);
        }
        for (int j2 = 0; j2 < 5; ++j2) {
            if (this.oscill_vol[j2] == 0) continue;
            Instrument.phases[j2] = 0;
            Instrument.delays[j2] = (int)((double)this.oscill_delay[j2] * f_s);
            Instrument.vol_step[j2] = (this.oscill_vol[j2] << 14) / 100;
            Instrument.pitch_step[j2] = (int)((double)(this.pitch_env.end - this.pitch_env.start) * 32.768 * Math.pow(1.0057929410678534, this.oscill_pitch_delta[j2]) / f_s);
            Instrument.pitch_base_step[j2] = (int)((double)this.pitch_env.start * 32.768 / f_s);
        }
        for (int i_8_ = 0; i_8_ < n_s; ++i_8_) {
            int mod_amp;
            int mod;
            int pitch_change = this.pitch_env.step(n_s);
            int vol_change = this.vol_env.step(n_s);
            if (this.pitch_mod_env != null) {
                mod = this.pitch_mod_env.step(n_s);
                mod_amp = this.pitch_mod_amp_env.step(n_s);
                pitch_change += this.evaluateWave(pitch_mod_phase, mod_amp, this.pitch_mod_env.form) >> 1;
                pitch_mod_phase += (mod * pitch_mod_step >> 16) + pitch_mod_base_step;
            }
            if (this.vol_mod_env != null) {
                mod = this.vol_mod_env.step(n_s);
                mod_amp = this.vol_mod_amp_env.step(n_s);
                vol_change = vol_change * ((this.evaluateWave(vol_mod_phase, mod_amp, this.vol_mod_env.form) >> 1) + 32768) >> 15;
                vol_mod_phase += (mod * vol_mod_step >> 16) + vol_mod_base_step;
            }
            for (int l5 = 0; l5 < 5; ++l5) {
                int l6;
                if (this.oscill_vol[l5] == 0 || (l6 = i_8_ + delays[l5]) >= n_s) continue;
                int n = l6;
                output[n] = output[n] + this.evaluateWave(phases[l5], vol_change * vol_step[l5] >> 15, this.pitch_env.form);
                int n2 = l5;
                phases[n2] = phases[n2] + ((pitch_change * pitch_step[l5] >> 16) + pitch_base_step[l5]);
            }
        }
        if (this.gating_release_env != null) {
            this.gating_release_env.reset();
            this.gating_attack_env.reset();
            int counter = 0;
            boolean muted = true;
            for (int i7 = 0; i7 < n_s; ++i7) {
                int on_step = this.gating_release_env.step(n_s);
                int off_step = this.gating_attack_env.step(n_s);
                int threshold = muted ? this.gating_release_env.start + ((this.gating_release_env.end - this.gating_release_env.start) * on_step >> 8) : this.gating_release_env.start + ((this.gating_release_env.end - this.gating_release_env.start) * off_step >> 8);
                if ((counter += 256) >= threshold) {
                    counter = 0;
                    boolean bl = muted = !muted;
                }
                if (!muted) continue;
                Instrument.output[i7] = 0;
            }
        }
        if (this.delay_time > 0 && this.delay_feedback > 0) {
            int delay;
            for (int i_24_ = delay = (int)((double)this.delay_time * f_s); i_24_ < n_s; ++i_24_) {
                int n = i_24_;
                output[n] = output[n] + output[i_24_ - delay] * this.delay_feedback / 100;
            }
        }
        if (this.filter.num_pairs[0] > 0 || this.filter.num_pairs[1] > 0) {
            this.filter_env.reset();
            int t = this.filter_env.step(n_s + 1);
            int M = this.filter.compute(0, (float)t / 65536.0f);
            int N = this.filter.compute(1, (float)t / 65536.0f);
            if (n_s >= M + N) {
                int n = 0;
                int delay = N;
                if (delay > n_s - M) {
                    delay = n_s - M;
                }
                while (n < delay) {
                    int i_30_ = (int)((long)output[n + M] * (long)Filter.inv_unity >> 16);
                    for (int i_31_ = 0; i_31_ < M; ++i_31_) {
                        i_30_ += (int)((long)output[n + M - 1 - i_31_] * (long)Filter.coef[0][i_31_] >> 16);
                    }
                    for (int i_32_ = 0; i_32_ < n; ++i_32_) {
                        i_30_ -= (int)((long)output[n - 1 - i_32_] * (long)Filter.coef[1][i_32_] >> 16);
                    }
                    Instrument.output[n] = i_30_;
                    t = this.filter_env.step(n_s + 1);
                    ++n;
                }
                delay = 128;
                while (true) {
                    if (delay > n_s - M) {
                        delay = n_s - M;
                    }
                    while (n < delay) {
                        int i_33_ = (int)((long)output[n + M] * (long)Filter.inv_unity >> 16);
                        for (int i_34_ = 0; i_34_ < M; ++i_34_) {
                            i_33_ += (int)((long)output[n + M - 1 - i_34_] * (long)Filter.coef[0][i_34_] >> 16);
                        }
                        for (int i_35_ = 0; i_35_ < N; ++i_35_) {
                            i_33_ -= (int)((long)output[n - 1 - i_35_] * (long)Filter.coef[1][i_35_] >> 16);
                        }
                        Instrument.output[n] = i_33_;
                        t = this.filter_env.step(n_s + 1);
                        ++n;
                    }
                    if (n >= n_s - M) break;
                    M = this.filter.compute(0, (float)t / 65536.0f);
                    N = this.filter.compute(1, (float)t / 65536.0f);
                    delay += 128;
                }
                while (n < n_s) {
                    int y = 0;
                    for (int i_37_ = n + M - n_s; i_37_ < M; ++i_37_) {
                        y += (int)((long)output[n + M - 1 - i_37_] * (long)Filter.coef[0][i_37_] >> 16);
                    }
                    for (int i_38_ = 0; i_38_ < N; ++i_38_) {
                        y -= (int)((long)output[n - 1 - i_38_] * (long)Filter.coef[1][i_38_] >> 16);
                    }
                    Instrument.output[n] = y;
                    t = this.filter_env.step(n_s + 1);
                    ++n;
                }
            }
        }
        for (int i_39_ = 0; i_39_ < n_s; ++i_39_) {
            if (output[i_39_] < Short.MIN_VALUE) {
                Instrument.output[i_39_] = Short.MIN_VALUE;
            }
            if (output[i_39_] <= Short.MAX_VALUE) continue;
            Instrument.output[i_39_] = Short.MAX_VALUE;
        }
        return output;
    }

    static {
        int i;
        noise = new int[32768];
        vol_step = new int[5];
        pitch_step = new int[5];
        delays = new int[5];
        pitch_base_step = new int[5];
        phases = new int[5];
        Random random = new Random(0L);
        for (i = 0; i < 32768; ++i) {
            Instrument.noise[i] = (random.nextInt() & 2) - 1;
        }
        sine = new int[32768];
        for (i = 0; i < 32768; ++i) {
            Instrument.sine[i] = (int)(Math.sin((double)i / 5215.1903) * 16384.0);
        }
        output = new int[220500];
    }
}

