/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.audio;

import org.runejs.client.audio.Envelope;
import org.runejs.client.io.Buffer;

public class Filter {
    public static float _inv_unity;
    public static int[][] coef;
    public static float[][] _coef;
    public static int inv_unity;
    public int[][][] pair_phase = new int[2][2][4];
    public int[] unity = new int[2];
    public int[] num_pairs = new int[2];
    public int[][][] pair_mag = new int[2][2][4];

    public static float normalize(float F) {
        float _f = 32.703197f * (float)Math.pow(2.0, F);
        return _f * (float)Math.PI / 11025.0f;
    }

    public void decode(Buffer buffer, Envelope envelope) {
        int i = buffer.getUnsignedByte();
        this.num_pairs[0] = i >> 4;
        this.num_pairs[1] = i & 0xF;
        if (i != 0) {
            this.unity[0] = buffer.getUnsignedShortBE();
            this.unity[1] = buffer.getUnsignedShortBE();
            int i_0_ = buffer.getUnsignedByte();
            for (int i_1_ = 0; i_1_ < 2; ++i_1_) {
                for (int i_2_ = 0; i_2_ < this.num_pairs[i_1_]; ++i_2_) {
                    this.pair_phase[i_1_][0][i_2_] = buffer.getUnsignedShortBE();
                    this.pair_mag[i_1_][0][i_2_] = buffer.getUnsignedShortBE();
                }
            }
            for (int i_3_ = 0; i_3_ < 2; ++i_3_) {
                for (int i_4_ = 0; i_4_ < this.num_pairs[i_3_]; ++i_4_) {
                    if ((i_0_ & 1 << i_3_ * 4 << i_4_) == 0) {
                        this.pair_phase[i_3_][1][i_4_] = this.pair_phase[i_3_][0][i_4_];
                        this.pair_mag[i_3_][1][i_4_] = this.pair_mag[i_3_][0][i_4_];
                        continue;
                    }
                    this.pair_phase[i_3_][1][i_4_] = buffer.getUnsignedShortBE();
                    this.pair_mag[i_3_][1][i_4_] = buffer.getUnsignedShortBE();
                }
            }
            if (i_0_ != 0 || this.unity[1] != this.unity[0]) {
                envelope.decode_shape(buffer);
            }
        } else {
            this.unity[1] = 0;
            this.unity[0] = 0;
        }
    }

    public float adapt_mag(int dir, int k, float t) {
        float f = (float)this.pair_mag[dir][0][k] + t * (float)(this.pair_mag[dir][1][k] - this.pair_mag[dir][0][k]);
        return 1.0f - (float)Math.pow(10.0, -(f *= 0.0015258789f) / 20.0f);
    }

    public int compute(int dir, float arg1) {
        int i;
        if (dir == 0) {
            float _a0 = (float)this.unity[0] + (float)(this.unity[1] - this.unity[0]) * arg1;
            _inv_unity = (float)Math.pow(0.1, (_a0 *= 0.0030517578f) / 20.0f);
            inv_unity = (int)(_inv_unity * 65536.0f);
        }
        if (this.num_pairs[dir] == 0) {
            return 0;
        }
        float f = this.adapt_mag(dir, 0, arg1);
        Filter._coef[dir][0] = -2.0f * f * (float)Math.cos(this.adapt_phase(dir, 0, arg1));
        Filter._coef[dir][1] = f * f;
        for (i = 1; i < this.num_pairs[dir]; ++i) {
            f = this.adapt_mag(dir, i, arg1);
            float f_0_ = -2.0f * f * (float)Math.cos(this.adapt_phase(dir, i, arg1));
            float f_1_ = f * f;
            Filter._coef[dir][i * 2 + 1] = _coef[dir][i * 2 - 1] * f_1_;
            Filter._coef[dir][i * 2] = _coef[dir][i * 2 - 1] * f_0_ + _coef[dir][i * 2 - 2] * f_1_;
            for (int i_2_ = i * 2 - 1; i_2_ >= 2; --i_2_) {
                float[] fArray = _coef[dir];
                int n = i_2_;
                fArray[n] = fArray[n] + (_coef[dir][i_2_ - 1] * f_0_ + _coef[dir][i_2_ - 2] * f_1_);
            }
            float[] fArray = _coef[dir];
            fArray[1] = fArray[1] + (_coef[dir][0] * f_0_ + f_1_);
            float[] fArray2 = _coef[dir];
            fArray2[0] = fArray2[0] + f_0_;
        }
        if (dir == 0) {
            i = 0;
            while (i < this.num_pairs[0] * 2) {
                float[] fArray = _coef[0];
                int n = i++;
                fArray[n] = fArray[n] * _inv_unity;
            }
        }
        for (i = 0; i < this.num_pairs[dir] * 2; ++i) {
            Filter.coef[dir][i] = (int)(_coef[dir][i] * 65536.0f);
        }
        return this.num_pairs[dir] * 2;
    }

    public float adapt_phase(int dir, int i, float t) {
        float f = (float)this.pair_phase[dir][0][i] + t * (float)(this.pair_phase[dir][1][i] - this.pair_phase[dir][0][i]);
        return Filter.normalize(f *= 1.2207031E-4f);
    }

    static {
        coef = new int[2][8];
        _coef = new float[2][8];
    }
}

