/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.audio;

import org.runejs.client.io.Buffer;

public class Envelope {
    public int num_phases = 2;
    public int[] phase_dur = new int[2];
    public int start;
    public int form;
    public int end;
    public int[] phase_peak = new int[2];
    public int ticks;
    public int step;
    public int critical;
    public int phase_idx;
    public int amp;

    public Envelope() {
        this.phase_dur[0] = 0;
        this.phase_dur[1] = 65535;
        this.phase_peak[0] = 0;
        this.phase_peak[1] = 65535;
    }

    public void reset() {
        this.critical = 0;
        this.phase_idx = 0;
        this.step = 0;
        this.amp = 0;
        this.ticks = 0;
    }

    public void decode(Buffer buffer) {
        this.form = buffer.getUnsignedByte();
        this.start = buffer.getIntBE();
        this.end = buffer.getIntBE();
        this.decode_shape(buffer);
    }

    public void decode_shape(Buffer buffer) {
        this.num_phases = buffer.getUnsignedByte();
        this.phase_dur = new int[this.num_phases];
        this.phase_peak = new int[this.num_phases];
        for (int i = 0; i < this.num_phases; ++i) {
            this.phase_dur[i] = buffer.getUnsignedShortBE();
            this.phase_peak[i] = buffer.getUnsignedShortBE();
        }
    }

    public int step(int period) {
        if (this.ticks >= this.critical) {
            this.amp = this.phase_peak[this.phase_idx++] << 15;
            if (this.phase_idx >= this.num_phases) {
                this.phase_idx = this.num_phases - 1;
            }
            this.critical = (int)((double)this.phase_dur[this.phase_idx] / 65536.0 * (double)period);
            if (this.critical > this.ticks) {
                this.step = ((this.phase_peak[this.phase_idx] << 15) - this.amp) / (this.critical - this.ticks);
            }
        }
        this.amp += this.step;
        ++this.ticks;
        return this.amp - this.step >> 15;
    }
}

