/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client.audio;

import org.runejs.client.audio.Instrument;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.io.Buffer;
import org.runejs.client.sound.RawSound;

public class Effect {
    public Instrument[] instruments = new Instrument[10];
    public int loop_begin;
    public int loop_end;

    public Effect(Buffer arg0) {
        for (int i = 0; i < 10; ++i) {
            int i_10_ = arg0.getUnsignedByte();
            if (i_10_ == 0) continue;
            --arg0.currentPosition;
            this.instruments[i] = new Instrument();
            this.instruments[i].decode(arg0);
        }
        this.loop_begin = arg0.getUnsignedShortBE();
        this.loop_end = arg0.getUnsignedShortBE();
    }

    public Effect() {
    }

    public static Effect readSoundEffect(CacheArchive archive, int groupId, int fileId) {
        byte[] data = archive.getFile(groupId, fileId);
        if (data == null) {
            return null;
        }
        return new Effect(new Buffer(data));
    }

    public byte[] method426() {
        int i = 0;
        for (int i_2_ = 0; i_2_ < 10; ++i_2_) {
            if (this.instruments[i_2_] == null || this.instruments[i_2_].duration + this.instruments[i_2_].begin <= i) continue;
            i = this.instruments[i_2_].duration + this.instruments[i_2_].begin;
        }
        if (i == 0) {
            return new byte[0];
        }
        int i_3_ = 22050 * i / 1000;
        byte[] is = new byte[i_3_];
        for (int i_4_ = 0; i_4_ < 10; ++i_4_) {
            if (this.instruments[i_4_] == null) continue;
            int i_5_ = this.instruments[i_4_].duration * 22050 / 1000;
            int i_6_ = this.instruments[i_4_].begin * 22050 / 1000;
            int[] is_7_ = this.instruments[i_4_].synthesize(i_5_, this.instruments[i_4_].duration);
            for (int i_8_ = 0; i_8_ < i_5_; ++i_8_) {
                int i_9_ = is[i_8_ + i_6_] + (is_7_[i_8_] >> 8);
                if ((i_9_ + 128 & 0xFFFFFF00) != 0) {
                    i_9_ = i_9_ >> 31 ^ 0x7F;
                }
                is[i_8_ + i_6_] = (byte)i_9_;
            }
        }
        return is;
    }

    public int delay() {
        int offset = 9999999;
        for (int k = 0; k < 10; ++k) {
            if (this.instruments[k] == null || this.instruments[k].begin / 20 >= offset) continue;
            offset = this.instruments[k].begin / 20;
        }
        if (this.loop_begin < this.loop_end && this.loop_begin / 20 < offset) {
            offset = this.loop_begin / 20;
        }
        if (offset == 9999999 || offset == 0) {
            return 0;
        }
        for (int l = 0; l < 10; ++l) {
            if (this.instruments[l] == null) continue;
            this.instruments[l].begin -= offset * 20;
        }
        if (this.loop_begin < this.loop_end) {
            this.loop_begin -= offset * 20;
            this.loop_end -= offset * 20;
        }
        return offset;
    }

    public RawSound method428() {
        byte[] is = this.method426();
        return new RawSound(22050, is, 22050 * this.loop_begin / 1000, 22050 * this.loop_end / 1000);
    }
}

