/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client;

import org.runejs.client.MovedStatics;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.media.IndexedImage;
import org.runejs.client.io.Buffer;
import org.runejs.client.media.Rasterizer3D;
import org.runejs.client.node.Node;

public class Texture
extends Node {
    public static int[] animationPixels;
    public int animateDirection;
    public int averageColour;
    public int[] anIntArray2138;
    public int[] pixels;
    public int[] anIntArray2140;
    public int animateSpeed;
    public boolean opaque;
    public int[] spriteIds;
    public int[] colors;
    public boolean aBoolean2146 = false;

    public Texture(Buffer textureBuffer) {
        int i;
        this.averageColour = textureBuffer.getUnsignedShortBE();
        this.opaque = textureBuffer.getUnsignedByte() == 1;
        int spriteCount = textureBuffer.getUnsignedByte();
        if (spriteCount < 1 || spriteCount > 4) {
            throw new RuntimeException();
        }
        this.spriteIds = new int[spriteCount];
        for (i = 0; i < spriteCount; ++i) {
            this.spriteIds[i] = textureBuffer.getUnsignedShortBE();
        }
        if (spriteCount > 1) {
            this.anIntArray2140 = new int[spriteCount - 1];
            for (i = 0; i < spriteCount - 1; ++i) {
                this.anIntArray2140[i] = textureBuffer.getUnsignedByte();
            }
            this.anIntArray2138 = new int[spriteCount - 1];
            for (i = 0; i < spriteCount - 1; ++i) {
                this.anIntArray2138[i] = textureBuffer.getUnsignedByte();
            }
        }
        this.colors = new int[spriteCount];
        for (i = 0; i < spriteCount; ++i) {
            this.colors[i] = textureBuffer.getIntBE();
        }
        this.animateDirection = textureBuffer.getUnsignedByte();
        this.animateSpeed = textureBuffer.getUnsignedByte();
        this.pixels = null;
    }

    public void animate(int deltaT) {
        int counter;
        int offset;
        if (this.pixels == null) {
            return;
        }
        if (animationPixels == null || animationPixels.length < this.pixels.length) {
            animationPixels = new int[this.pixels.length];
        }
        int dimension = this.pixels.length == 16384 ? 64 : 128;
        int quarterLength = this.pixels.length / 4;
        if (this.animateDirection == 1 || this.animateDirection == 3) {
            offset = dimension * deltaT * this.animateSpeed;
            int i_2_ = quarterLength - 1;
            if (this.animateDirection == 1) {
                offset = -offset;
            }
            for (counter = 0; counter < quarterLength; ++counter) {
                int index = counter + offset & i_2_;
                Texture.animationPixels[counter] = this.pixels[index];
                Texture.animationPixels[counter + quarterLength] = this.pixels[index + quarterLength];
                Texture.animationPixels[counter + quarterLength + quarterLength] = this.pixels[index + quarterLength + quarterLength];
                Texture.animationPixels[counter + quarterLength + quarterLength + quarterLength] = this.pixels[index + quarterLength + quarterLength + quarterLength];
            }
        }
        if (this.animateDirection == 2 || this.animateDirection == 4) {
            offset = deltaT * this.animateSpeed;
            int i_7_ = dimension - 1;
            if (this.animateDirection == 2) {
                offset = -offset;
            }
            for (counter = 0; counter < quarterLength; counter += dimension) {
                for (int d = 0; d < dimension; ++d) {
                    int index = counter + d;
                    int otherIndex = counter + (d + offset & i_7_);
                    Texture.animationPixels[index] = this.pixels[otherIndex];
                    Texture.animationPixels[index + quarterLength] = this.pixels[otherIndex + quarterLength];
                    Texture.animationPixels[index + quarterLength + quarterLength] = this.pixels[otherIndex + quarterLength + quarterLength];
                    Texture.animationPixels[index + quarterLength + quarterLength + quarterLength] = this.pixels[otherIndex + quarterLength + quarterLength + quarterLength];
                }
            }
        }
        int[] tmp = this.pixels;
        this.pixels = animationPixels;
        animationPixels = tmp;
    }

    public boolean method869(double brightness, int textureSize, CacheArchive imageArchive) {
        for (int i = 0; i < this.spriteIds.length; ++i) {
            if (imageArchive.getFileContents(this.spriteIds[i]) != null) continue;
            return false;
        }
        int textureSizeArea = textureSize * textureSize;
        this.pixels = new int[textureSizeArea * 4];
        for (int i_12_ = 0; i_12_ < this.spriteIds.length; ++i_12_) {
            IndexedImage image = MovedStatics.loadIndexedImageFromArchive(imageArchive, this.spriteIds[i_12_]);
            image.resizeToLibSize();
            byte[] imgPixels = image.imgPixels;
            int[] imgPalette = image.palette;
            int color = this.colors[i_12_];
            if ((color & 0xFF000000) == 0x3000000) {
                int i_15_ = color & 0xFF00FF;
                int i_16_ = color >> 8 & 0xFF;
                for (int i_17_ = 0; i_17_ < imgPalette.length; ++i_17_) {
                    int i_18_ = imgPalette[i_17_];
                    if ((i_18_ & 0xFFFF) != i_18_ >> 8) continue;
                    imgPalette[i_17_] = i_15_ * (i_18_ &= 0xFF) >> 8 & 0xFF00FF | i_16_ * i_18_ & 0xFF00;
                }
            }
            for (int i_19_ = 0; i_19_ < imgPalette.length; ++i_19_) {
                imgPalette[i_19_] = Rasterizer3D.adjustBrightness(imgPalette[i_19_], brightness);
            }
            int i_20_ = i_12_ == 0 ? 0 : this.anIntArray2140[i_12_ - 1];
            if (i_20_ != 0) continue;
            if (image.imgWidth == textureSize) {
                for (int i_21_ = 0; i_21_ < textureSizeArea; ++i_21_) {
                    this.pixels[i_21_] = imgPalette[imgPixels[i_21_] & 0xFF];
                }
                continue;
            }
            if (image.imgWidth == 64 && textureSize == 128) {
                int i_22_ = 0;
                for (int i_23_ = 0; i_23_ < textureSize; ++i_23_) {
                    for (int i_24_ = 0; i_24_ < textureSize; ++i_24_) {
                        this.pixels[i_22_++] = imgPalette[imgPixels[(i_24_ >> 1) + (i_23_ >> 1 << 6)] & 0xFF];
                    }
                }
                continue;
            }
            if (image.imgWidth == 128 && textureSize == 64) {
                int i_25_ = 0;
                for (int i_26_ = 0; i_26_ < textureSize; ++i_26_) {
                    for (int i_27_ = 0; i_27_ < textureSize; ++i_27_) {
                        this.pixels[i_25_++] = imgPalette[imgPixels[(i_27_ << 1) + (i_26_ << 1 << 7)] & 0xFF];
                    }
                }
                continue;
            }
            throw new RuntimeException();
        }
        for (int pixelIndex = 0; pixelIndex < textureSizeArea; ++pixelIndex) {
            int n = pixelIndex;
            this.pixels[n] = this.pixels[n] & 0xF8F8FF;
            int pixel = this.pixels[pixelIndex];
            this.pixels[pixelIndex + textureSizeArea] = pixel - (pixel >>> 3) & 0xF8F8FF;
            this.pixels[pixelIndex + textureSizeArea + textureSizeArea] = pixel - (pixel >>> 2) & 0xF8F8FF;
            this.pixels[pixelIndex + textureSizeArea + textureSizeArea + textureSizeArea] = pixel - (pixel >>> 2) - (pixel >>> 3) & 0xF8F8FF;
        }
        return true;
    }

    public void clearPixels() {
        this.pixels = null;
    }
}

