/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SizedAccessFile {
    public long position;
    public long size;
    public RandomAccessFile accessFile;
    public File file;

    public SizedAccessFile(File file, String fileOptions, long size) throws IOException {
        if (size == -1L) {
            size = Long.MAX_VALUE;
        }
        if (size <= file.length()) {
            file.delete();
        }
        this.accessFile = new RandomAccessFile(file, fileOptions);
        this.size = size;
        this.file = file;
        this.position = 0L;
    }

    public File getFile() {
        return this.file;
    }

    public void seek(long pointer) throws IOException {
        this.accessFile.seek(pointer);
        this.position = pointer;
    }

    public void close() throws IOException {
        this.accessFile.close();
        this.accessFile = null;
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if ((long)length + this.position > this.size) {
            this.accessFile.seek(1L + this.size);
            this.accessFile.write(1);
            throw new EOFException();
        }
        this.accessFile.write(b, offset, length);
        this.position += (long)length;
    }

    public long length() throws IOException {
        return this.accessFile.length();
    }

    public int read(byte[] b, int length, int offset) throws IOException {
        int size = this.accessFile.read(b, offset, length);
        if (size > 0) {
            this.position += (long)size;
        }
        return size;
    }
}

