/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client;

import org.runejs.client.cache.def.SpotAnimDefinition;
import org.runejs.client.cache.media.AnimationSequence;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.media.renderable.Renderable;

public class Projectile
extends Renderable {
    public int startHeight;
    public int startX;
    public int endHeight;
    public int entityIndex;
    public int graphicsId;
    public boolean moving = false;
    public int endCycle;
    public double speedVectorZ;
    public int duration = 0;
    public int delay;
    public int anInt2976;
    public double currentX;
    public int anInt2981;
    public int animationFrame = 0;
    public int startY;
    public int startDistanceFromTarget;
    public double currentHeight;
    public double currentY;
    public double speedVectorScalar;
    public double heightOffset;
    public int startSlope;
    public double speedVectorY;
    public AnimationSequence animationSequences;
    public double speedVectorX;
    public int anInt3013;

    public Projectile(int graphicsId, int arg1, int startX, int startY, int height, int delay, int speed, int startSlope, int startDistanceFromTarget, int entityIndex, int endHeight) {
        this.startX = startX;
        this.startHeight = height;
        this.moving = false;
        this.endHeight = endHeight;
        this.startDistanceFromTarget = startDistanceFromTarget;
        this.graphicsId = graphicsId;
        this.anInt2981 = arg1;
        this.endCycle = speed;
        this.delay = delay;
        this.entityIndex = entityIndex;
        this.startY = startY;
        this.startSlope = startSlope;
        int i = SpotAnimDefinition.forId((int)this.graphicsId).animationId;
        this.animationSequences = i != -1 ? AnimationSequence.getAnimationSequence(i) : null;
    }

    @Override
    public Model getRotatedModel() {
        SpotAnimDefinition spotAnimDefinition = SpotAnimDefinition.forId(this.graphicsId);
        Model class40_sub5_sub17_sub5 = spotAnimDefinition.getModel(this.animationFrame);
        if (class40_sub5_sub17_sub5 == null) {
            return null;
        }
        class40_sub5_sub17_sub5.method804(this.anInt2976);
        return class40_sub5_sub17_sub5;
    }

    public void move(int time) {
        this.moving = true;
        this.currentY += (double)time * this.speedVectorY;
        this.currentX += this.speedVectorX * (double)time;
        this.currentHeight += this.heightOffset * 0.5 * (double)time * (double)time + (double)time * this.speedVectorZ;
        this.speedVectorZ += (double)time * this.heightOffset;
        this.anInt3013 = 0x7FF & (int)(Math.atan2(this.speedVectorX, this.speedVectorY) * 325.949) + 1024;
        this.anInt2976 = 0x7FF & (int)(325.949 * Math.atan2(this.speedVectorZ, this.speedVectorScalar));
        if (this.animationSequences != null) {
            this.duration += time;
            while (this.animationSequences.frameLengths[this.animationFrame] < this.duration) {
                this.duration -= this.animationSequences.frameLengths[this.animationFrame];
                ++this.animationFrame;
                if (this.animationSequences.frameIds.length > this.animationFrame) continue;
                this.animationFrame = 0;
            }
        }
    }

    public void trackTarget(int loopCycle, int arg1, int targetY, int k, int targetX) {
        if (!this.moving) {
            double distanceX = -this.startX + targetX;
            double distanceY = -this.startY + targetY;
            double distanceScalar = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
            this.currentX = (double)this.startX + distanceX * (double)this.startDistanceFromTarget / distanceScalar;
            this.currentY = (double)this.startY + (double)this.startDistanceFromTarget * distanceY / distanceScalar;
            this.currentHeight = this.startHeight;
        }
        double cyclesRemaining = -loopCycle + 1 + this.endCycle;
        this.speedVectorY = ((double)targetY - this.currentY) / cyclesRemaining;
        this.speedVectorX = ((double)targetX - this.currentX) / cyclesRemaining;
        this.speedVectorScalar = Math.sqrt(this.speedVectorY * this.speedVectorY + this.speedVectorX * this.speedVectorX);
        if (!this.moving) {
            this.speedVectorZ = -this.speedVectorScalar * Math.tan((double)this.startSlope * 0.02454369);
        }
        this.heightOffset = (-this.currentHeight + (double)k - this.speedVectorZ * cyclesRemaining) * 2.0 / (cyclesRemaining * cyclesRemaining);
    }
}

