/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client;

import org.runejs.client.node.Node;

public class LinkedList {
    public Node last;
    public Node first;

    public LinkedList() {
        this.last.previous = this.last = new Node();
        this.last.next = this.last;
    }

    public Node removeLast() {
        Node node = this.last.previous;
        if (node == this.last) {
            return null;
        }
        node.unlink();
        return node;
    }

    public Node peekLast() {
        Node node = this.last.previous;
        if (node == this.last) {
            this.first = null;
            return null;
        }
        this.first = node.previous;
        return node;
    }

    public Node peekFirst() {
        Node node = this.last.next;
        if (this.last == node) {
            this.first = null;
            return null;
        }
        this.first = node.next;
        return node;
    }

    public void addLast(Node node) {
        if (node.previous != null) {
            node.unlink();
        }
        node.previous = this.last.previous;
        node.next = this.last;
        node.previous.next = node;
        node.next.previous = node;
    }

    public void addFirst(Node node) {
        if (node.previous != null) {
            node.unlink();
        }
        node.previous = this.last;
        node.next = this.last.next;
        node.previous.next = node;
        node.next.previous = node;
    }

    public void clear() {
        Node next;
        while ((next = this.last.next) != this.last) {
            next.unlink();
        }
        return;
    }

    public Node pollFirst() {
        Node node = this.first;
        if (node == this.last) {
            this.first = null;
            return null;
        }
        this.first = node.next;
        return node;
    }

    public void addBefore(Node existingNode, Node insertingNode) {
        if (insertingNode.previous != null) {
            insertingNode.unlink();
        }
        insertingNode.previous = existingNode.previous;
        insertingNode.next = existingNode;
        insertingNode.previous.next = insertingNode;
        insertingNode.next.previous = insertingNode;
    }

    public Node pollLast() {
        Node node = this.first;
        if (node == this.last) {
            this.first = null;
            return null;
        }
        this.first = node.previous;
        return node;
    }

    public Node removeFirst() {
        Node next = this.last.next;
        if (this.last == next) {
            return null;
        }
        next.unlink();
        return next;
    }
}

