/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client;

import java.io.IOException;
import org.runejs.OldEngine.MapDecompressor;
import org.runejs.client.Game;
import org.runejs.client.GameShell;
import org.runejs.client.MovedStatics;
import org.runejs.client.cache.CacheArchive;
import org.runejs.client.cache.FileOperations;
import org.runejs.client.cache.def.GameObjectDefinition;
import org.runejs.client.cache.def.OverlayDefinition;
import org.runejs.client.cache.def.UnderlayDefinition;
import org.runejs.client.cache.media.gameInterface.GameInterface;
import org.runejs.client.io.Buffer;
import org.runejs.client.language.English;
import org.runejs.client.language.Native;
import org.runejs.client.media.Rasterizer3D;
import org.runejs.client.media.VertexNormal;
import org.runejs.client.media.renderable.GameObject;
import org.runejs.client.media.renderable.Model;
import org.runejs.client.media.renderable.Renderable;
import org.runejs.client.media.renderable.actor.Player;
import org.runejs.client.net.OutgoingPackets;
import org.runejs.client.scene.InteractiveObjectTemporary;
import org.runejs.client.scene.Scene;
import org.runejs.client.scene.util.CollisionMap;
import org.runejs.client.sound.SoundSystem;
import org.runejs.client.util.BitUtils;
import org.runejs.client.util.PerlinNoise;

public class Landscape {
    public static CollisionMap[] currentCollisionMap = new CollisionMap[4];
    public static int[] mapCoordinates;
    public static int[] blendedHue;
    public static int[] blendedSaturation;
    public static int[] blendedLightness;
    public static int[] blendedHueMultiplier;
    public static int[] blendDirectionTracker;
    public static int[][][] tileCullingBitsets;
    public static int[][] tileLightIntensity;
    public static byte[][][] tile_overlay_rotation;
    public static byte[][][] tileShadowIntensity;
    public static byte[][][] tile_underlay_path;
    public static byte[][][] tile_overlayids;
    public static byte[][][] tile_underlayids;
    public static byte[][] objectData;
    public static int[][][] constructMapTiles;
    public static int[] objectDataIds;
    public static int[][] xteaKeys;
    public static byte[][] terrainData;
    public static boolean loadGeneratedMap;
    public static int[] terrainDataIds;
    public int[][][] tile_height = new int[4][105][105];
    public static int randomiserLightness;
    public static int randomiserHue;
    private static int lowestPlane;
    private final Scene scene;

    public Landscape(Scene scene) {
        this.scene = scene;
    }

    public void loadRegion() {
        int i;
        Landscape.method364(false);
        Game.missingLandscapeFiles = 0;
        boolean bool = true;
        for (i = 0; i < terrainData.length; ++i) {
            if (terrainDataIds[i] != -1 && terrainData[i] == null) {
                Landscape.terrainData[i] = CacheArchive.gameWorldMapCacheArchive.getFile(terrainDataIds[i], 0);
                if (terrainData[i] == null) {
                    ++Game.missingLandscapeFiles;
                    bool = false;
                }
            }
            if (objectDataIds[i] == -1 || objectData[i] != null) continue;
            Landscape.objectData[i] = CacheArchive.gameWorldMapCacheArchive.getEncryptableFileContents(objectDataIds[i], 0, xteaKeys[i]);
            if (objectData[i] != null) continue;
            ++Game.missingLandscapeFiles;
            bool = false;
        }
        if (bool) {
            bool = true;
            Game.missingGameObjectFiles = 0;
            for (i = 0; terrainData.length > i; ++i) {
                byte[] is = objectData[i];
                if (is == null) continue;
                int i_2_ = (mapCoordinates[i] & 0xFF) * 64 - MovedStatics.baseY;
                int i_3_ = (mapCoordinates[i] >> 8) * 64 - MovedStatics.baseX;
                if (loadGeneratedMap) {
                    i_3_ = 10;
                    i_2_ = 10;
                }
                bool &= this.decodeChunkObjects(is, i_3_, i_2_);
            }
            if (bool) {
                int z;
                if (Game.regionLoadingType != 0) {
                    MovedStatics.drawLoadingBox(English.loadingPleaseWait, Native.percent100Parentheses, true);
                }
                Game.clearCaches();
                this.scene.initToNull();
                System.gc();
                for (z = 0; z < 4; ++z) {
                    currentCollisionMap[z].reset();
                }
                for (z = 0; z < 4; ++z) {
                    for (int x = 0; x < 104; ++x) {
                        for (int y = 0; y < 104; ++y) {
                            MovedStatics.tile_flags[z][x][y] = 0;
                        }
                    }
                }
                Landscape.method1020();
                int dataLength = terrainData.length;
                SoundSystem.clearObjectSounds();
                Landscape.method364(true);
                if (!loadGeneratedMap) {
                    int pointer;
                    for (pointer = 0; dataLength > pointer; ++pointer) {
                        int offsetY = -MovedStatics.baseY + (0xFF & mapCoordinates[pointer]) * 64;
                        int offsetX = -MovedStatics.baseX + 64 * (mapCoordinates[pointer] >> 8);
                        byte[] is = terrainData[pointer];
                        if (FileOperations.FileExists("./data/maps/" + terrainDataIds[pointer] + ".dat")) {
                            System.out.println("reading file: ./data/maps/" + terrainDataIds[pointer] + ".dat");
                            is = FileOperations.ReadFile("./data/maps/" + terrainDataIds[pointer] + ".dat");
                        }
                        if (is == null) continue;
                        this.loadTerrainBlock(currentCollisionMap, (MovedStatics.regionX - 6) * 8, is, offsetX, offsetY, 8 * (-6 + MovedStatics.regionY));
                    }
                    for (pointer = 0; dataLength > pointer; ++pointer) {
                        int offsetX = -MovedStatics.baseX + (mapCoordinates[pointer] >> 8) * 64;
                        int offsetY = -MovedStatics.baseY + 64 * (mapCoordinates[pointer] & 0xFF);
                        byte[] data = terrainData[pointer];
                        if (data != null || MovedStatics.regionY >= 800) continue;
                        this.initiateVertexHeights(offsetY, 64, 64, offsetX);
                    }
                    Landscape.method364(true);
                    for (int region = 0; dataLength > region; ++region) {
                        byte[] data = objectData[region];
                        if (FileOperations.FileExists("./data/maps/" + objectDataIds[region] + ".cmap")) {
                            MapDecompressor.objectLoader("./data/maps/" + objectDataIds[region] + ".cmap");
                        } else if (FileOperations.FileExists("./data/maps/" + objectDataIds[region] + ".dat")) {
                            System.out.println("reading file: ./data/maps/" + objectDataIds[region] + ".dat");
                            data = FileOperations.ReadFile("./data/maps/" + objectDataIds[region] + ".dat");
                        } else {
                            try {
                                data = MapDecompressor.grabMap(objectDataIds[region]);
                            }
                            catch (IOException offsetY) {
                                // empty catch block
                            }
                        }
                        if (data != null) {
                            int offsetX = -MovedStatics.baseX + (mapCoordinates[region] >> 8) * 64;
                            int offsetY = 64 * (0xFF & mapCoordinates[region]) - MovedStatics.baseY;
                            this.loadObjectBlock(offsetX, currentCollisionMap, data, offsetY);
                            continue;
                        }
                        System.out.println("Missing map: " + objectDataIds[region]);
                    }
                }
                if (loadGeneratedMap) {
                    for (int plane = 0; plane < 4; ++plane) {
                        for (int chunkX = 0; chunkX < 13; ++chunkX) {
                            for (int chunkY = 0; chunkY < 13; ++chunkY) {
                                int data = constructMapTiles[plane][chunkX][chunkY];
                                boolean chunkLoaded = false;
                                if (data != -1) {
                                    int tileRotation = (6 & data) >> 1;
                                    int tileX = (data & 0xFFD2C2) >> 14;
                                    int tileZ = data >> 24 & 3;
                                    int tileY = (data & 0x3FFB) >> 3;
                                    int tileCoordinates = (tileX / 8 << 8) + tileY / 8;
                                    for (int pointer = 0; pointer < mapCoordinates.length; ++pointer) {
                                        if (mapCoordinates[pointer] != tileCoordinates || terrainData[pointer] == null) continue;
                                        this.loadTerrainSubblock(chunkY * 8, 8 * (tileX & 7), tileZ, plane, chunkX * 8, (7 & tileY) * 8, tileRotation, terrainData[pointer], currentCollisionMap);
                                        chunkLoaded = true;
                                        break;
                                    }
                                }
                                if (chunkLoaded) continue;
                                this.matchChunkHeightmapWithSurroundings(plane, chunkX * 8, chunkY * 8);
                            }
                        }
                    }
                    for (int x = 0; x < 13; ++x) {
                        for (int y = 0; y < 13; ++y) {
                            int displayMap = constructMapTiles[0][x][y];
                            if (displayMap != -1) continue;
                            this.initiateVertexHeights(y * 8, 8, 8, 8 * x);
                        }
                    }
                    Landscape.method364(true);
                    for (int z2 = 0; z2 < 4; ++z2) {
                        for (int x = 0; x < 13; ++x) {
                            block19: for (int y = 0; y < 13; ++y) {
                                int bits = constructMapTiles[z2][x][y];
                                if (bits == -1) continue;
                                int tileZ = (bits & 0x3BA82FB) >> 24;
                                int tileX = 0x3FF & bits >> 14;
                                int tileRotation = bits >> 1 & 3;
                                int tileY = bits >> 3 & 0x7FF;
                                int tileCoordinates = (tileX / 8 << 8) + tileY / 8;
                                for (int i_38_ = 0; i_38_ < mapCoordinates.length; ++i_38_) {
                                    if (tileCoordinates != mapCoordinates[i_38_] || objectData[i_38_] == null) continue;
                                    this.constructMapRegionObjects(8 * (tileX & 7), 8 * (tileY & 7), tileZ, tileRotation, x * 8, 8 * y, z2, objectData[i_38_], currentCollisionMap);
                                    continue block19;
                                }
                            }
                        }
                    }
                }
                Landscape.method364(true);
                Game.clearCaches();
                this.createRegion(currentCollisionMap);
                Landscape.method364(true);
                int z3 = lowestPlane;
                if (Player.worldLevel < z3) {
                    z3 = Player.worldLevel;
                }
                if (z3 < -1 + Player.worldLevel) {
                    z3 = -1 + Player.worldLevel;
                }
                if (!VertexNormal.lowMemory) {
                    this.scene.setPlane(0);
                } else {
                    this.scene.setPlane(lowestPlane);
                }
                for (int x = 0; x < 104; ++x) {
                    for (int y = 0; y < 104; ++y) {
                        MovedStatics.spawnGroundItem(y, x);
                    }
                }
                Landscape.clearTemporaryObjects();
                GameObjectDefinition.clearStaticModelCache();
                if (GameShell.clientFrame != null) {
                    OutgoingPackets.buffer.putPacket(121);
                    OutgoingPackets.buffer.putIntBE(1057001181);
                }
                if (!loadGeneratedMap) {
                    int minX = (MovedStatics.regionX - 6) / 8;
                    int minY = (MovedStatics.regionY - 6) / 8;
                    int maxY = (MovedStatics.regionY + 6) / 8;
                    int maxX = (MovedStatics.regionX + 6) / 8;
                    for (int x = minX - 1; x <= maxX + 1; ++x) {
                        for (int y = minY - 1; y <= maxY + 1; ++y) {
                            if (minX <= x && x <= maxX && y >= minY && y <= maxY) continue;
                            CacheArchive.gameWorldMapCacheArchive.prioritiseByName(Native.MAP_NAME_PREFIX_M + x + Native.MAP_NAME_UNDERSCORE + y);
                            CacheArchive.gameWorldMapCacheArchive.prioritiseByName(Native.MAP_NAME_PREFIX_L + x + Native.MAP_NAME_UNDERSCORE + y);
                        }
                    }
                }
                if (GameInterface.fullscreenInterfaceId != -1) {
                    MovedStatics.processGameStatus(35);
                } else {
                    MovedStatics.processGameStatus(30);
                }
                Landscape.method973();
                OutgoingPackets.buffer.putPacket(178);
                MovedStatics.resetGameTimer();
            } else {
                Game.regionLoadingType = 2;
            }
        } else {
            Game.regionLoadingType = 1;
        }
    }

    private void loadTerrainSubblock(int y, int drawX, int drawingPlane, int currentPlane, int x, int drawY, int rotation, byte[] terrainData, CollisionMap[] collisionMaps) {
        for (int i = 0; i < 8; ++i) {
            for (int yIdx = 0; yIdx < 8; ++yIdx) {
                if (x + i <= 0 || i + x >= 103 || y + yIdx <= 0 || yIdx + y >= 103) continue;
                collisionMaps[currentPlane].clippingData[x + i][yIdx + y] = BitUtils.bitWiseAND(collisionMaps[currentPlane].clippingData[x + i][yIdx + y], -16777217);
            }
        }
        Buffer class40_sub1 = new Buffer(terrainData);
        for (int plane = 0; plane < 4; ++plane) {
            for (int tileX = 0; tileX < 64; ++tileX) {
                for (int tileY = 0; tileY < 64; ++tileY) {
                    if (plane == drawingPlane && tileX >= drawX && 8 + drawX > tileX && tileY >= drawY && 8 + drawY > tileY) {
                        this.method922(x + Landscape.getRotatedTileX(rotation, tileX & 7, tileY & 7), rotation, class40_sub1, y + Landscape.getRotatedTileY(tileX & 7, 7 & tileY, rotation), 0, 0, currentPlane);
                        continue;
                    }
                    this.method922(-1, 0, class40_sub1, -1, 0, 0, 0);
                }
            }
        }
    }

    private static int getRotatedTileX(int rotation, int x, int y) {
        if ((rotation &= 3) == 0) {
            return x;
        }
        if (rotation == 1) {
            return y;
        }
        if (rotation == 2) {
            return -x + 7;
        }
        return 7 + -y;
    }

    private static int getRotatedTileY(int x, int y, int rotation) {
        if ((rotation &= 3) == 0) {
            return y;
        }
        if (rotation == 1) {
            return 7 + -x;
        }
        if (rotation == 2) {
            return -y + 7;
        }
        return x;
    }

    private void constructMapRegionObjects(int drawX, int drawY, int drawingPlane, int orientation, int x, int y, int plane, byte[] objectData, CollisionMap[] collisionMaps) {
        int idOffset;
        Buffer objectBuffer = new Buffer(objectData);
        int i = -1;
        while ((idOffset = objectBuffer.getSmart()) != 0) {
            int objectInfoOffset;
            int objectPositionInfo = 0;
            i += idOffset;
            while ((objectInfoOffset = objectBuffer.getSmart()) != 0) {
                int objectPlane = (objectPositionInfo += -1 + objectInfoOffset) >> 12;
                int objectX = 0x3F & objectPositionInfo >> 6;
                int objectMetadata = objectBuffer.getUnsignedByte();
                int objectType = objectMetadata >> 2;
                int objectY = objectPositionInfo & 0x3F;
                int originalOrientation = objectMetadata & 3;
                if (objectPlane != drawingPlane || drawX > objectX || objectX >= 8 + drawX || drawY > objectY || drawY + 8 <= objectY) continue;
                GameObjectDefinition gameObjectDefinition = GameObjectDefinition.getDefinition(i);
                int tileX = Landscape.getRotatedObjectX(objectX & 7, 7 & objectY, gameObjectDefinition.sizeX, gameObjectDefinition.sizeY, orientation, originalOrientation) + x;
                int tileY = Landscape.getRotatedObjectY(objectX & 7, objectY & 7, gameObjectDefinition.sizeX, gameObjectDefinition.sizeY, orientation, originalOrientation) + y;
                if (tileX <= 0 || tileY <= 0 || tileX >= 103 || tileY >= 103) continue;
                CollisionMap collisionMap = null;
                int collisionMapPlane = plane;
                if ((MovedStatics.tile_flags[1][tileX][tileY] & 2) == 2) {
                    --collisionMapPlane;
                }
                if (collisionMapPlane >= 0) {
                    collisionMap = collisionMaps[collisionMapPlane];
                }
                this.addObject(i, tileX, tileY, plane, originalOrientation + orientation & 3, objectType, collisionMap);
            }
        }
    }

    private static int getRotatedObjectX(int x, int y, int sizeX, int sizeY, int orientation, int originalOrientation) {
        orientation &= 3;
        if ((originalOrientation & 1) == 1) {
            int i = sizeX;
            sizeX = sizeY;
            sizeY = i;
        }
        if (orientation == 0) {
            return x;
        }
        if (orientation == 1) {
            return y;
        }
        if (orientation == 2) {
            return 7 - (x + sizeX) + 1;
        }
        return 7 + -y + 1 + -sizeY;
    }

    private static int getRotatedObjectY(int x, int y, int sizeX, int sizeY, int orientation, int originalOrientation) {
        orientation &= 3;
        if ((originalOrientation & 1) == 1) {
            int i = sizeX;
            sizeX = sizeY;
            sizeY = i;
        }
        if (orientation == 0) {
            return y;
        }
        if (orientation == 1) {
            return 1 + -sizeX + 7 - x;
        }
        if (orientation == 2) {
            return -sizeY + 1 + -y + 7;
        }
        return x;
    }

    private void createRegion(CollisionMap[] collisionMaps) {
        int y;
        for (int plane = 0; plane < 4; ++plane) {
            for (int x = 0; x < 104; ++x) {
                for (int y2 = 0; y2 < 104; ++y2) {
                    if ((1 & MovedStatics.tile_flags[plane][x][y2]) != 1) continue;
                    int markingPlane = plane;
                    if ((2 & MovedStatics.tile_flags[1][x][y2]) == 2) {
                        --markingPlane;
                    }
                    if (markingPlane < 0) continue;
                    collisionMaps[markingPlane].markBlocked(y2, x);
                }
            }
        }
        randomiserLightness += -2 + (int)(5.0 * Math.random());
        if ((randomiserHue += (int)(5.0 * Math.random()) + -2) < -8) {
            randomiserHue = -8;
        }
        if (randomiserHue > 8) {
            randomiserHue = 8;
        }
        if (randomiserLightness < -16) {
            randomiserLightness = -16;
        }
        if (randomiserLightness > 16) {
            randomiserLightness = 16;
        }
        for (int _plane = 0; _plane < 4; ++_plane) {
            byte[][] shadowIntensity = tileShadowIntensity[_plane];
            int directionalLightLength = (int)Math.sqrt(5100.0);
            int specularDistribution = directionalLightLength * 768 >> 8;
            for (int y3 = 1; y3 < 103; ++y3) {
                for (int x = 1; x < 103; ++x) {
                    int heightDifferenceX = -this.tile_height[_plane][x - 1][y3] + this.tile_height[_plane][1 + x][y3];
                    int heightDifferenceY = this.tile_height[_plane][x][y3 + 1] + -this.tile_height[_plane][x][y3 + -1];
                    int normalisedLength = (int)Math.sqrt(heightDifferenceY * heightDifferenceY + heightDifferenceX * heightDifferenceX + 65536);
                    int normalisedZ = 65536 / normalisedLength;
                    int weightedShadowIntensity = (shadowIntensity[x][y3] >> 1) + (shadowIntensity[x][-1 + y3] >> 2) + (shadowIntensity[1 + x][y3] >> 3) + (shadowIntensity[x - 1][y3] >> 2) + (shadowIntensity[x][1 + y3] >> 3);
                    int normalisedX = (heightDifferenceX << 8) / normalisedLength;
                    int normalisedY = (heightDifferenceY << 8) / normalisedLength;
                    int directionalLightIntensity = 96 + (normalisedX * -50 + -10 * normalisedZ + normalisedY * -50) / specularDistribution;
                    Landscape.tileLightIntensity[x][y3] = directionalLightIntensity + -weightedShadowIntensity;
                }
            }
            for (int i_15_ = 0; i_15_ < 104; ++i_15_) {
                Landscape.blendedHue[i_15_] = 0;
                Landscape.blendedSaturation[i_15_] = 0;
                Landscape.blendedLightness[i_15_] = 0;
                Landscape.blendedHueMultiplier[i_15_] = 0;
                Landscape.blendDirectionTracker[i_15_] = 0;
            }
            for (int x = -5; x < 109; ++x) {
                for (y = 0; y < 104; ++y) {
                    int underlayId;
                    int negativeX;
                    int underlayId2;
                    int positiveX = 5 + x;
                    if (positiveX >= 0 && positiveX < 104 && (underlayId2 = 0xFF & tile_underlayids[_plane][positiveX][y]) > 0) {
                        UnderlayDefinition underlayDefinition = UnderlayDefinition.getDefinition(underlayId2 - 1);
                        int n = y;
                        blendedHue[n] = blendedHue[n] + underlayDefinition.hue;
                        int n2 = y;
                        blendedSaturation[n2] = blendedSaturation[n2] + underlayDefinition.saturation;
                        int n3 = y;
                        blendedLightness[n3] = blendedLightness[n3] + underlayDefinition.lightness;
                        int n4 = y;
                        blendedHueMultiplier[n4] = blendedHueMultiplier[n4] + underlayDefinition.hueMultiplier;
                        int n5 = y;
                        blendDirectionTracker[n5] = blendDirectionTracker[n5] + 1;
                    }
                    if ((negativeX = x - 5) < 0 || negativeX >= 104 || (underlayId = 0xFF & tile_underlayids[_plane][negativeX][y]) <= 0) continue;
                    UnderlayDefinition underlayDefinition = UnderlayDefinition.getDefinition(underlayId - 1);
                    int n = y;
                    blendedHue[n] = blendedHue[n] - underlayDefinition.hue;
                    int n6 = y;
                    blendedSaturation[n6] = blendedSaturation[n6] - underlayDefinition.saturation;
                    int n7 = y;
                    blendedLightness[n7] = blendedLightness[n7] - underlayDefinition.lightness;
                    int n8 = y;
                    blendedHueMultiplier[n8] = blendedHueMultiplier[n8] - underlayDefinition.hueMultiplier;
                    int n9 = y;
                    blendDirectionTracker[n9] = blendDirectionTracker[n9] - 1;
                }
                if (x < 1 || x >= 103) continue;
                int hue = 0;
                int saturation = 0;
                int lightness = 0;
                int direction = 0;
                int hueMultiplier = 0;
                for (int y4 = -5; y4 < 109; ++y4) {
                    int positiveY = y4 + 5;
                    int negativeY = y4 - 5;
                    if (positiveY >= 0 && positiveY < 104) {
                        hueMultiplier += blendedHueMultiplier[positiveY];
                        saturation += blendedSaturation[positiveY];
                        direction += blendDirectionTracker[positiveY];
                        lightness += blendedLightness[positiveY];
                        hue += blendedHue[positiveY];
                    }
                    if (negativeY >= 0 && negativeY < 104) {
                        saturation -= blendedSaturation[negativeY];
                        direction -= blendDirectionTracker[negativeY];
                        lightness -= blendedLightness[negativeY];
                        hueMultiplier -= blendedHueMultiplier[negativeY];
                        hue -= blendedHue[negativeY];
                    }
                    if (y4 < 1 || y4 >= 103 || VertexNormal.lowMemory && (2 & MovedStatics.tile_flags[0][x][y4]) == 0 && ((0x10 & MovedStatics.tile_flags[_plane][x][y4]) != 0 || MovedStatics.onBuildTimePlane != MovedStatics.getVisibilityPlaneFor(_plane, y4, x))) continue;
                    if (lowestPlane > _plane) {
                        lowestPlane = _plane;
                    }
                    int underlayId = tile_underlayids[_plane][x][y4] & 0xFF;
                    int overlayId = tile_overlayids[_plane][x][y4] & 0xFF;
                    if (underlayId <= 0 && overlayId <= 0) continue;
                    int vertexHeightSW = this.tile_height[_plane][x][y4];
                    int vertexHeightSE = this.tile_height[_plane][x + 1][y4];
                    int vertexHeightNE = this.tile_height[_plane][x + 1][1 + y4];
                    int vertexHeightNW = this.tile_height[_plane][x][y4 + 1];
                    int lightIntensitySW = tileLightIntensity[x][y4];
                    int lightIntensitySE = tileLightIntensity[x + 1][y4];
                    int lightIntensityNE = tileLightIntensity[x + 1][y4 + 1];
                    int hslBitsetOriginal = -1;
                    int lightIntensityNW = tileLightIntensity[x][y4 + 1];
                    int hslBitsetRandomised = -1;
                    if (underlayId > 0) {
                        int h = 256 * hue / hueMultiplier;
                        int s = saturation / direction;
                        int l = lightness / direction;
                        hslBitsetOriginal = Landscape.generateHslBitset(s, l, h);
                        h = h + randomiserHue & 0xFF;
                        if ((l += randomiserLightness) >= 0) {
                            if (l > 255) {
                                l = 255;
                            }
                        } else {
                            l = 0;
                        }
                        hslBitsetRandomised = Landscape.generateHslBitset(s, l, h);
                    }
                    if (_plane > 0) {
                        boolean hideUnderlay = true;
                        if (underlayId == 0 && tile_underlay_path[_plane][x][y4] != 0) {
                            hideUnderlay = false;
                        }
                        if (overlayId > 0 && !OverlayDefinition.getDefinition((int)(-1 + overlayId), (int)4).hideOverlay) {
                            hideUnderlay = false;
                        }
                        if (hideUnderlay && vertexHeightSW == vertexHeightSE && vertexHeightNE == vertexHeightSW && vertexHeightSW == vertexHeightNW) {
                            Landscape.tileCullingBitsets[_plane][x][y4] = BitUtils.bitWiseOR(tileCullingBitsets[_plane][x][y4], 2340);
                        }
                    }
                    int underlayMinimapColour = 0;
                    if (hslBitsetRandomised != -1) {
                        underlayMinimapColour = Rasterizer3D.hsl2rgb[Landscape.mixLightness(hslBitsetRandomised, 96)];
                    }
                    if (overlayId != 0) {
                        int overlayMinimapColour;
                        int hslBitset;
                        int shape = 1 + tile_underlay_path[_plane][x][y4];
                        byte rotation = tile_overlay_rotation[_plane][x][y4];
                        OverlayDefinition overlayDefinition = OverlayDefinition.getDefinition(-1 + overlayId, 4);
                        int textureId = overlayDefinition.texture;
                        if (textureId >= 0) {
                            hslBitset = -1;
                            overlayMinimapColour = Rasterizer3D.interface3.getAverageTextureColour(textureId);
                        } else if (overlayDefinition.color == 0xFF00FF) {
                            hslBitset = -2;
                            textureId = -1;
                            overlayMinimapColour = -2;
                        } else {
                            hslBitset = Landscape.generateHslBitset(overlayDefinition.lightness, overlayDefinition.saturation, overlayDefinition.hue);
                            int h = randomiserHue + overlayDefinition.hue & 0xFF;
                            int s = randomiserLightness + overlayDefinition.saturation;
                            if (s < 0) {
                                s = 0;
                            } else if (s > 255) {
                                s = 255;
                            }
                            overlayMinimapColour = Landscape.generateHslBitset(overlayDefinition.lightness, s, h);
                        }
                        int rgb = 0;
                        if (overlayMinimapColour != -2) {
                            rgb = Rasterizer3D.hsl2rgb[MovedStatics.mixLightnessSigned(overlayMinimapColour, 96)];
                        }
                        if (overlayDefinition.secondaryColor != -1) {
                            int i_54_ = 0xFF & randomiserHue + overlayDefinition.otherHue;
                            int i_55_ = overlayDefinition.otherSaturation + randomiserLightness;
                            if (i_55_ >= 0) {
                                if (i_55_ > 255) {
                                    i_55_ = 255;
                                }
                            } else {
                                i_55_ = 0;
                            }
                            overlayMinimapColour = Landscape.generateHslBitset(overlayDefinition.otherLightness, i_55_, i_54_);
                            rgb = Rasterizer3D.hsl2rgb[MovedStatics.mixLightnessSigned(overlayMinimapColour, 96)];
                        }
                        this.scene.addTile(_plane, x, y4, shape, rotation, textureId, vertexHeightSW, vertexHeightSE, vertexHeightNE, vertexHeightNW, Landscape.mixLightness(hslBitsetOriginal, lightIntensitySW), Landscape.mixLightness(hslBitsetOriginal, lightIntensitySE), Landscape.mixLightness(hslBitsetOriginal, lightIntensityNE), Landscape.mixLightness(hslBitsetOriginal, lightIntensityNW), MovedStatics.mixLightnessSigned(hslBitset, lightIntensitySW), MovedStatics.mixLightnessSigned(hslBitset, lightIntensitySE), MovedStatics.mixLightnessSigned(hslBitset, lightIntensityNE), MovedStatics.mixLightnessSigned(hslBitset, lightIntensityNW), underlayMinimapColour, rgb);
                        continue;
                    }
                    this.scene.addTile(_plane, x, y4, 0, 0, -1, vertexHeightSW, vertexHeightSE, vertexHeightNE, vertexHeightNW, Landscape.mixLightness(hslBitsetOriginal, lightIntensitySW), Landscape.mixLightness(hslBitsetOriginal, lightIntensitySE), Landscape.mixLightness(hslBitsetOriginal, lightIntensityNE), Landscape.mixLightness(hslBitsetOriginal, lightIntensityNW), 0, 0, 0, 0, underlayMinimapColour, 0);
                }
            }
            for (int i_56_ = 1; i_56_ < 103; ++i_56_) {
                for (int i_57_ = 1; i_57_ < 103; ++i_57_) {
                    this.scene.setDrawLevel(_plane, i_57_, i_56_, MovedStatics.getVisibilityPlaneFor(_plane, i_56_, i_57_));
                }
            }
            Landscape.tile_underlayids[_plane] = null;
            Landscape.tile_overlayids[_plane] = null;
            Landscape.tile_underlay_path[_plane] = null;
            Landscape.tile_overlay_rotation[_plane] = null;
            Landscape.tileShadowIntensity[_plane] = null;
        }
        this.scene.buildModels(-50, -10, -50);
        for (int i = 0; i < 104; ++i) {
            for (int i_58_ = 0; i_58_ < 104; ++i_58_) {
                if ((MovedStatics.tile_flags[1][i][i_58_] & 2) != 2) continue;
                this.scene.setTileBridge(i, i_58_);
            }
        }
        int renderRule1 = 1;
        int i_59_ = 2;
        int i_60_ = 4;
        for (int plane = 0; plane < 4; ++plane) {
            if (plane > 0) {
                renderRule1 <<= 3;
                i_60_ <<= 3;
                i_59_ <<= 3;
            }
            for (int _plane = 0; _plane <= plane; ++_plane) {
                for (y = 0; y <= 104; ++y) {
                    for (int x = 0; x <= 104; ++x) {
                        int i_91_;
                        if ((tileCullingBitsets[_plane][x][y] & renderRule1) != 0) {
                            int i_71_;
                            int i_67_;
                            int i_66_;
                            int i_65_;
                            for (i_65_ = y; i_65_ > 0 && (renderRule1 & tileCullingBitsets[_plane][x][-1 + i_65_]) != 0; --i_65_) {
                            }
                            for (i_66_ = y; i_66_ < 104 && (tileCullingBitsets[_plane][x][i_66_ + 1] & renderRule1) != 0; ++i_66_) {
                            }
                            int i_68_ = _plane;
                            block20: for (i_67_ = _plane; i_67_ > 0; --i_67_) {
                                for (int i_69_ = i_65_; i_69_ <= i_66_; ++i_69_) {
                                    if ((tileCullingBitsets[-1 + i_67_][x][i_69_] & renderRule1) == 0) break block20;
                                }
                            }
                            block22: while (i_68_ < plane) {
                                for (int i_70_ = i_65_; i_70_ <= i_66_; ++i_70_) {
                                    if ((renderRule1 & tileCullingBitsets[i_68_ + 1][x][i_70_]) == 0) break block22;
                                }
                                ++i_68_;
                            }
                            if ((i_71_ = (-i_65_ + i_66_ + 1) * (-i_67_ + i_68_ + 1)) >= 8) {
                                int i_72_ = 240;
                                int i_73_ = -i_72_ + this.tile_height[i_68_][x][i_65_];
                                int i_74_ = this.tile_height[i_67_][x][i_65_];
                                this.scene.createOccluder(plane, 1, 128 * x, 128 * x, 128 * i_65_, 128 + 128 * i_66_, i_73_, i_74_);
                                for (int i_75_ = i_67_; i_75_ <= i_68_; ++i_75_) {
                                    for (int i_76_ = i_65_; i_76_ <= i_66_; ++i_76_) {
                                        Landscape.tileCullingBitsets[i_75_][x][i_76_] = BitUtils.bitWiseAND(tileCullingBitsets[i_75_][x][i_76_], ~renderRule1);
                                    }
                                }
                            }
                        }
                        if ((i_59_ & tileCullingBitsets[_plane][x][y]) != 0) {
                            int occlusionSurface;
                            int highestOcclusionX;
                            int lowestOcclusionX;
                            for (lowestOcclusionX = x; lowestOcclusionX > 0 && (i_59_ & tileCullingBitsets[_plane][lowestOcclusionX - 1][y]) != 0; --lowestOcclusionX) {
                            }
                            int highestOcclusionPlane = _plane;
                            int lowestOcclusionPlane = _plane;
                            for (highestOcclusionX = x; highestOcclusionX < 104 && (i_59_ & tileCullingBitsets[_plane][1 + highestOcclusionX][y]) != 0; ++highestOcclusionX) {
                            }
                            block28: while (lowestOcclusionPlane > 0) {
                                for (int i_81_ = lowestOcclusionX; i_81_ <= highestOcclusionX; ++i_81_) {
                                    if ((tileCullingBitsets[lowestOcclusionPlane + -1][i_81_][y] & i_59_) == 0) break block28;
                                }
                                --lowestOcclusionPlane;
                            }
                            block30: while (highestOcclusionPlane < plane) {
                                for (int i_82_ = lowestOcclusionX; i_82_ <= highestOcclusionX; ++i_82_) {
                                    if ((i_59_ & tileCullingBitsets[1 + highestOcclusionPlane][i_82_][y]) == 0) break block30;
                                }
                                ++highestOcclusionPlane;
                            }
                            if ((occlusionSurface = (highestOcclusionX - lowestOcclusionX + 1) * (-lowestOcclusionPlane + 1 + highestOcclusionPlane)) >= 8) {
                                int lowestOcclusionVertexHeight = this.tile_height[lowestOcclusionPlane][lowestOcclusionX][y];
                                int highestOcclusionVertexHeightOffset = 240;
                                int highestOcclusionVertexHeight = this.tile_height[highestOcclusionPlane][lowestOcclusionX][y] - highestOcclusionVertexHeightOffset;
                                this.scene.createOccluder(plane, 2, 128 * lowestOcclusionX, 128 * highestOcclusionX + 128, 128 * y, y * 128, highestOcclusionVertexHeight, lowestOcclusionVertexHeight);
                                for (int occludedPlane = lowestOcclusionPlane; highestOcclusionPlane >= occludedPlane; ++occludedPlane) {
                                    for (int occludedX = lowestOcclusionX; occludedX <= highestOcclusionX; ++occludedX) {
                                        Landscape.tileCullingBitsets[occludedPlane][occludedX][y] = BitUtils.bitWiseAND(tileCullingBitsets[occludedPlane][occludedX][y], ~i_59_);
                                    }
                                }
                            }
                        }
                        if ((tileCullingBitsets[_plane][x][y] & i_60_) == 0) continue;
                        int i_89_ = x;
                        int i_90_ = x;
                        int i_92_ = y;
                        for (i_91_ = y; i_91_ > 0 && (tileCullingBitsets[_plane][x][-1 + i_91_] & i_60_) != 0; --i_91_) {
                        }
                        while (i_92_ < 104 && (i_60_ & tileCullingBitsets[_plane][x][i_92_ + 1]) != 0) {
                            ++i_92_;
                        }
                        block36: while (i_89_ > 0) {
                            for (int i_93_ = i_91_; i_93_ <= i_92_; ++i_93_) {
                                if ((i_60_ & tileCullingBitsets[_plane][i_89_ + -1][i_93_]) == 0) break block36;
                            }
                            --i_89_;
                        }
                        block38: while (i_90_ < 104) {
                            for (int i_94_ = i_91_; i_92_ >= i_94_; ++i_94_) {
                                if ((i_60_ & tileCullingBitsets[_plane][1 + i_90_][i_94_]) == 0) break block38;
                            }
                            ++i_90_;
                        }
                        if ((-i_89_ + i_90_ + 1) * (1 + i_92_ - i_91_) < 4) continue;
                        int i_95_ = this.tile_height[_plane][i_89_][i_91_];
                        this.scene.createOccluder(plane, 4, i_89_ * 128, i_90_ * 128 + 128, 128 * i_91_, i_92_ * 128 + 128, i_95_, i_95_);
                        for (int i_96_ = i_89_; i_96_ <= i_90_; ++i_96_) {
                            for (int i_97_ = i_91_; i_92_ >= i_97_; ++i_97_) {
                                Landscape.tileCullingBitsets[_plane][i_96_][i_97_] = BitUtils.bitWiseAND(tileCullingBitsets[_plane][i_96_][i_97_], ~i_60_);
                            }
                        }
                    }
                }
            }
        }
    }

    private static void clearTemporaryObjects() {
        InteractiveObjectTemporary interactiveObjectTemporary = (InteractiveObjectTemporary)MovedStatics.interactiveObjectTemporaryNodeCache.peekFirst();
        while (interactiveObjectTemporary != null) {
            if (interactiveObjectTemporary.duration == -1) {
                interactiveObjectTemporary.delay = 0;
                InteractiveObjectTemporary.setPrevousObjectDetails(interactiveObjectTemporary);
            } else {
                interactiveObjectTemporary.unlink();
            }
            interactiveObjectTemporary = (InteractiveObjectTemporary)MovedStatics.interactiveObjectTemporaryNodeCache.pollFirst();
        }
    }

    private static void method973() {
        blendedHueMultiplier = null;
        blendedLightness = null;
        blendDirectionTracker = null;
        tileCullingBitsets = null;
        tileLightIntensity = null;
        tile_overlay_rotation = null;
        blendedSaturation = null;
        tileShadowIntensity = null;
        tile_underlay_path = null;
        tile_overlayids = null;
        tile_underlayids = null;
        blendedHue = null;
    }

    private static void method1020() {
        blendedSaturation = new int[104];
        tile_underlay_path = new byte[4][104][104];
        tileCullingBitsets = new int[4][105][105];
        lowestPlane = 99;
        tileShadowIntensity = new byte[4][105][105];
        blendDirectionTracker = new int[104];
        blendedHueMultiplier = new int[104];
        blendedLightness = new int[104];
        tileLightIntensity = new int[105][105];
        tile_overlayids = new byte[4][104][104];
        blendedHue = new int[104];
        tile_overlay_rotation = new byte[4][104][104];
        tile_underlayids = new byte[4][104][104];
    }

    private void loadTerrainBlock(CollisionMap[] collisions, int regionX_maybe, byte[] blockData, int offsetX, int offsetY, int regionY_maybe) {
        for (int i = 0; i < 4; ++i) {
            for (int i_1_ = 0; i_1_ < 64; ++i_1_) {
                for (int i_2_ = 0; i_2_ < 64; ++i_2_) {
                    if (offsetX + i_1_ <= 0 || i_1_ + offsetX >= 103 || offsetY + i_2_ <= 0 || i_2_ + offsetY >= 103) continue;
                    collisions[i].clippingData[i_1_ + offsetX][i_2_ + offsetY] = BitUtils.bitWiseAND(collisions[i].clippingData[i_1_ + offsetX][i_2_ + offsetY], -16777217);
                }
            }
        }
        Buffer class40_sub1 = new Buffer(blockData);
        for (int plane = 0; plane < 4; ++plane) {
            for (int tileX = 0; tileX < 64; ++tileX) {
                for (int tileY = 0; tileY < 64; ++tileY) {
                    this.method922(tileX + offsetX, 0, class40_sub1, tileY + offsetY, regionY_maybe, regionX_maybe, plane);
                }
            }
        }
    }

    private void method922(int x, int arg1, Buffer fileData, int y, int regionY, int regionX, int level) {
        block13: {
            int i;
            if (x >= 0 && x < 104 && y >= 0 && y < 104) {
                MovedStatics.tile_flags[level][x][y] = 0;
                while (true) {
                    int opcode;
                    if ((opcode = fileData.getUnsignedByte()) == 0) {
                        if (level == 0) {
                            this.tile_height[0][x][y] = -Landscape.getPerlinVertexHeight(regionX + x + 932731, regionY + 556238 + y) * 8;
                        } else {
                            this.tile_height[level][x][y] = -240 + this.tile_height[level + -1][x][y];
                        }
                        break block13;
                    }
                    if (opcode == 1) {
                        int tileHeight = fileData.getUnsignedByte();
                        if (tileHeight == 1) {
                            tileHeight = 0;
                        }
                        if (level != 0) {
                            this.tile_height[level][x][y] = this.tile_height[-1 + level][x][y] + -(8 * tileHeight);
                        } else {
                            this.tile_height[0][x][y] = 8 * -tileHeight;
                        }
                        break block13;
                    }
                    if (opcode <= 49) {
                        Landscape.tile_overlayids[level][x][y] = fileData.getByte();
                        Landscape.tile_underlay_path[level][x][y] = (byte)((opcode + -2) / 4);
                        Landscape.tile_overlay_rotation[level][x][y] = (byte)BitUtils.bitWiseAND(arg1 + -2 + opcode, 3);
                        continue;
                    }
                    if (opcode <= 81) {
                        MovedStatics.tile_flags[level][x][y] = (byte)(-49 + opcode);
                        continue;
                    }
                    Landscape.tile_underlayids[level][x][y] = (byte)(-81 + opcode);
                }
            }
            while ((i = fileData.getUnsignedByte()) != 0) {
                if (i == 1) {
                    fileData.getUnsignedByte();
                    break;
                }
                if (i > 49) continue;
                fileData.getUnsignedByte();
            }
        }
    }

    private static int mixLightness(int hsl, int lightness) {
        if (hsl == -1) {
            return 12345678;
        }
        if ((lightness = (0x7F & hsl) * lightness / 128) < 2) {
            lightness = 2;
        } else if (lightness > 126) {
            lightness = 126;
        }
        return lightness + (hsl & 0xFF80);
    }

    private void loadObjectBlock(int block_x, CollisionMap[] collisionMaps, byte[] block_data, int block_z) {
        int delta_id;
        Buffer buffer = new Buffer(block_data);
        int object_id = -1;
        while ((delta_id = buffer.getSmart()) != 0) {
            int delta_pos;
            int pos = 0;
            object_id += delta_id;
            while ((delta_pos = buffer.getSmart()) != 0) {
                int tile_z = (pos += -1 + delta_pos) & 0x3F;
                int tile_x = pos >> 6 & 0x3F;
                int tile_y = pos >> 12;
                int object_info = buffer.getUnsignedByte();
                int object_type = object_info >> 2;
                int object_orientation = 3 & object_info;
                int object_x = tile_x + block_x;
                int object_z = tile_z + block_z;
                if (object_x <= 0 || object_z <= 0 || object_x >= 103 || object_z >= 103) continue;
                CollisionMap collisionMap = null;
                int logic_y = tile_y;
                if ((MovedStatics.tile_flags[1][object_x][object_z] & 2) == 2) {
                    --logic_y;
                }
                if (logic_y >= 0) {
                    collisionMap = collisionMaps[logic_y];
                }
                this.addObject(object_id, object_x, object_z, tile_y, object_orientation, object_type, collisionMap);
            }
        }
    }

    public void addObject(int objectId, int localX, int localY, int plane, int face, int type, CollisionMap collisionMap) {
        if (!VertexNormal.lowMemory || (2 & MovedStatics.tile_flags[0][localX][localY]) != 0 || (0x10 & MovedStatics.tile_flags[plane][localX][localY]) == 0 && MovedStatics.onBuildTimePlane == MovedStatics.getVisibilityPlaneFor(plane, localY, localX)) {
            if (lowestPlane > plane) {
                lowestPlane = plane;
            }
            int vertexHeight = this.tile_height[plane][localX][localY];
            int vertexHeightRight = this.tile_height[plane][localX + 1][localY];
            int vertexHeightTopRight = this.tile_height[plane][localX + 1][localY + 1];
            int vertexHeightTop = this.tile_height[plane][localX][localY + 1];
            int vertexMix = vertexHeight + vertexHeightRight + vertexHeightTopRight + vertexHeightTop >> 2;
            GameObjectDefinition gameObjectDefinition = GameObjectDefinition.getDefinition(objectId);
            int hash = localX + (localY << 7) + (objectId << 14) + 0x40000000;
            int objectConfig = (face << 6) + type;
            if (gameObjectDefinition.supportsItems == 1) {
                objectConfig += 256;
            }
            if (gameObjectDefinition.hasActions == 0) {
                hash -= Integer.MIN_VALUE;
            }
            if (gameObjectDefinition.hasSounds()) {
                SoundSystem.addObjectSounds(localY, plane, face, localX, gameObjectDefinition);
            }
            if (type == 22) {
                if (!VertexNormal.lowMemory || gameObjectDefinition.hasActions != 0 || gameObjectDefinition.obstructsGround) {
                    Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, face, vertexHeight, 22, vertexHeightRight) : new GameObject(objectId, 22, face, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                    this.scene.addGroundDecoration(localX, localY, plane, vertexMix, hash, renderable, objectConfig);
                    if (gameObjectDefinition.solid && gameObjectDefinition.hasActions == 1 && collisionMap != null) {
                        collisionMap.markBlocked(localY, localX);
                    }
                }
            } else if (type == 10 || type == 11) {
                Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, face, vertexHeight, 10, vertexHeightRight) : new GameObject(objectId, 10, face, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                if (renderable != null) {
                    Renderable class40_sub5_sub17_sub5;
                    int i_41_;
                    int i_40_;
                    if (face == 1 || face == 3) {
                        i_40_ = gameObjectDefinition.sizeX;
                        i_41_ = gameObjectDefinition.sizeY;
                    } else {
                        i_41_ = gameObjectDefinition.sizeX;
                        i_40_ = gameObjectDefinition.sizeY;
                    }
                    int i_42_ = 0;
                    if (type == 11) {
                        i_42_ += 256;
                    }
                    if (this.scene.addEntityB(localX, localY, plane, vertexMix, i_42_, i_40_, i_41_, hash, renderable, objectConfig) && gameObjectDefinition.castsShadow && (class40_sub5_sub17_sub5 = renderable instanceof Model ? renderable : gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, face, vertexHeight, 10, vertexHeightRight)) != null) {
                        for (int i_43_ = 0; i_43_ <= i_41_; ++i_43_) {
                            for (int i_44_ = 0; i_40_ >= i_44_; ++i_44_) {
                                int i_45_ = ((Model)class40_sub5_sub17_sub5).method805() / 4;
                                if (i_45_ > 30) {
                                    i_45_ = 30;
                                }
                                if (i_45_ <= tileShadowIntensity[plane][localX + i_43_][localY + i_44_]) continue;
                                Landscape.tileShadowIntensity[plane][i_43_ + localX][localY + i_44_] = (byte)i_45_;
                            }
                        }
                    }
                }
                if (gameObjectDefinition.solid && collisionMap != null) {
                    collisionMap.unmarkSolidOccupant(localX, localY, gameObjectDefinition.sizeX, gameObjectDefinition.sizeY, face, gameObjectDefinition.walkable);
                }
            } else if (type >= 12) {
                Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(objectId, type, face, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, face, vertexHeight, type, vertexHeightRight);
                this.scene.addEntityB(localX, localY, plane, vertexMix, 0, 1, 1, hash, renderable, objectConfig);
                if (type >= 12 && type <= 17 && type != 13 && plane > 0) {
                    Landscape.tileCullingBitsets[plane][localX][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][localY], 2340);
                }
                if (gameObjectDefinition.solid && collisionMap != null) {
                    collisionMap.unmarkSolidOccupant(localX, localY, gameObjectDefinition.sizeX, gameObjectDefinition.sizeY, face, gameObjectDefinition.walkable);
                }
            } else if (type == 0) {
                Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, face, vertexHeight, 0, vertexHeightRight) : new GameObject(objectId, 0, face, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                this.scene.addWall(localX, localY, plane, vertexMix, Scene.ROTATION_WALL_TYPE[face], 0, hash, renderable, null, objectConfig);
                if (face == 0) {
                    if (gameObjectDefinition.castsShadow) {
                        Landscape.tileShadowIntensity[plane][localX][localY] = 50;
                        Landscape.tileShadowIntensity[plane][localX][localY + 1] = 50;
                    }
                    if (gameObjectDefinition.wall) {
                        Landscape.tileCullingBitsets[plane][localX][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][localY], 585);
                    }
                } else if (face == 1) {
                    if (gameObjectDefinition.castsShadow) {
                        Landscape.tileShadowIntensity[plane][localX][localY + 1] = 50;
                        Landscape.tileShadowIntensity[plane][localX + 1][1 + localY] = 50;
                    }
                    if (gameObjectDefinition.wall) {
                        Landscape.tileCullingBitsets[plane][localX][localY + 1] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][localY + 1], 1170);
                    }
                } else if (face == 2) {
                    if (gameObjectDefinition.castsShadow) {
                        Landscape.tileShadowIntensity[plane][1 + localX][localY] = 50;
                        Landscape.tileShadowIntensity[plane][localX + 1][1 + localY] = 50;
                    }
                    if (gameObjectDefinition.wall) {
                        Landscape.tileCullingBitsets[plane][localX + 1][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX + 1][localY], 585);
                    }
                } else if (face == 3) {
                    if (gameObjectDefinition.castsShadow) {
                        Landscape.tileShadowIntensity[plane][localX][localY] = 50;
                        Landscape.tileShadowIntensity[plane][localX + 1][localY] = 50;
                    }
                    if (gameObjectDefinition.wall) {
                        Landscape.tileCullingBitsets[plane][localX][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][localY], 1170);
                    }
                }
                if (gameObjectDefinition.solid && collisionMap != null) {
                    collisionMap.unmarkWall(localX, localY, type, face, gameObjectDefinition.walkable);
                }
                if (gameObjectDefinition.setDecorDisplacement != 16) {
                    this.scene.setWallDecorationOffset(plane, localX, localY, gameObjectDefinition.setDecorDisplacement);
                }
            } else if (type == 1) {
                Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, face, vertexHeight, 1, vertexHeightRight) : new GameObject(objectId, 1, face, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                this.scene.addWall(localX, localY, plane, vertexMix, Scene.ROTATION_WALL_CORNER_TYPE[face], 0, hash, renderable, null, objectConfig);
                if (gameObjectDefinition.castsShadow) {
                    if (face == 0) {
                        Landscape.tileShadowIntensity[plane][localX][localY + 1] = 50;
                    } else if (face == 1) {
                        Landscape.tileShadowIntensity[plane][localX + 1][1 + localY] = 50;
                    } else if (face == 2) {
                        Landscape.tileShadowIntensity[plane][localX + 1][localY] = 50;
                    } else if (face == 3) {
                        Landscape.tileShadowIntensity[plane][localX][localY] = 50;
                    }
                }
                if (gameObjectDefinition.solid && collisionMap != null) {
                    collisionMap.unmarkWall(localX, localY, type, face, gameObjectDefinition.walkable);
                }
            } else if (type == 2) {
                Renderable renderable_47_;
                Renderable renderable;
                int i_46_ = 3 & face + 1;
                if (gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null) {
                    renderable = gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, face + 4, vertexHeight, 2, vertexHeightRight);
                    renderable_47_ = gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, i_46_, vertexHeight, 2, vertexHeightRight);
                } else {
                    renderable = new GameObject(objectId, 2, 4 + face, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                    renderable_47_ = new GameObject(objectId, 2, i_46_, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                }
                this.scene.addWall(localX, localY, plane, vertexMix, Scene.ROTATION_WALL_TYPE[face], Scene.ROTATION_WALL_TYPE[i_46_], hash, renderable, renderable_47_, objectConfig);
                if (gameObjectDefinition.wall) {
                    if (face == 0) {
                        Landscape.tileCullingBitsets[plane][localX][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][localY], 585);
                        Landscape.tileCullingBitsets[plane][localX][localY + 1] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][localY + 1], 1170);
                    } else if (face == 1) {
                        Landscape.tileCullingBitsets[plane][localX][1 + localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][1 + localY], 1170);
                        Landscape.tileCullingBitsets[plane][1 + localX][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][1 + localX][localY], 585);
                    } else if (face == 2) {
                        Landscape.tileCullingBitsets[plane][localX + 1][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX + 1][localY], 585);
                        Landscape.tileCullingBitsets[plane][localX][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][localY], 1170);
                    } else if (face == 3) {
                        Landscape.tileCullingBitsets[plane][localX][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][localY], 1170);
                        Landscape.tileCullingBitsets[plane][localX][localY] = BitUtils.bitWiseOR(tileCullingBitsets[plane][localX][localY], 585);
                    }
                }
                if (gameObjectDefinition.solid && collisionMap != null) {
                    collisionMap.unmarkWall(localX, localY, type, face, gameObjectDefinition.walkable);
                }
                if (gameObjectDefinition.setDecorDisplacement != 16) {
                    this.scene.setWallDecorationOffset(plane, localX, localY, gameObjectDefinition.setDecorDisplacement);
                }
            } else if (type == 3) {
                Renderable renderable = gameObjectDefinition.animationId != -1 || gameObjectDefinition.childIds != null ? new GameObject(objectId, 3, face, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true) : gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, face, vertexHeight, 3, vertexHeightRight);
                this.scene.addWall(localX, localY, plane, vertexMix, Scene.ROTATION_WALL_CORNER_TYPE[face], 0, hash, renderable, null, objectConfig);
                if (gameObjectDefinition.castsShadow) {
                    if (face != 0) {
                        if (face == 1) {
                            Landscape.tileShadowIntensity[plane][1 + localX][localY + 1] = 50;
                        } else if (face == 2) {
                            Landscape.tileShadowIntensity[plane][localX + 1][localY] = 50;
                        } else if (face == 3) {
                            Landscape.tileShadowIntensity[plane][localX][localY] = 50;
                        }
                    } else {
                        Landscape.tileShadowIntensity[plane][localX][localY + 1] = 50;
                    }
                }
                if (gameObjectDefinition.solid && collisionMap != null) {
                    collisionMap.unmarkWall(localX, localY, type, face, gameObjectDefinition.walkable);
                }
            } else if (type == 9) {
                Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, face, vertexHeight, type, vertexHeightRight) : new GameObject(objectId, type, face, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                this.scene.addEntityB(localX, localY, plane, vertexMix, 0, 1, 1, hash, renderable, objectConfig);
                if (gameObjectDefinition.solid && collisionMap != null) {
                    collisionMap.unmarkSolidOccupant(localX, localY, gameObjectDefinition.sizeX, gameObjectDefinition.sizeY, face, gameObjectDefinition.walkable);
                }
            } else {
                if (gameObjectDefinition.adjustToTerrain) {
                    if (face == 1) {
                        int i_48_ = vertexHeightTop;
                        vertexHeightTop = vertexHeightTopRight;
                        vertexHeightTopRight = vertexHeightRight;
                        vertexHeightRight = vertexHeight;
                        vertexHeight = i_48_;
                    } else if (face == 2) {
                        int i_49_ = vertexHeightTop;
                        vertexHeightTop = vertexHeightRight;
                        vertexHeightRight = i_49_;
                        i_49_ = vertexHeightTopRight;
                        vertexHeightTopRight = vertexHeight;
                        vertexHeight = i_49_;
                    } else if (face == 3) {
                        int i_50_ = vertexHeightTop;
                        vertexHeightTop = vertexHeight;
                        vertexHeight = vertexHeightRight;
                        vertexHeightRight = vertexHeightTopRight;
                        vertexHeightTopRight = i_50_;
                    }
                }
                if (type == 4) {
                    Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, 0, vertexHeight, 4, vertexHeightRight) : new GameObject(objectId, 4, 0, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                    this.scene.addWallDecoration(localX, localY, plane, vertexMix, 0, 0, 512 * face, hash, renderable, objectConfig, Scene.ROTATION_WALL_TYPE[face]);
                } else if (type == 5) {
                    int i_51_ = this.scene.getWallHash(plane, localX, localY);
                    int i_52_ = 16;
                    if (i_51_ > 0) {
                        i_52_ = GameObjectDefinition.getDefinition((int)((0x1FFFEDF2 & i_51_) >> 14)).setDecorDisplacement;
                    }
                    Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, 0, vertexHeight, 4, vertexHeightRight) : new GameObject(objectId, 4, 0, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                    this.scene.addWallDecoration(localX, localY, plane, vertexMix, i_52_ * Scene.WALL_DECORATION_ROTATION_FORWARD_X[face], Scene.WALL_DECORATION_ROTATION_FORWARD_Z[face] * i_52_, face * 512, hash, renderable, objectConfig, Scene.ROTATION_WALL_TYPE[face]);
                } else if (type == 6) {
                    Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, 0, vertexHeight, 4, vertexHeightRight) : new GameObject(objectId, 4, 0, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                    this.scene.addWallDecoration(localX, localY, plane, vertexMix, 0, 0, face, hash, renderable, objectConfig, 256);
                } else if (type == 7) {
                    Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, 0, vertexHeight, 4, vertexHeightRight) : new GameObject(objectId, 4, 0, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                    this.scene.addWallDecoration(localX, localY, plane, vertexMix, 0, 0, face, hash, renderable, objectConfig, 512);
                } else if (type == 8) {
                    Renderable renderable = gameObjectDefinition.animationId == -1 && gameObjectDefinition.childIds == null ? gameObjectDefinition.createTerrainObjectModel(vertexHeightTopRight, vertexHeightTop, 0, vertexHeight, 4, vertexHeightRight) : new GameObject(objectId, 4, 0, vertexHeight, vertexHeightRight, vertexHeightTopRight, vertexHeightTop, gameObjectDefinition.animationId, true);
                    this.scene.addWallDecoration(localX, localY, plane, vertexMix, 0, 0, face, hash, renderable, objectConfig, 768);
                }
            }
        }
    }

    private boolean decodeChunkObjects(byte[] data, int arg2, int arg3) {
        int deltaId;
        boolean bool = true;
        Buffer buffer = new Buffer(data);
        int objectId = -1;
        block0: while ((deltaId = buffer.getSmart()) != 0) {
            objectId += deltaId;
            int objectData = 0;
            boolean bool_2_ = false;
            while (true) {
                if (bool_2_) {
                    int i_3_ = buffer.getSmart();
                    if (i_3_ == 0) continue block0;
                    buffer.getUnsignedByte();
                    continue;
                }
                int i_4_ = buffer.getSmart();
                if (i_4_ == 0) continue block0;
                int i_5_ = (objectData += i_4_ + -1) & 0x3F;
                int i_6_ = buffer.getUnsignedByte() >> 2;
                int i_7_ = 0x3F & objectData >> 6;
                int i_8_ = i_7_ + arg2;
                int i_9_ = i_5_ + arg3;
                if (i_8_ <= 0 || i_9_ <= 0 || i_8_ >= 103 || i_9_ >= 103) continue;
                GameObjectDefinition gameObjectDefinition = GameObjectDefinition.getDefinition(objectId);
                if (i_6_ == 22 && VertexNormal.lowMemory && gameObjectDefinition.hasActions == 0 && !gameObjectDefinition.obstructsGround) continue;
                bool_2_ = true;
                if (gameObjectDefinition.method612()) continue;
                bool = false;
                ++Game.missingGameObjectFiles;
            }
        }
        return bool;
    }

    private static void method364(boolean arg1) {
        if (++MovedStatics.anInt537 >= 50 || arg1) {
            MovedStatics.anInt537 = 0;
            if (!Game.aBoolean871 && MovedStatics.gameServerSocket != null) {
                OutgoingPackets.buffer.putPacket(13);
                try {
                    MovedStatics.gameServerSocket.sendDataFromBuffer(OutgoingPackets.buffer.currentPosition, 0, OutgoingPackets.buffer.buffer);
                    OutgoingPackets.buffer.currentPosition = 0;
                }
                catch (IOException ioexception) {
                    Game.aBoolean871 = true;
                }
            }
        }
    }

    private void initiateVertexHeights(int offsetY, int sizeY, int sizeX, int offsetX) {
        for (int y = offsetY; y <= offsetY + sizeY; ++y) {
            for (int x = offsetX; sizeX + offsetX >= x; ++x) {
                if (x < 0 || x >= 104 || y < 0 || y >= 104) continue;
                Landscape.tileShadowIntensity[0][x][y] = 127;
                if (offsetX == x && x > 0) {
                    this.tile_height[0][x][y] = this.tile_height[0][-1 + x][y];
                }
                if (offsetX + sizeX == x && x < 103) {
                    this.tile_height[0][x][y] = this.tile_height[0][x + 1][y];
                }
                if (y == offsetY && y > 0) {
                    this.tile_height[0][x][y] = this.tile_height[0][x][y + -1];
                }
                if (y != offsetY + sizeY || y >= 103) continue;
                this.tile_height[0][x][y] = this.tile_height[0][x][1 + y];
            }
        }
    }

    private void matchChunkHeightmapWithSurroundings(int plane, int tileX, int tileY) {
        int x;
        for (x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                this.tile_height[plane][tileX + x][tileY + y] = 0;
            }
        }
        if (tileX > 0) {
            for (int y = 1; y < 8; ++y) {
                this.tile_height[plane][tileX][tileY + y] = this.tile_height[plane][tileX - 1][y + tileY];
            }
        }
        if (tileY > 0) {
            for (x = 1; x < 8; ++x) {
                this.tile_height[plane][tileX + x][tileY] = this.tile_height[plane][tileX + x][tileY - 1];
            }
        }
        if (tileX > 0 && this.tile_height[plane][tileX - 1][tileY] != 0) {
            this.tile_height[plane][tileX][tileY] = this.tile_height[plane][tileX - 1][tileY];
        } else if (tileY > 0 && this.tile_height[plane][tileX][tileY - 1] != 0) {
            this.tile_height[plane][tileX][tileY] = this.tile_height[plane][tileX][tileY - 1];
        } else if (tileX > 0 && tileY > 0 && this.tile_height[plane][tileX - 1][tileY - 1] != 0) {
            this.tile_height[plane][tileX][tileY] = this.tile_height[plane][tileX - 1][tileY - 1];
        }
    }

    private static int generateHslBitset(int s, int l, int h) {
        if (l > 179) {
            s /= 2;
        }
        if (l > 192) {
            s /= 2;
        }
        if (l > 217) {
            s /= 2;
        }
        if (l > 243) {
            s /= 2;
        }
        return l / 2 + (s / 32 << 7) + (h / 4 << 10);
    }

    private static int getPerlinVertexHeight(int x, int y) {
        int vertexHeight = -128 + PerlinNoise.get(x + 45365, 91923 + y, 4) - (-(PerlinNoise.get(x + 10294, 37821 + y, 2) - 128 >> 1) + -(-128 + PerlinNoise.get(x, y, 1) >> 2));
        if ((vertexHeight = 35 + (int)(0.3 * (double)vertexHeight)) >= 10) {
            if (vertexHeight > 60) {
                vertexHeight = 60;
            }
        } else {
            vertexHeight = 10;
        }
        return vertexHeight;
    }

    static {
        constructMapTiles = new int[4][13][13];
        loadGeneratedMap = false;
        randomiserLightness = -16 + (int)(Math.random() * 33.0);
        randomiserHue = -8 + (int)(17.0 * Math.random());
        lowestPlane = 99;
    }
}

