/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.runejs.client.MovedStatics;
import org.runejs.client.util.Signlink;
import org.runejs.client.util.SignlinkNode;

public class GameSocket
implements Runnable {
    public InputStream socketInputStream;
    public OutputStream socketOutputStream;
    public Socket socket;
    public SignlinkNode signLinkNode;
    public Signlink signLink;
    public boolean socketError = false;
    public int queuedDataPosition = 0;
    public int dataWrittenPosition = 0;
    public boolean socketDisconnected = false;
    public byte[] queuedData;

    public GameSocket(Socket socket, Signlink signLink) throws IOException {
        this.signLink = signLink;
        this.socket = socket;
        this.socket.setSoTimeout(30000);
        this.socket.setTcpNoDelay(true);
        this.socketInputStream = this.socket.getInputStream();
        this.socketOutputStream = this.socket.getOutputStream();
    }

    public void readDataToBuffer(byte[] buffer, int currentPosition, int packetSize) throws IOException {
        if (!this.socketDisconnected) {
            while (packetSize > 0) {
                int i = this.socketInputStream.read(buffer, currentPosition, packetSize);
                if (i <= 0) {
                    throw new EOFException();
                }
                packetSize -= i;
                currentPosition += i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        if (!this.socketDisconnected) {
            GameSocket gameSocket = this;
            synchronized (gameSocket) {
                this.socketDisconnected = true;
                this.notifyAll();
            }
            if (this.signLinkNode != null) {
                while (this.signLinkNode.status == SignlinkNode.Status.NOT_INITIALIZED) {
                    MovedStatics.threadSleep(1L);
                }
                if (this.signLinkNode.status == SignlinkNode.Status.INITIALIZED) {
                    try {
                        ((Thread)this.signLinkNode.value).join();
                    }
                    catch (InterruptedException interruptedexception) {
                        interruptedexception.printStackTrace();
                    }
                }
            }
            this.signLinkNode = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDataFromBuffer(int size, int startPos, byte[] data) throws IOException {
        if (!this.socketDisconnected) {
            if (this.socketError) {
                this.socketError = false;
                throw new IOException();
            }
            if (this.queuedData == null) {
                this.queuedData = new byte[5000];
            }
            GameSocket gameSocket = this;
            synchronized (gameSocket) {
                for (int currentByte = 0; currentByte < size; ++currentByte) {
                    this.queuedData[this.queuedDataPosition] = data[startPos + currentByte];
                    this.queuedDataPosition = (1 + this.queuedDataPosition) % 5000;
                    if (this.queuedDataPosition != (4900 + this.dataWrittenPosition) % 5000) continue;
                    throw new IOException();
                }
                if (this.signLinkNode == null) {
                    this.signLinkNode = this.signLink.putThreadNode(3, this);
                }
                this.notifyAll();
            }
        }
    }

    public void finalize() {
        this.kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) lbl-1000:
            // 5 sources

            {
                var3_5 = this;
                synchronized (var3_5) {
                    if (this.queuedDataPosition == this.dataWrittenPosition) {
                        if (this.socketDisconnected) {
                            // MONITOREXIT @DISABLED, blocks:[16, 0, 6, 12, 15] lbl7 : MonitorExitStatement: MONITOREXIT : var3_5
                            try {
                                if (this.socketInputStream != null) {
                                    this.socketInputStream.close();
                                }
                                if (this.socketOutputStream != null) {
                                    this.socketOutputStream.close();
                                }
                                if (this.socket == null) ** break;
                                this.socket.close();
                            }
                            catch (IOException ioexception) {
                                ioexception.printStackTrace();
                            }
                            ** break;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedexception) {
                            interruptedexception.printStackTrace();
                        }
                    }
                    dataSize = this.queuedDataPosition >= this.dataWrittenPosition ? this.queuedDataPosition - this.dataWrittenPosition : -this.dataWrittenPosition + 5000;
                    offset = this.dataWrittenPosition;
                    if (dataSize <= 0) continue;
                }
                try {
                    this.socketOutputStream.write(this.queuedData, offset, dataSize);
                }
                catch (IOException ioexception) {
                    this.socketError = true;
                }
                this.dataWrittenPosition = (dataSize + this.dataWrittenPosition) % 5000;
                try {
                    if (this.dataWrittenPosition != this.queuedDataPosition) ** GOTO lbl-1000
                    this.socketOutputStream.flush();
                }
                catch (IOException ioexception) {
                    ioexception.printStackTrace();
                    this.socketError = true;
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
lbl42:
            // 3 sources

            this.queuedData = null;
            return;
        }
        catch (Exception exception) {
            MovedStatics.printException(null, exception);
        }
    }

    public int inputStreamAvailable() throws IOException {
        if (this.socketDisconnected) {
            return 0;
        }
        return this.socketInputStream.available();
    }

    public int read() throws IOException {
        if (this.socketDisconnected) {
            return 0;
        }
        return this.socketInputStream.read();
    }
}

