/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import org.runejs.Configuration;
import org.runejs.client.Game;
import org.runejs.client.GameErrorHandler;
import org.runejs.client.MovedStatics;
import org.runejs.client.RSCanvas;
import org.runejs.client.frame.ScreenController;
import org.runejs.client.frame.ScreenMode;
import org.runejs.client.renderer.SoftwareRenderer;
import org.runejs.client.util.Signlink;
import org.runejs.client.util.Timer;

public class GameShell
extends Canvas
implements GameErrorHandler,
Runnable,
FocusListener,
WindowListener {
    public static long[] tickSamples = new long[32];
    public static long exitTimeInMillis = 0L;
    public static Frame clientFrame;
    public static GameShell currentGameShell;
    public static int fps;
    public static boolean closedClient;
    public static int currentTickSample;
    public static int anInt2024;
    public static int cyclesSinceReset;
    private static volatile boolean clientFocused;
    private final int millisPerTick = 20;
    public boolean gameShellError = false;
    private Game game;

    public GameShell(Game game) {
        this.game = game;
    }

    public static void main(String[] args) {
        Game game = new Game(args);
        GameShell shell = new GameShell(game);
        game.setErrorHandler(shell);
        try {
            shell.openClientApplet("client435", 13, 32 + Game.modewhat, InetAddress.getByName(Configuration.SERVER_ADDRESS), 435);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Method method;
        if (Signlink.javaVendor != null) {
            String string = Signlink.javaVendor.toLowerCase();
            if (!string.contains("sun") && !string.contains("apple")) {
                if (string.contains("ibm") && (Signlink.javaVersion == null || Signlink.javaVersion.equals("1.4.2"))) {
                    this.openErrorPage("wrongjava");
                    return;
                }
            } else {
                String string_0_ = Signlink.javaVersion;
                if (string_0_.equals("1.1") || string_0_.startsWith("1.1.") || string_0_.equals("1.2") || string_0_.startsWith("1.2.")) {
                    this.openErrorPage("wrongjava");
                    return;
                }
                anInt2024 = 5;
            }
        }
        if (Game.signlink.gameShell != null && (method = Signlink.setFocusCycleRoot) != null) {
            try {
                method.invoke((Object)Game.signlink.gameShell, Boolean.TRUE);
            }
            catch (Throwable string_0_) {
                // empty catch block
            }
        }
        this.setCanvas();
        MovedStatics.aProducingGraphicsBuffer_2213 = MovedStatics.createGraphicsBuffer(MovedStatics.width, MovedStatics.height, Game.gameCanvas);
        this.game.startup();
        Game.gameTimer = Timer.create();
        Game.gameTimer.start();
        while (exitTimeInMillis == 0L || System.currentTimeMillis() < exitTimeInMillis) {
            MovedStatics.ticksPerLoop = Game.gameTimer.getTicks(20, anInt2024);
            for (int currentTick = 0; currentTick < MovedStatics.ticksPerLoop; ++currentTick) {
                long currentTimeMillis;
                MovedStatics.tickSamples[MovedStatics.currentTickSample] = currentTimeMillis = System.currentTimeMillis();
                MovedStatics.currentTickSample = 0x1F & MovedStatics.currentTickSample + 1;
                GameShell gameShell = this;
                synchronized (gameShell) {
                    Game.isClientFocused = clientFocused;
                }
                this.game.processGameLoop();
            }
            this.runAfterGameLoop();
        }
        this.closeGameShell();
    }

    public synchronized void closeGameShell() {
        if (!closedClient) {
            closedClient = true;
            try {
                Game.gameCanvas.removeFocusListener(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.game.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clientFrame != null) {
                try {
                    System.exit(0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (Game.signlink != null) {
                try {
                    Game.signlink.killSignlinkThread();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public void openErrorPage(String gameError) {
        if (!this.gameShellError) {
            this.gameShellError = true;
            System.out.println("error_game_" + gameError);
        }
    }

    public void start() {
        if (this == currentGameShell && !closedClient) {
            exitTimeInMillis = 0L;
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        clientFocused = false;
    }

    @Override
    public synchronized void paint(Graphics arg0) {
        if (this == currentGameShell && !closedClient) {
            MovedStatics.clearScreen = true;
            if (Signlink.javaVersion == null || !Signlink.javaVersion.startsWith("1.5") || -MovedStatics.aLong174 + System.currentTimeMillis() <= 1000L) {
                return;
            }
            Rectangle rectangle = arg0.getClipBounds();
            if (rectangle == null || rectangle.width >= MovedStatics.width && rectangle.height >= MovedStatics.height) {
                MovedStatics.aBoolean1575 = true;
            }
        }
    }

    public void destroy() {
        if (currentGameShell == this && !closedClient) {
            exitTimeInMillis = System.currentTimeMillis();
            MovedStatics.threadSleep(5000L);
            MovedStatics.signlink = null;
            this.closeGameShell();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        clientFocused = true;
        MovedStatics.clearScreen = true;
    }

    public URL getDocumentBase() {
        try {
            return new URL("http://" + Configuration.SERVER_ADDRESS + ":" + Configuration.HTTP_PORT);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    public void runAfterGameLoop() {
        long currentTimeMillis = System.currentTimeMillis();
        long lastTickInMillis = tickSamples[currentTickSample];
        GameShell.tickSamples[GameShell.currentTickSample] = currentTimeMillis;
        if (lastTickInMillis != 0L && currentTimeMillis > lastTickInMillis) {
            int i = (int)(currentTimeMillis - lastTickInMillis);
            int maxSamples = tickSamples.length;
            fps = ((i >> 1) + maxSamples * 1000) / i;
        }
        currentTickSample = currentTickSample + 1 & 0x1F;
        if (cyclesSinceReset++ > 50) {
            cyclesSinceReset -= 50;
            MovedStatics.clearScreen = true;
            Game.gameCanvas.setSize(MovedStatics.width, MovedStatics.height);
            Game.gameCanvas.setVisible(true);
            Game.gameCanvas.setBackground(Color.BLACK);
            if (clientFrame == null) {
                Game.gameCanvas.setLocation(0, 0);
            } else {
                Insets insets = clientFrame.getInsets();
                Game.gameCanvas.setLocation(insets.left, insets.top);
            }
        }
        if (MovedStatics.aBoolean1575) {
            this.setCanvas();
        }
        this.game.draw();
    }

    public void openClientApplet(String cacheFolder, int cacheIndexes, int fileStoreId, InetAddress inetAddress, int clientVersion) {
        try {
            int height = 503;
            int width = 765;
            Game.clientVersion = clientVersion;
            MovedStatics.width = width;
            MovedStatics.height = height;
            currentGameShell = this;
            clientFrame = new Frame();
            clientFrame.setTitle(Configuration.SERVER_DISPLAY_NAME);
            ScreenController.frameMode(ScreenMode.FIXED);
            clientFrame.setPreferredSize(new Dimension(width, height));
            clientFrame.setResizable(ScreenController.frameMode == ScreenMode.RESIZABLE);
            clientFrame.addWindowListener(this);
            clientFrame.setVisible(true);
            clientFrame.toFront();
            Insets insets = clientFrame.getInsets();
            clientFrame.setSize(insets.right + width + insets.left, insets.bottom + insets.top + height);
            MovedStatics.signlink = Game.signlink = new Signlink(true, null, inetAddress, fileStoreId, cacheFolder, cacheIndexes);
            Game.signlink.putThreadNode(1, this);
        }
        catch (Exception exception) {
            MovedStatics.printException(null, exception);
        }
    }

    public URL getCodeBase() {
        return this.getDocumentBase();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.destroy();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public synchronized void setCanvas() {
        Game.renderer = new SoftwareRenderer();
        Frame container = clientFrame;
        if (Game.gameCanvas != null) {
            Game.gameCanvas.removeFocusListener(this);
            container.remove(Game.gameCanvas);
        }
        Game.gameCanvas = new RSCanvas(this);
        container.add(Game.gameCanvas);
        Game.gameCanvas.setSize(MovedStatics.width, MovedStatics.height);
        Game.gameCanvas.setVisible(true);
        if (clientFrame != null) {
            Insets insets = clientFrame.getInsets();
            Game.gameCanvas.setLocation(insets.left, insets.top);
        } else {
            Game.gameCanvas.setLocation(0, 0);
        }
        Game.gameCanvas.addFocusListener(this);
        Game.gameCanvas.requestFocus();
        MovedStatics.clearScreen = true;
        MovedStatics.aBoolean1575 = false;
        MovedStatics.aLong174 = System.currentTimeMillis();
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void handleGameError(String errorMessage) {
        this.openErrorPage(errorMessage);
    }

    static {
        currentGameShell = null;
        fps = 0;
        closedClient = false;
        anInt2024 = 1;
        cyclesSinceReset = 500;
        clientFocused = true;
    }
}

