/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import org.runejs.client.ActionRowType;
import org.runejs.client.Game;
import org.runejs.client.LinkedList;
import org.runejs.client.MovedStatics;
import org.runejs.client.RSString;
import org.runejs.client.cache.cs.ClientScript;
import org.runejs.client.cache.cs.InvokedScript;
import org.runejs.client.cache.def.ItemDefinition;
import org.runejs.client.cache.def.VarPlayerDefinition;
import org.runejs.client.cache.def.VarbitDefinition;
import org.runejs.client.cache.media.gameInterface.GameInterface;
import org.runejs.client.cache.media.gameInterface.GameInterfaceType;
import org.runejs.client.cache.media.gameInterface.InterfaceModelType;
import org.runejs.client.frame.ChatBox;
import org.runejs.client.io.Buffer;
import org.runejs.client.language.English;
import org.runejs.client.language.Native;
import org.runejs.client.media.renderable.actor.Player;
import org.runejs.client.net.OutgoingPackets;
import org.runejs.client.net.PacketBuffer;
import org.runejs.client.node.Node;
import org.runejs.client.sound.MusicSystem;
import org.runejs.client.sound.SoundSystem;
import org.runejs.client.util.BitUtils;
import org.runejs.client.util.Signlink;
import org.runejs.client.util.SignlinkNode;

public class ClientScriptRunner
extends Node {
    public static String[] scriptStringValues = new String[1000];
    public static int runEnergy = 0;
    public static String[] localStrings;
    public static int[] localInts;
    public static int[] scriptIntValues;
    public static InvokedScript[] invokedScripts;
    public static int invokedScriptIndex;
    public static LinkedList clientScriptRunnerCache;
    public static Calendar aCalendar279;
    public static boolean[] aBooleanArray548;
    public static GameInterface aGameInterface_1887;
    public static int[] anIntArray1847;
    private static String[] aClass1Array2964;
    public int[] opcodes;
    public int[] errorCodes;
    public SignlinkNode[] functionNodes;
    public SignlinkNode[] valueNodes;
    public byte[][][] argumentValues;
    public int scriptCount;
    public int[] values;
    public int scriptId;

    public static String method872(int arg0, int arg1) {
        if (arg0 > arg1) {
            return Integer.toString(arg1);
        }
        return Native.asterisk;
    }

    public static void handleChatNamesRightClick(int arg1) {
        int offset = 0;
        for (int index = 0; index < 100; ++index) {
            String username;
            if (ChatBox.chatMessages[index] == null) continue;
            int chatType = ChatBox.chatTypes[index];
            int i_2_ = 4 + ChatBox.chatboxScroll + -(offset * 14) + 70;
            if (i_2_ < -20) break;
            if (chatType == 0) {
                ++offset;
            }
            if ((username = ChatBox.chatPlayerNames[index]) != null && username.startsWith(Native.whiteCrown)) {
                username = username.substring(5);
            }
            if (username != null && username.startsWith(Native.goldCrown)) {
                username = username.substring(5);
            }
            if ((chatType == 1 || chatType == 2) && (chatType == 1 || ChatBox.publicChatMode == 0 || ChatBox.publicChatMode == 1 && Player.hasFriend(username))) {
                if (arg1 > i_2_ - 14 && arg1 <= i_2_ && !username.equals(Player.localPlayer.playerName)) {
                    if (Game.playerRights >= 1) {
                        MovedStatics.addActionRow(English.reportAbuse, 0, 0, 0, ActionRowType.REPORT_ABUSE.getId(), Native.white + username);
                    }
                    MovedStatics.addActionRow(English.addIgnore, 0, 0, 0, ActionRowType.ADD_IGNORE.getId(), Native.white + username);
                    MovedStatics.addActionRow(English.addFriend, 0, 0, 0, ActionRowType.ADD_FRIEND.getId(), Native.white + username);
                }
                ++offset;
            }
            if ((chatType == 3 || chatType == 7) && ChatBox.splitPrivateChat == 0 && (chatType == 7 || ChatBox.privateChatMode == 0 || ChatBox.privateChatMode == 1 && Player.hasFriend(username))) {
                ++offset;
                if (arg1 > -14 + i_2_ && arg1 <= i_2_) {
                    if (Game.playerRights >= 1) {
                        MovedStatics.addActionRow(English.reportAbuse, 0, 0, 0, ActionRowType.REPORT_ABUSE.getId(), Native.white + username);
                    }
                    MovedStatics.addActionRow(English.addIgnore, 0, 0, 0, ActionRowType.ADD_IGNORE.getId(), Native.white + username);
                    MovedStatics.addActionRow(English.addFriend, 0, 0, 0, ActionRowType.ADD_FRIEND.getId(), Native.white + username);
                }
            }
            if (chatType == 4 && (ChatBox.tradeMode == 0 || ChatBox.tradeMode == 1 && Player.hasFriend(username))) {
                if (arg1 > -14 + i_2_ && arg1 <= i_2_) {
                    MovedStatics.addActionRow(English.acceptTrade, 0, 0, 0, ActionRowType.ACCEPT_TRADE.getId(), Native.white + username);
                }
                ++offset;
            }
            if ((chatType == 5 || chatType == 6) && ChatBox.splitPrivateChat == 0 && ChatBox.privateChatMode < 2) {
                ++offset;
            }
            if (chatType != 8 || ChatBox.tradeMode != 0 && (ChatBox.tradeMode != 1 || !Player.hasFriend(username))) continue;
            if (i_2_ + -14 < arg1 && arg1 <= i_2_) {
                MovedStatics.addActionRow(English.acceptChallenge, 0, 0, 0, ActionRowType.ACCEPT_CHALLENGE.getId(), Native.white + username);
            }
            ++offset;
        }
    }

    public static void parseClientScriptPacket(Signlink signlink, Buffer buffer) {
        ClientScriptRunner clientScriptRunner = new ClientScriptRunner();
        clientScriptRunner.scriptCount = buffer.getUnsignedByte();
        clientScriptRunner.scriptId = buffer.getIntBE();
        clientScriptRunner.opcodes = new int[clientScriptRunner.scriptCount];
        clientScriptRunner.valueNodes = new SignlinkNode[clientScriptRunner.scriptCount];
        clientScriptRunner.values = new int[clientScriptRunner.scriptCount];
        clientScriptRunner.argumentValues = new byte[clientScriptRunner.scriptCount][][];
        clientScriptRunner.functionNodes = new SignlinkNode[clientScriptRunner.scriptCount];
        clientScriptRunner.errorCodes = new int[clientScriptRunner.scriptCount];
        for (int i = 0; i < clientScriptRunner.scriptCount; ++i) {
            try {
                int opcode = buffer.getUnsignedByte();
                if (opcode == 0 || opcode == 1 || opcode == 2) {
                    int val = 0;
                    String typeString = new String(buffer.getRSString().method80());
                    String valName = new String(buffer.getRSString().method80());
                    if (opcode == 1) {
                        val = buffer.getIntBE();
                    }
                    clientScriptRunner.opcodes[i] = opcode;
                    clientScriptRunner.values[i] = val;
                    clientScriptRunner.valueNodes[i] = signlink.putFieldNode(ClientScriptRunner.stringToType(typeString), valName);
                    continue;
                }
                if (opcode != 3 && opcode != 4) continue;
                String typeString = new String(buffer.getRSString().method80());
                String functionName = new String(buffer.getRSString().method80());
                int argCount = buffer.getUnsignedByte();
                String[] argNames = new String[argCount];
                for (int j = 0; argCount > j; ++j) {
                    argNames[j] = new String(buffer.getRSString().method80());
                }
                byte[][] argValueData = new byte[argCount][];
                if (opcode == 3) {
                    for (int j = 0; j < argCount; ++j) {
                        int argValueLength = buffer.getIntBE();
                        argValueData[j] = new byte[argValueLength];
                        buffer.getBytes(argValueLength, 0, argValueData[j]);
                    }
                }
                clientScriptRunner.opcodes[i] = opcode;
                Class[] argTypes = new Class[argCount];
                for (int j = 0; j < argCount; ++j) {
                    argTypes[j] = ClientScriptRunner.stringToType(argNames[j]);
                }
                clientScriptRunner.functionNodes[i] = signlink.putMethodNode(argTypes, functionName, ClientScriptRunner.stringToType(typeString));
                clientScriptRunner.argumentValues[i] = argValueData;
                continue;
            }
            catch (ClassNotFoundException classnotfoundexception) {
                clientScriptRunner.errorCodes[i] = -1;
                continue;
            }
            catch (SecurityException securityexception) {
                clientScriptRunner.errorCodes[i] = -2;
                continue;
            }
            catch (NullPointerException nullpointerexception) {
                clientScriptRunner.errorCodes[i] = -3;
                continue;
            }
            catch (Exception exception) {
                clientScriptRunner.errorCodes[i] = -4;
                continue;
            }
            catch (Throwable throwable) {
                clientScriptRunner.errorCodes[i] = -5;
            }
        }
        clientScriptRunnerCache.addLast(clientScriptRunner);
    }

    public static void createClientScriptCheckPacket(int packetId, PacketBuffer buffer) {
        ClientScriptRunner clientScriptRunner;
        while ((clientScriptRunner = (ClientScriptRunner)clientScriptRunnerCache.peekFirst()) != null) {
            boolean bool = false;
            for (int i = 0; clientScriptRunner.scriptCount > i; ++i) {
                if (clientScriptRunner.valueNodes[i] != null) {
                    if (clientScriptRunner.valueNodes[i].status == SignlinkNode.Status.ERRORED) {
                        clientScriptRunner.errorCodes[i] = -5;
                    }
                    if (clientScriptRunner.valueNodes[i].status == SignlinkNode.Status.NOT_INITIALIZED) {
                        bool = true;
                    }
                }
                if (clientScriptRunner.functionNodes[i] == null) continue;
                if (clientScriptRunner.functionNodes[i].status == SignlinkNode.Status.ERRORED) {
                    clientScriptRunner.errorCodes[i] = -6;
                }
                if (clientScriptRunner.functionNodes[i].status != SignlinkNode.Status.NOT_INITIALIZED) continue;
                bool = true;
            }
            if (bool) break;
            buffer.putPacket(packetId);
            buffer.putByte(0);
            int bufferPos = buffer.currentPosition;
            buffer.putIntBE(clientScriptRunner.scriptId);
            for (int i = 0; clientScriptRunner.scriptCount > i; ++i) {
                if (clientScriptRunner.errorCodes[i] == 0) {
                    try {
                        Method method;
                        Field field;
                        int opcode = clientScriptRunner.opcodes[i];
                        if (opcode == 0) {
                            field = (Field)clientScriptRunner.valueNodes[i].value;
                            int fieldValue = field.getInt(null);
                            buffer.putByte(0);
                            buffer.putIntBE(fieldValue);
                            continue;
                        }
                        if (opcode == 1) {
                            field = (Field)clientScriptRunner.valueNodes[i].value;
                            field.setInt(null, clientScriptRunner.values[i]);
                            buffer.putByte(0);
                            continue;
                        }
                        if (opcode == 2) {
                            field = (Field)clientScriptRunner.valueNodes[i].value;
                            int fieldModifiers = field.getModifiers();
                            buffer.putByte(0);
                            buffer.putIntBE(fieldModifiers);
                            continue;
                        }
                        if (opcode == 3) {
                            method = (Method)clientScriptRunner.functionNodes[i].value;
                            byte[][] argumentValueData = clientScriptRunner.argumentValues[i];
                            Object[] objects = new Object[argumentValueData.length];
                            for (int valueIndex = 0; argumentValueData.length > valueIndex; ++valueIndex) {
                                ObjectInputStream objectinputstream = new ObjectInputStream(new ByteArrayInputStream(argumentValueData[valueIndex]));
                                objects[valueIndex] = objectinputstream.readObject();
                            }
                            Object object = method.invoke(null, objects);
                            if (object == null) {
                                buffer.putByte(0);
                                continue;
                            }
                            if (object instanceof Number) {
                                buffer.putByte(1);
                                buffer.putLongBE(((Number)object).longValue());
                                continue;
                            }
                            if (object instanceof RSString) {
                                buffer.putByte(2);
                                buffer.method505((RSString)object);
                                continue;
                            }
                            buffer.putByte(4);
                            continue;
                        }
                        if (opcode != 4) continue;
                        method = (Method)clientScriptRunner.functionNodes[i].value;
                        int methodModifiers = method.getModifiers();
                        buffer.putByte(0);
                        buffer.putIntBE(methodModifiers);
                    }
                    catch (ClassNotFoundException classnotfoundexception) {
                        buffer.putByte(-10);
                    }
                    catch (InvalidClassException invalidclassexception) {
                        buffer.putByte(-11);
                    }
                    catch (StreamCorruptedException streamcorruptedexception) {
                        buffer.putByte(-12);
                    }
                    catch (OptionalDataException optionaldataexception) {
                        buffer.putByte(-13);
                    }
                    catch (IllegalAccessException illegalaccessexception) {
                        buffer.putByte(-14);
                    }
                    catch (IllegalArgumentException illegalargumentexception) {
                        buffer.putByte(-15);
                    }
                    catch (InvocationTargetException invocationtargetexception) {
                        buffer.putByte(-16);
                    }
                    catch (SecurityException securityexception) {
                        buffer.putByte(-17);
                    }
                    catch (IOException ioexception) {
                        buffer.putByte(-18);
                    }
                    catch (NullPointerException nullpointerexception) {
                        buffer.putByte(-19);
                    }
                    catch (Exception exception) {
                        buffer.putByte(-20);
                    }
                    catch (Throwable throwable) {
                        buffer.putByte(-21);
                    }
                    continue;
                }
                buffer.putByte(clientScriptRunner.errorCodes[i]);
            }
            buffer.putCrc8(bufferPos);
            buffer.finishVarByte(-bufferPos + buffer.currentPosition);
            clientScriptRunner.unlink();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void runClientScripts(Object[] listeners, int arg1, int arg2, GameInterface gameInterface1, int arg4) {
        ClientScript clientScript = ClientScript.decodeClientScript((Integer)listeners[0], 76);
        int[] intOperands = clientScript.intOperands;
        int[] scriptOpcodes = clientScript.opcodes;
        int intValueIndex = 0;
        int stringValueIndex = 0;
        int scriptIndex = -1;
        try {
            localInts = new int[clientScript.localIntCount];
            localStrings = new String[clientScript.localStringCount];
            int localIntIndex = 0;
            int localStringIndex = 0;
            for (int listenerIndex = 1; listenerIndex < listeners.length; ++listenerIndex) {
                if (listeners[listenerIndex] instanceof Integer) {
                    int intValue = (Integer)listeners[listenerIndex];
                    if (intValue == -2147483647) {
                        intValue = arg4;
                    }
                    if (intValue == -2147483646) {
                        intValue = arg2;
                    }
                    if (intValue == -2147483645) {
                        intValue = gameInterface1.id;
                    }
                    if (intValue == -2147483644) {
                        intValue = arg1;
                    }
                    ClientScriptRunner.localInts[localIntIndex++] = intValue;
                    continue;
                }
                if (!(listeners[listenerIndex] instanceof String)) continue;
                ClientScriptRunner.localStrings[localStringIndex++] = (String)listeners[listenerIndex];
            }
            while (true) {
                GameInterface gameInterface;
                boolean bool;
                int scriptOpcode;
                if ((scriptOpcode = scriptOpcodes[++scriptIndex]) < 100) {
                    int operand;
                    if (scriptOpcode == 0) {
                        ClientScriptRunner.scriptIntValues[intValueIndex++] = intOperands[scriptIndex];
                        continue;
                    }
                    if (scriptOpcode == 1) {
                        operand = intOperands[scriptIndex];
                        ClientScriptRunner.scriptIntValues[intValueIndex++] = VarPlayerDefinition.varPlayers[operand];
                        continue;
                    }
                    if (scriptOpcode == 2) {
                        operand = intOperands[scriptIndex];
                        VarPlayerDefinition.varPlayers[operand] = scriptIntValues[--intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 3) {
                        ClientScriptRunner.scriptStringValues[stringValueIndex++] = clientScript.stringOperands[scriptIndex];
                        continue;
                    }
                    if (scriptOpcode == 6) {
                        scriptIndex += intOperands[scriptIndex];
                        continue;
                    }
                    if (scriptOpcode == 7) {
                        if (scriptIntValues[intValueIndex -= 2] == scriptIntValues[1 + intValueIndex]) continue;
                        scriptIndex += intOperands[scriptIndex];
                        continue;
                    }
                    if (scriptOpcode == 8) {
                        if (scriptIntValues[intValueIndex -= 2] != scriptIntValues[1 + intValueIndex]) continue;
                        scriptIndex += intOperands[scriptIndex];
                        continue;
                    }
                    if (scriptOpcode == 9) {
                        if (scriptIntValues[1 + (intValueIndex -= 2)] <= scriptIntValues[intValueIndex]) continue;
                        scriptIndex += intOperands[scriptIndex];
                        continue;
                    }
                    if (scriptOpcode == 10) {
                        if (scriptIntValues[1 + (intValueIndex -= 2)] >= scriptIntValues[intValueIndex]) continue;
                        scriptIndex += intOperands[scriptIndex];
                        continue;
                    }
                    if (scriptOpcode == 21) {
                        if (invokedScriptIndex == 0) return;
                        InvokedScript invokedScript = invokedScripts[--invokedScriptIndex];
                        localStrings = invokedScript.localStrings;
                        localInts = invokedScript.localInts;
                        scriptIndex = invokedScript.scriptIndex;
                        clientScript = invokedScript.script;
                        intOperands = clientScript.intOperands;
                        scriptOpcodes = clientScript.opcodes;
                        continue;
                    }
                    if (scriptOpcode == 25) {
                        operand = intOperands[scriptIndex];
                        ClientScriptRunner.scriptIntValues[intValueIndex++] = VarbitDefinition.getVarbitValue(operand);
                        continue;
                    }
                    if (scriptOpcode == 27) {
                        operand = intOperands[scriptIndex];
                        VarbitDefinition.setVarbitValue(scriptIntValues[--intValueIndex], operand);
                        continue;
                    }
                    if (scriptOpcode == 31) {
                        if (scriptIntValues[intValueIndex -= 2] > scriptIntValues[intValueIndex + 1]) continue;
                        scriptIndex += intOperands[scriptIndex];
                        continue;
                    }
                    if (scriptOpcode == 32) {
                        if (scriptIntValues[1 + (intValueIndex -= 2)] > scriptIntValues[intValueIndex]) continue;
                        scriptIndex += intOperands[scriptIndex];
                        continue;
                    }
                    if (scriptOpcode == 33) {
                        ClientScriptRunner.scriptIntValues[intValueIndex++] = localInts[intOperands[scriptIndex]];
                        continue;
                    }
                    if (scriptOpcode == 34) {
                        ClientScriptRunner.localInts[intOperands[scriptIndex]] = scriptIntValues[--intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 35) {
                        ClientScriptRunner.scriptStringValues[stringValueIndex++] = localStrings[intOperands[scriptIndex]];
                        continue;
                    }
                    if (scriptOpcode == 36) {
                        ClientScriptRunner.localStrings[intOperands[scriptIndex]] = scriptStringValues[--stringValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 37) {
                        operand = intOperands[scriptIndex];
                        stringValueIndex -= operand;
                        System.out.println("THIS DOES SOMETHING, GO FIX!");
                        continue;
                    }
                    if (scriptOpcode == 38) {
                        --intValueIndex;
                        continue;
                    }
                    if (scriptOpcode == 39) {
                        --stringValueIndex;
                        continue;
                    }
                    if (scriptOpcode == 40) {
                        operand = intOperands[scriptIndex];
                        ClientScript invokeScript = ClientScript.decodeClientScript(operand, 73);
                        int[] invokeScriptInts = new int[invokeScript.localIntCount];
                        String[] invokeScriptStrings = new String[invokeScript.localStringCount];
                        for (int intIndex = 0; invokeScript.intStackCount > intIndex; ++intIndex) {
                            invokeScriptInts[intIndex] = scriptIntValues[intValueIndex - (invokeScript.intStackCount + -intIndex)];
                        }
                        for (int strIndex = 0; invokeScript.stringStackCount > strIndex; ++strIndex) {
                            invokeScriptStrings[strIndex] = scriptStringValues[stringValueIndex - invokeScript.stringStackCount + strIndex];
                        }
                        stringValueIndex -= invokeScript.stringStackCount;
                        intValueIndex -= invokeScript.intStackCount;
                        InvokedScript invokedScript = new InvokedScript();
                        invokedScript.localStrings = localStrings;
                        invokedScript.script = clientScript;
                        invokedScript.localInts = localInts;
                        clientScript = invokeScript;
                        invokedScript.scriptIndex = scriptIndex;
                        ClientScriptRunner.invokedScripts[ClientScriptRunner.invokedScriptIndex++] = invokedScript;
                        intOperands = clientScript.intOperands;
                        localStrings = invokeScriptStrings;
                        scriptIndex = -1;
                        localInts = invokeScriptInts;
                        scriptOpcodes = clientScript.opcodes;
                        continue;
                    }
                    if (scriptOpcode == 42) {
                        ClientScriptRunner.scriptIntValues[intValueIndex++] = anIntArray1847[intOperands[scriptIndex]];
                        continue;
                    }
                    if (scriptOpcode == 43) {
                        ClientScriptRunner.anIntArray1847[intOperands[scriptIndex]] = scriptIntValues[--intValueIndex];
                        continue;
                    }
                }
                boolean bl = bool = intOperands[scriptIndex] == 1;
                if (scriptOpcode < 1000) {
                    if (scriptOpcode == 100) {
                        int interfaceData = scriptIntValues[intValueIndex -= 3];
                        int interfaceType = scriptIntValues[intValueIndex + 1];
                        int childCount = scriptIntValues[intValueIndex + 2];
                        GameInterface gameInterface2 = GameInterface.getInterface(interfaceData);
                        if (gameInterface2.children == null) {
                            gameInterface2.children = new GameInterface[1 + childCount];
                        }
                        if (gameInterface2.children.length <= childCount) {
                            GameInterface[] childInterfaces = new GameInterface[1 + childCount];
                            for (int childId = 0; gameInterface2.children.length > childId; ++childId) {
                                childInterfaces[childId] = gameInterface2.children[childId];
                            }
                            gameInterface2.children = childInterfaces;
                        }
                        GameInterface childInterface = new GameInterface();
                        childInterface.parentId = gameInterface2.id;
                        childInterface.type = GameInterfaceType.get(interfaceType);
                        childInterface.id = ((0xFFFF & gameInterface2.id) << 15) + Integer.MIN_VALUE + childCount;
                        gameInterface2.children[childCount] = childInterface;
                        if (bool) {
                            MovedStatics.aGameInterface_2116 = childInterface;
                            continue;
                        }
                        aGameInterface_1887 = childInterface;
                        continue;
                    }
                    if (scriptOpcode == 101) {
                        GameInterface gameInterface3 = !bool ? aGameInterface_1887 : MovedStatics.aGameInterface_2116;
                        GameInterface childInterface = GameInterface.getInterface(gameInterface3.parentId);
                        childInterface.children[BitUtils.bitWiseAND((int)gameInterface3.id, (int)Short.MAX_VALUE)] = null;
                        continue;
                    }
                    if (scriptOpcode != 102) return;
                    GameInterface gameInterface4 = GameInterface.getInterface(scriptIntValues[--intValueIndex]);
                    gameInterface4.children = null;
                    continue;
                }
                if (scriptOpcode >= 1000 && scriptOpcode < 1100 || scriptOpcode >= 2000 && scriptOpcode < 2100) {
                    GameInterface gameInterface5;
                    if (scriptOpcode >= 2000) {
                        gameInterface5 = GameInterface.getInterface(scriptIntValues[--intValueIndex]);
                        scriptOpcode -= 1000;
                    } else {
                        GameInterface gameInterface6 = gameInterface5 = bool ? MovedStatics.aGameInterface_2116 : aGameInterface_1887;
                    }
                    if (scriptOpcode == 1000) {
                        gameInterface5.currentX = scriptIntValues[intValueIndex -= 2];
                        gameInterface5.currentY = scriptIntValues[intValueIndex + 1];
                        continue;
                    }
                    if (scriptOpcode == 1001) {
                        gameInterface5.originalWidth = scriptIntValues[intValueIndex -= 2];
                        gameInterface5.originalHeight = scriptIntValues[1 + intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1003) {
                        gameInterface5.isHidden = scriptIntValues[--intValueIndex] == 1;
                        continue;
                    }
                    if (scriptOpcode != 1004) return;
                    gameInterface5.hasListeners = scriptIntValues[--intValueIndex] == 1;
                    continue;
                }
                if (scriptOpcode >= 1100 && scriptOpcode < 1200 || scriptOpcode >= 2100 && scriptOpcode < 2200) {
                    GameInterface gameInterface7;
                    if (scriptOpcode < 2000) {
                        gameInterface7 = !bool ? aGameInterface_1887 : MovedStatics.aGameInterface_2116;
                    } else {
                        gameInterface7 = GameInterface.getInterface(scriptIntValues[--intValueIndex]);
                        scriptOpcode -= 1000;
                    }
                    if (scriptOpcode == 1100) {
                        gameInterface7.scrollWidth = scriptIntValues[intValueIndex -= 2];
                        gameInterface7.scrollDepth = scriptIntValues[1 + intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1101) {
                        int i_24_ = scriptIntValues[--intValueIndex];
                        int i_25_ = (0x7E0B & i_24_) >> 10;
                        int i_26_ = i_24_ & 0x1F;
                        int i_27_ = i_24_ >> 5 & 0x1F;
                        gameInterface7.textColor = (i_27_ << 11) + (i_25_ << 19) + (i_26_ << 3);
                        continue;
                    }
                    if (scriptOpcode == 1102) {
                        gameInterface7.filled = scriptIntValues[--intValueIndex] == 1;
                        continue;
                    }
                    if (scriptOpcode == 1103) {
                        gameInterface7.opacity = scriptIntValues[--intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1104) {
                        --intValueIndex;
                        continue;
                    }
                    if (scriptOpcode == 1105) {
                        gameInterface7.spriteId = scriptIntValues[--intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1106) {
                        gameInterface7.textureId = scriptIntValues[--intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1107) {
                        gameInterface7.tiled = scriptIntValues[--intValueIndex] == 1;
                        continue;
                    }
                    if (scriptOpcode == 1108) {
                        gameInterface7.modelType = InterfaceModelType.MODEL;
                        gameInterface7.modelId = scriptIntValues[--intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1109) {
                        gameInterface7.offsetX2d = scriptIntValues[intValueIndex -= 6];
                        gameInterface7.offsetY2d = scriptIntValues[1 + intValueIndex];
                        gameInterface7.rotationX = scriptIntValues[intValueIndex + 2];
                        gameInterface7.rotationZ = scriptIntValues[3 + intValueIndex];
                        gameInterface7.rotationY = scriptIntValues[4 + intValueIndex];
                        gameInterface7.modelZoom = scriptIntValues[5 + intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1110) {
                        gameInterface7.animation = scriptIntValues[--intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1111) {
                        gameInterface7.orthogonal = scriptIntValues[--intValueIndex] == 1;
                        continue;
                    }
                    if (scriptOpcode == 1112) {
                        gameInterface7.disabledText = scriptStringValues[--stringValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1113) {
                        gameInterface7.fontId = scriptIntValues[--intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1114) {
                        gameInterface7.xTextAlignment = scriptIntValues[intValueIndex -= 3];
                        gameInterface7.yTextAlignment = scriptIntValues[intValueIndex + 1];
                        gameInterface7.lineHeight = scriptIntValues[intValueIndex + 2];
                        continue;
                    }
                    if (scriptOpcode != 1115) return;
                    gameInterface7.textShadowed = scriptIntValues[--intValueIndex] == 1;
                    continue;
                }
                if (!(scriptOpcode >= 1200 && scriptOpcode < 1300 || scriptOpcode >= 2200 && scriptOpcode < 2300)) {
                    GameInterface gameInterface8;
                    if (!(scriptOpcode >= 1300 && scriptOpcode < 1400 || scriptOpcode >= 2300 && scriptOpcode < 2400)) {
                        GameInterface gameInterface9;
                        if (scriptOpcode < 1500) {
                            if (scriptOpcode == 1400) {
                                int i_28_ = scriptIntValues[(intValueIndex -= 2) + 1];
                                int i_29_ = scriptIntValues[intValueIndex];
                                GameInterface gameInterface10 = GameInterface.getInterface(i_29_);
                                if (gameInterface10.children == null || gameInterface10.children.length <= i_28_ || gameInterface10.children[i_28_] == null) {
                                    ClientScriptRunner.scriptIntValues[intValueIndex++] = 0;
                                    continue;
                                }
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = 1;
                                if (bool) {
                                    MovedStatics.aGameInterface_2116 = gameInterface10.children[i_28_];
                                    continue;
                                }
                                aGameInterface_1887 = gameInterface10.children[i_28_];
                                continue;
                            }
                            if (scriptOpcode == 1401) {
                                int i_32_;
                                int i_31_;
                                GameInterface gameInterface11;
                                int i_30_ = scriptIntValues[intValueIndex -= 3];
                                if ((gameInterface11 = GameInterface.method361(GameInterface.cachedInterfaces[i_30_], i_31_ = scriptIntValues[2 + intValueIndex], true, 0, -1, 0, i_32_ = scriptIntValues[intValueIndex + 1], 398)) == null) {
                                    ClientScriptRunner.scriptIntValues[intValueIndex++] = 0;
                                    continue;
                                }
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = 1;
                                if (bool) {
                                    MovedStatics.aGameInterface_2116 = gameInterface11;
                                    continue;
                                }
                                aGameInterface_1887 = gameInterface11;
                                continue;
                            }
                            if (scriptOpcode != 1402) return;
                            GameInterface gameInterface12 = GameInterface.getInterface(scriptIntValues[intValueIndex -= 3]);
                            int i_33_ = scriptIntValues[2 + intValueIndex];
                            int i_34_ = scriptIntValues[intValueIndex + 1];
                            GameInterface gameInterface_35_ = GameInterface.method361(gameInterface12.children, i_33_, true, gameInterface12.scrollDepth, gameInterface12.id, gameInterface12.scrollWidth, i_34_, 398);
                            if (gameInterface_35_ == null) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = 0;
                                continue;
                            }
                            ClientScriptRunner.scriptIntValues[intValueIndex++] = 1;
                            if (bool) {
                                MovedStatics.aGameInterface_2116 = gameInterface_35_;
                                continue;
                            }
                            aGameInterface_1887 = gameInterface_35_;
                            continue;
                        }
                        if (scriptOpcode < 1600) {
                            GameInterface gameInterface13;
                            GameInterface gameInterface14 = gameInterface13 = bool ? MovedStatics.aGameInterface_2116 : aGameInterface_1887;
                            if (scriptOpcode == 1500) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface13.currentX;
                                continue;
                            }
                            if (scriptOpcode == 1501) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface13.currentY;
                                continue;
                            }
                            if (scriptOpcode == 1502) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface13.originalWidth;
                                continue;
                            }
                            if (scriptOpcode == 1503) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface13.originalHeight;
                                continue;
                            }
                            if (scriptOpcode == 1504) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = !gameInterface13.isHidden ? 0 : 1;
                                continue;
                            }
                            if (scriptOpcode != 1505) return;
                            ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface13.parentId;
                            continue;
                        }
                        if (scriptOpcode >= 1700) {
                            if (scriptOpcode < 2500) {
                                if (scriptOpcode == 2401) {
                                    int i_36_;
                                    int i_38_;
                                    GameInterface gameInterface15;
                                    int i_37_ = scriptIntValues[intValueIndex -= 3];
                                    if ((gameInterface15 = GameInterface.method361(GameInterface.cachedInterfaces[i_37_], i_38_ = scriptIntValues[intValueIndex + 2], false, 0, -1, 0, i_36_ = scriptIntValues[1 + intValueIndex], 398)) == null) {
                                        ClientScriptRunner.scriptIntValues[intValueIndex++] = -1;
                                        continue;
                                    }
                                    ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface15.id;
                                    continue;
                                }
                                if (scriptOpcode != 2402) return;
                                GameInterface gameInterface16 = GameInterface.getInterface(scriptIntValues[intValueIndex -= 3]);
                                int i_40_ = scriptIntValues[intValueIndex + 2];
                                int i_39_ = scriptIntValues[1 + intValueIndex];
                                GameInterface gameInterface_41_ = GameInterface.method361(GameInterface.cachedInterfaces[gameInterface16.id >> 16], i_40_, false, gameInterface16.scrollDepth, 0xFFFF & gameInterface16.id, gameInterface16.scrollWidth, i_39_, 398);
                                if (gameInterface_41_ == null) {
                                    ClientScriptRunner.scriptIntValues[intValueIndex++] = -1;
                                    continue;
                                }
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface_41_.id;
                                continue;
                            }
                            if (scriptOpcode >= 2600) {
                                if (scriptOpcode < 2700) {
                                    GameInterface gameInterface17 = GameInterface.getInterface(scriptIntValues[--intValueIndex]);
                                    if (scriptOpcode == 2600) {
                                        ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface17.scrollWidth;
                                        continue;
                                    }
                                    if (scriptOpcode != 2601) return;
                                    ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface17.scrollDepth;
                                    continue;
                                }
                                if (scriptOpcode < 2800) return;
                                if (scriptOpcode < 3100) {
                                    if (scriptOpcode == 3000) {
                                        int i_42_ = scriptIntValues[--intValueIndex];
                                        if (MovedStatics.lastContinueTextWidgetId != -1) continue;
                                        GameInterface.sendPleaseWaitOptionClick(0, i_42_);
                                        MovedStatics.lastContinueTextWidgetId = i_42_;
                                        continue;
                                    }
                                    if (scriptOpcode == 3001 || scriptOpcode == 3003) {
                                        int i_43_ = scriptIntValues[intValueIndex -= 2];
                                        int i_44_ = scriptIntValues[intValueIndex + 1];
                                        ClientScriptRunner.method406(0, i_44_, i_43_);
                                        continue;
                                    }
                                    if (scriptOpcode == 3002) {
                                        GameInterface gameInterface18;
                                        GameInterface gameInterface19 = gameInterface18 = !bool ? aGameInterface_1887 : MovedStatics.aGameInterface_2116;
                                        if (MovedStatics.lastContinueTextWidgetId != -1) continue;
                                        GameInterface.sendPleaseWaitOptionClick(gameInterface18.id & Short.MAX_VALUE, gameInterface18.parentId);
                                        MovedStatics.lastContinueTextWidgetId = gameInterface18.id;
                                        continue;
                                    }
                                    if (scriptOpcode != 3003) return;
                                    GameInterface gameInterface20 = bool ? MovedStatics.aGameInterface_2116 : aGameInterface_1887;
                                    int i_45_ = scriptIntValues[--intValueIndex];
                                    ClientScriptRunner.method406(Short.MAX_VALUE & gameInterface20.id, i_45_, gameInterface20.parentId);
                                    continue;
                                }
                                if (scriptOpcode >= 3200) {
                                    if (scriptOpcode < 3300) {
                                        if (scriptOpcode == 3200) {
                                            SoundSystem.play(scriptIntValues[intValueIndex -= 3], scriptIntValues[intValueIndex + 1], scriptIntValues[2 + intValueIndex]);
                                            continue;
                                        }
                                        if (scriptOpcode == 3201) {
                                            MusicSystem.playSong(scriptIntValues[--intValueIndex]);
                                            continue;
                                        }
                                        if (scriptOpcode != 3202) return;
                                        MusicSystem.playSoundJingle(scriptIntValues[(intValueIndex -= 2) + 1], scriptIntValues[intValueIndex]);
                                        continue;
                                    }
                                    if (scriptOpcode < 3400) {
                                        if (scriptOpcode != 3300) return;
                                        ClientScriptRunner.scriptIntValues[intValueIndex++] = MovedStatics.pulseCycle;
                                        continue;
                                    }
                                    if (scriptOpcode < 4100) {
                                        if (scriptOpcode == 4000) {
                                            int i_46_ = scriptIntValues[intValueIndex -= 2];
                                            int i_47_ = scriptIntValues[intValueIndex + 1];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = i_46_ + i_47_;
                                            continue;
                                        }
                                        if (scriptOpcode == 4001) {
                                            int i_48_ = scriptIntValues[1 + (intValueIndex -= 2)];
                                            int i_49_ = scriptIntValues[intValueIndex];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = i_49_ + -i_48_;
                                            continue;
                                        }
                                        if (scriptOpcode == 4002) {
                                            int i_50_ = scriptIntValues[(intValueIndex -= 2) + 1];
                                            int i_51_ = scriptIntValues[intValueIndex];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = i_51_ * i_50_;
                                            continue;
                                        }
                                        if (scriptOpcode == 4003) {
                                            int i_52_ = scriptIntValues[intValueIndex -= 2];
                                            int i_53_ = scriptIntValues[intValueIndex + 1];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = i_52_ / i_53_;
                                            continue;
                                        }
                                        if (scriptOpcode == 4004) {
                                            int i_54_ = scriptIntValues[--intValueIndex];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = (int)(Math.random() * (double)i_54_);
                                            continue;
                                        }
                                        if (scriptOpcode == 4005) {
                                            int i_55_ = scriptIntValues[--intValueIndex];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = (int)((double)(1 + i_55_) * Math.random());
                                            continue;
                                        }
                                        if (scriptOpcode == 4006) {
                                            int i_56_ = scriptIntValues[1 + (intValueIndex -= 5)];
                                            int i_57_ = scriptIntValues[intValueIndex];
                                            int i_58_ = scriptIntValues[intValueIndex + 3];
                                            int i_59_ = scriptIntValues[intValueIndex + 4];
                                            int i_60_ = scriptIntValues[2 + intValueIndex];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = i_57_ + (i_59_ + -i_60_) * (-i_57_ + i_56_) / (i_58_ - i_60_);
                                            continue;
                                        }
                                        if (scriptOpcode == 4007) {
                                            int i_61_ = scriptIntValues[intValueIndex -= 2];
                                            int i_62_ = scriptIntValues[intValueIndex + 1];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = i_61_ + i_62_ * i_61_ / 100;
                                            continue;
                                        }
                                        if (scriptOpcode == 4008) {
                                            int i_63_ = scriptIntValues[intValueIndex -= 2];
                                            int i_64_ = scriptIntValues[intValueIndex + 1];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = BitUtils.bitWiseOR(1 << i_64_, i_63_);
                                            continue;
                                        }
                                        if (scriptOpcode == 4009) {
                                            int i_65_ = scriptIntValues[intValueIndex -= 2];
                                            int i_66_ = scriptIntValues[1 + intValueIndex];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = BitUtils.bitWiseAND(i_65_, -1 + -(1 << i_66_));
                                            continue;
                                        }
                                        if (scriptOpcode == 4010) {
                                            int i_67_ = scriptIntValues[intValueIndex -= 2];
                                            int i_68_ = scriptIntValues[1 + intValueIndex];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = BitUtils.bitWiseAND(1 << i_68_, i_67_) != 0 ? 1 : 0;
                                            continue;
                                        }
                                        if (scriptOpcode == 4011) {
                                            int i_69_ = scriptIntValues[(intValueIndex -= 2) + 1];
                                            int i_70_ = scriptIntValues[intValueIndex];
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = i_70_ % i_69_;
                                            continue;
                                        }
                                        if (scriptOpcode == 4012) {
                                            int i_71_ = scriptIntValues[intValueIndex -= 2];
                                            int i_72_ = scriptIntValues[intValueIndex + 1];
                                            if (i_71_ == 0) {
                                                ClientScriptRunner.scriptIntValues[intValueIndex++] = 0;
                                                continue;
                                            }
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = (int)Math.pow(i_71_, i_72_);
                                            continue;
                                        }
                                        if (scriptOpcode != 4013) return;
                                        int i_73_ = scriptIntValues[intValueIndex -= 2];
                                        int i_74_ = scriptIntValues[1 + intValueIndex];
                                        if (i_73_ == 0) {
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = 0;
                                            continue;
                                        }
                                        if (i_74_ == 0) {
                                            ClientScriptRunner.scriptIntValues[intValueIndex++] = Integer.MAX_VALUE;
                                            continue;
                                        }
                                        ClientScriptRunner.scriptIntValues[intValueIndex++] = (int)Math.pow(i_73_, 1.0 / (double)i_74_);
                                        continue;
                                    }
                                    if (scriptOpcode >= 4200) return;
                                    if (scriptOpcode == 4100) {
                                        String class1 = scriptStringValues[--stringValueIndex];
                                        int i_75_ = scriptIntValues[--intValueIndex];
                                        ClientScriptRunner.scriptStringValues[stringValueIndex++] = class1 + i_75_;
                                        continue;
                                    }
                                    if (scriptOpcode == 4101) {
                                        String class1 = scriptStringValues[(stringValueIndex -= 2) + 1];
                                        String class1_76_ = scriptStringValues[stringValueIndex];
                                        ClientScriptRunner.scriptStringValues[stringValueIndex++] = class1_76_ + class1;
                                        continue;
                                    }
                                    if (scriptOpcode == 4102) {
                                        String class1 = scriptStringValues[--stringValueIndex];
                                        int i_77_ = scriptIntValues[--intValueIndex];
                                        ClientScriptRunner.scriptStringValues[stringValueIndex++] = class1 + ClientScriptRunner.method1024(true, i_77_);
                                        continue;
                                    }
                                    if (scriptOpcode == 4103) {
                                        String class1 = scriptStringValues[--stringValueIndex];
                                        ClientScriptRunner.scriptStringValues[stringValueIndex++] = class1.toLowerCase();
                                        continue;
                                    }
                                    if (scriptOpcode == 4104) {
                                        int i_78_ = scriptIntValues[--intValueIndex];
                                        long l = 86400000L * ((long)i_78_ + 11745L);
                                        aCalendar279.setTime(new Date(l));
                                        int i_79_ = aCalendar279.get(5);
                                        int i_80_ = aCalendar279.get(2);
                                        int i_81_ = aCalendar279.get(1);
                                        ClientScriptRunner.scriptStringValues[stringValueIndex++] = i_79_ + "-" + aClass1Array2964[i_80_] + "-" + i_81_;
                                        continue;
                                    }
                                    if (scriptOpcode == 4105) {
                                        String class1 = scriptStringValues[stringValueIndex -= 2];
                                        String class1_82_ = scriptStringValues[stringValueIndex + 1];
                                        if (Player.localPlayer.playerAppearance == null || !Player.localPlayer.playerAppearance.isFemale) {
                                            ClientScriptRunner.scriptStringValues[stringValueIndex++] = class1;
                                            continue;
                                        }
                                        ClientScriptRunner.scriptStringValues[stringValueIndex++] = class1_82_;
                                        continue;
                                    }
                                    if (scriptOpcode == 4106) {
                                        int i_83_ = scriptIntValues[--intValueIndex];
                                        ClientScriptRunner.scriptStringValues[stringValueIndex++] = Integer.toString(i_83_).toString();
                                        continue;
                                    }
                                    if (scriptOpcode != 4107) return;
                                    ClientScriptRunner.scriptIntValues[intValueIndex++] = scriptStringValues[stringValueIndex -= 2].compareTo(scriptStringValues[stringValueIndex + 1]);
                                    continue;
                                }
                                if (scriptOpcode == 3100) {
                                    String str = scriptStringValues[--stringValueIndex];
                                    ChatBox.addChatMessage("", str, 0);
                                    continue;
                                }
                                if (scriptOpcode != 3101) return;
                                Player.playAnimation(scriptIntValues[intValueIndex -= 2], scriptIntValues[intValueIndex + 1], Player.localPlayer);
                                continue;
                            }
                            GameInterface gameInterface21 = GameInterface.getInterface(scriptIntValues[--intValueIndex]);
                            if (scriptOpcode == 2500) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface21.currentX;
                                continue;
                            }
                            if (scriptOpcode == 2501) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface21.currentY;
                                continue;
                            }
                            if (scriptOpcode == 2502) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface21.originalWidth;
                                continue;
                            }
                            if (scriptOpcode == 2503) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface21.originalHeight;
                                continue;
                            }
                            if (scriptOpcode == 2504) {
                                ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface21.isHidden ? 1 : 0;
                                continue;
                            }
                            if (scriptOpcode != 2505) return;
                            ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface21.parentId;
                            continue;
                        }
                        GameInterface gameInterface22 = gameInterface9 = bool ? MovedStatics.aGameInterface_2116 : aGameInterface_1887;
                        if (scriptOpcode == 1600) {
                            ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface9.scrollWidth;
                            continue;
                        }
                        if (scriptOpcode != 1601) return;
                        ClientScriptRunner.scriptIntValues[intValueIndex++] = gameInterface9.scrollDepth;
                        continue;
                    }
                    if (scriptOpcode >= 2000) {
                        gameInterface8 = GameInterface.getInterface(scriptIntValues[--intValueIndex]);
                        scriptOpcode -= 1000;
                    } else {
                        GameInterface gameInterface23 = gameInterface8 = !bool ? aGameInterface_1887 : MovedStatics.aGameInterface_2116;
                    }
                    if (scriptOpcode >= 1300 && scriptOpcode <= 1309 || scriptOpcode >= 1314 && scriptOpcode <= 1317) {
                        String class1 = scriptStringValues[--stringValueIndex];
                        Object[] objects = new Object[class1.length() + 1];
                        for (int i_84_ = objects.length - 1; i_84_ >= 1; --i_84_) {
                            objects[i_84_] = class1.charAt(-1 + i_84_) == 's' ? scriptStringValues[--stringValueIndex] : new Integer(scriptIntValues[--intValueIndex]);
                        }
                        objects[0] = new Integer(scriptIntValues[--intValueIndex]);
                        if (scriptOpcode == 1303) {
                            gameInterface8.anObjectArray2707 = objects;
                        }
                        if (scriptOpcode == 1317) {
                            gameInterface8.anObjectArray2680 = objects;
                        }
                        if (scriptOpcode == 1304) {
                            gameInterface8.anObjectArray2658 = objects;
                        }
                        if (scriptOpcode == 1302) {
                            gameInterface8.anObjectArray2644 = objects;
                        }
                        if (scriptOpcode == 1316) {
                            gameInterface8.anObjectArray2747 = objects;
                        }
                        if (scriptOpcode == 1301) {
                            gameInterface8.anObjectArray2681 = objects;
                        }
                        if (scriptOpcode == 1300) {
                            gameInterface8.onLoadListeners = objects;
                        }
                        if (scriptOpcode == 1315) {
                            gameInterface8.anObjectArray2695 = objects;
                        }
                        if (scriptOpcode == 1306) {
                            gameInterface8.anObjectArray2669 = objects;
                        }
                        if (scriptOpcode == 1305) {
                            gameInterface8.anObjectArray2672 = objects;
                        }
                        if (scriptOpcode == 1309) {
                            gameInterface8.anObjectArray2712 = objects;
                        }
                        if (scriptOpcode != 1308) continue;
                        gameInterface8.anObjectArray2650 = objects;
                        continue;
                    }
                    if (scriptOpcode == 1310) {
                        int i_85_;
                        if ((i_85_ = -1 + scriptIntValues[--intValueIndex]) >= 0 && i_85_ <= 9) {
                            if (gameInterface8.aClass1Array2661 == null || gameInterface8.aClass1Array2661.length <= i_85_) {
                                String[] class1s = new String[1 + i_85_];
                                if (gameInterface8.aClass1Array2661 != null) {
                                    for (int i_86_ = 0; gameInterface8.aClass1Array2661.length > i_86_; ++i_86_) {
                                        class1s[i_86_] = gameInterface8.aClass1Array2661[i_86_];
                                    }
                                }
                                gameInterface8.aClass1Array2661 = class1s;
                            }
                            gameInterface8.aClass1Array2661[i_85_] = scriptStringValues[--stringValueIndex];
                            continue;
                        }
                        --stringValueIndex;
                        continue;
                    }
                    if (scriptOpcode == 1311) {
                        gameInterface8.anInt2738 = scriptIntValues[--intValueIndex];
                        continue;
                    }
                    if (scriptOpcode == 1312) {
                        gameInterface8.lockScroll = scriptIntValues[--intValueIndex] == 1;
                        continue;
                    }
                    if (scriptOpcode != 1313) return;
                    --intValueIndex;
                    continue;
                }
                if (scriptOpcode < 2000) {
                    gameInterface = !bool ? aGameInterface_1887 : MovedStatics.aGameInterface_2116;
                } else {
                    gameInterface = GameInterface.getInterface(scriptIntValues[--intValueIndex]);
                    scriptOpcode -= 1000;
                }
                if (scriptOpcode == 1200) {
                    int i_87_ = scriptIntValues[intValueIndex -= 3];
                    int i_88_ = scriptIntValues[intValueIndex + 2];
                    if (i_87_ == -1) {
                        gameInterface.modelType = InterfaceModelType.NULL;
                        continue;
                    }
                    ItemDefinition class40_sub5_sub16 = ItemDefinition.forId(i_87_, 10);
                    gameInterface.modelType = InterfaceModelType.ITEM;
                    gameInterface.rotationX = class40_sub5_sub16.xan2d;
                    gameInterface.rotationY = class40_sub5_sub16.zan2d;
                    gameInterface.modelZoom = 100 * class40_sub5_sub16.zoom2d / i_88_;
                    gameInterface.rotationZ = class40_sub5_sub16.yan2d;
                    gameInterface.offsetY2d = class40_sub5_sub16.yOffset2d;
                    gameInterface.offsetX2d = class40_sub5_sub16.xOffset2d;
                    gameInterface.modelId = i_87_;
                    continue;
                }
                if (scriptOpcode == 1201) {
                    gameInterface.modelType = InterfaceModelType.NPC_CHATHEAD;
                    gameInterface.modelId = scriptIntValues[--intValueIndex];
                    continue;
                }
                if (scriptOpcode == 1202) {
                    gameInterface.modelType = InterfaceModelType.LOCAL_PLAYER_CHATHEAD;
                    gameInterface.modelId = Player.localPlayer.playerAppearance.getHeadModelId();
                    continue;
                }
                if (scriptOpcode != 1203) return;
                GameInterface desiredInterface = !bool ? MovedStatics.aGameInterface_2116 : aGameInterface_1887;
                gameInterface.anInt2738 = desiredInterface.id;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Class stringToType(String typeCode) throws ClassNotFoundException {
        if (typeCode.equals("B")) {
            return Byte.TYPE;
        }
        if (typeCode.equals("I")) {
            return Integer.TYPE;
        }
        if (typeCode.equals("S")) {
            return Short.TYPE;
        }
        if (typeCode.equals("J")) {
            return Long.TYPE;
        }
        if (typeCode.equals("Z")) {
            return Boolean.TYPE;
        }
        if (typeCode.equals("F")) {
            return Float.TYPE;
        }
        if (typeCode.equals("D")) {
            return Double.TYPE;
        }
        if (typeCode.equals("C")) {
            return Character.TYPE;
        }
        return Class.forName(typeCode);
    }

    private static RSString method1024(boolean arg0, int arg2) {
        return RSString.method521(arg0, 10, arg2);
    }

    public static void method406(int arg0, int arg1, int arg2) {
        if (arg1 == 1) {
            OutgoingPackets.buffer.putPacket(111);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
        if (arg1 == 2) {
            OutgoingPackets.buffer.putPacket(9);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
        if (arg1 == 3) {
            OutgoingPackets.buffer.putPacket(193);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
        if (arg1 == 4) {
            OutgoingPackets.buffer.putPacket(53);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
        if (arg1 == 5) {
            OutgoingPackets.buffer.putPacket(94);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
        if (arg1 == 6) {
            OutgoingPackets.buffer.putPacket(213);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
        if (arg1 == 7) {
            OutgoingPackets.buffer.putPacket(46);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
        if (arg1 == 8) {
            OutgoingPackets.buffer.putPacket(130);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
        if (arg1 == 9) {
            OutgoingPackets.buffer.putPacket(157);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
        if (arg1 == 10) {
            OutgoingPackets.buffer.putPacket(84);
            OutgoingPackets.buffer.putIntBE(arg2);
            OutgoingPackets.buffer.putShortBE(arg0);
        }
    }

    public static String method532(GameInterface gameInterface, String arg2) {
        if (arg2.contains(Native.percent)) {
            int i;
            while ((i = arg2.indexOf(Native.percentOne)) != -1) {
                arg2 = arg2.substring(0, i) + ClientScriptRunner.method872(999999999, ClientScript.parseClientScripts(0, gameInterface)) + arg2.substring(2 + i);
            }
            while ((i = arg2.indexOf(Native.percentTwo)) != -1) {
                arg2 = arg2.substring(0, i) + ClientScriptRunner.method872(999999999, ClientScript.parseClientScripts(1, gameInterface)) + arg2.substring(i + 2);
            }
            while ((i = arg2.indexOf(Native.percentThree)) != -1) {
                arg2 = arg2.substring(0, i) + ClientScriptRunner.method872(999999999, ClientScript.parseClientScripts(2, gameInterface)) + arg2.substring(2 + i);
            }
            while ((i = arg2.indexOf(Native.percentFour)) != -1) {
                arg2 = arg2.substring(0, i) + ClientScriptRunner.method872(999999999, ClientScript.parseClientScripts(3, gameInterface)) + arg2.substring(i + 2);
            }
            while ((i = arg2.indexOf(Native.percentFive)) != -1) {
                arg2 = arg2.substring(0, i) + ClientScriptRunner.method872(999999999, ClientScript.parseClientScripts(4, gameInterface)) + arg2.substring(i + 2);
            }
            while ((i = arg2.indexOf(Native.percentDns)) != -1) {
                String str = "";
                if (MovedStatics.aSignlinkNode_394 != null) {
                    str = MovedStatics.method204(MovedStatics.aSignlinkNode_394.integerData);
                    if (MovedStatics.aSignlinkNode_394.value != null) {
                        byte[] is = ((String)MovedStatics.aSignlinkNode_394.value).getBytes(StandardCharsets.ISO_8859_1);
                        str = RSString.method279(is, 0, is.length).toString();
                    }
                }
                arg2 = arg2.substring(0, i) + str + arg2.substring(i + 4);
            }
        }
        return arg2;
    }

    public static void clearClientScriptRunnerCache() {
        clientScriptRunnerCache = new LinkedList();
    }

    static {
        scriptIntValues = new int[1000];
        invokedScripts = new InvokedScript[50];
        invokedScriptIndex = 0;
        clientScriptRunnerCache = new LinkedList();
        aCalendar279 = Calendar.getInstance();
        aBooleanArray548 = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, false, false};
        anIntArray1847 = new int[2000];
        aClass1Array2964 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    }
}

