/*
 * Decompiled with CFR 0.152.
 */
package org.runejs.OldEngine;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.runejs.client.Game;
import org.runejs.client.Landscape;
import org.runejs.client.MovedStatics;
import org.runejs.client.scene.util.CollisionMap;

public class MapDecompressor {
    public static List<Integer> mapIndices = null;
    public static Map<Integer, byte[]> mapBuffer = new HashMap<Integer, byte[]>();

    public static byte[] grabMap(int id) throws IOException {
        if (mapIndices == null) {
            MapDecompressor.loadIndex2();
        }
        if (mapBuffer.get(id) == null) {
            RandomAccessFile raf_cache = new RandomAccessFile("./data/maps/MAP_CACHE.dat", "rw");
            RandomAccessFile raf_index = new RandomAccessFile("./data/maps/MAP_CACHE.idx", "rw");
            int pos = MapDecompressor.getIndexPosition(id);
            if (pos == -1) {
                return null;
            }
            raf_index.seek(pos * 12);
            raf_cache.seek(raf_index.readInt());
            byte[] b = new byte[raf_index.readInt()];
            raf_cache.readFully(b);
            b = MapDecompressor.inflate(b, raf_index.readInt());
            mapBuffer.put(id, b);
            return mapBuffer.get(id);
        }
        return mapBuffer.get(id);
    }

    public static void loadIndex2() throws IOException {
        mapIndices = new ArrayList<Integer>();
        DataInputStream dis = new DataInputStream(new FileInputStream("./data/maps/MAP_CACHE.idx2"));
        for (int i = 0; i < (int)new File("./data/maps/MAP_CACHE.idx2").length() / 2; ++i) {
            mapIndices.add(Integer.valueOf(dis.readShort()));
        }
    }

    public static int getIndexPosition(int id) throws IOException {
        if (mapIndices.contains(id)) {
            for (int i = 0; i < mapIndices.size(); ++i) {
                if (mapIndices.get(i) != id) continue;
                return i;
            }
        }
        return -1;
    }

    public static byte[] inflate(byte[] b, int l) throws IOException {
        byte[] buf = new byte[l];
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        DataInputStream dis = new DataInputStream(new GZIPInputStream(bais));
        dis.readFully(buf, 0, buf.length);
        dis.close();
        return buf;
    }

    public static void objectLoader(String file) {
        try {
            RandomAccessFile in = new RandomAccessFile(file, "r");
            int totalObjects = in.readInt();
            for (int index = 0; index < totalObjects; ++index) {
                short objectId = in.readShort();
                short x = in.readShort();
                short y = in.readShort();
                int objectPlane = in.read();
                int direction = in.read();
                int type = in.read();
                if (objectId == -1) continue;
                MapDecompressor.spawnObject(objectId, x, y, objectPlane, direction, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void spawnObject(int objectId, int x, int y, int z, int rotation, int type) {
        CollisionMap[] groundData = Landscape.currentCollisionMap;
        int localX = x - MovedStatics.baseX;
        int localY = y - MovedStatics.baseY;
        int plane = z;
        if (localX > -1 && localY > -1 && (MovedStatics.tile_flags[1][localY][localX] & 2) == 2) {
            --plane;
        }
        CollisionMap class20 = null;
        if (plane >= 0) {
            class20 = groundData[plane];
        }
        if (localY > 0 && localX > 0 && localY < 103 && localX < 103) {
            Game.currentScene.landscape.addObject(objectId, localX, localY, z, rotation, type, class20);
        }
    }
}

