/*
 * Decompiled with CFR 0.152.
 */
package org.runejs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.runejs.client.RSString;
import org.runejs.client.language.Native;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Configuration {
    static final String clientConfigPath = System.getProperty("user.home") + File.separator + "client-435.conf.yaml";
    public static String SERVER_ADDRESS = "127.0.0.1";
    public static String CACHE_NAME = ".filestore_435";
    public static int GAME_PORT = 43594;
    public static int ONDEMAND_PORT = 43594;
    public static int JAGGRAB_PORT = 43595;
    public static int HTTP_PORT = 80;
    public static boolean JAGGRAB_ENABLED = false;
    public static boolean RSA_ENABLED = true;
    public static BigInteger RSA_PUBLIC_KEY = new BigInteger("65537");
    public static BigInteger RSA_MODULUS = new BigInteger("119568088839203297999728368933573315070738693395974011872885408638642676871679245723887367232256427712869170521351089799352546294030059890127723509653145359924771433131004387212857375068629466435244653901851504845054452735390701003613803443469723435116497545687393297329052988014281948392136928774011011998343");
    public static boolean USE_STATIC_DETAILS = true;
    public static String USERNAME = "a";
    public static String PASSWORD = "aaaaa";
    public static boolean ROOFS_ENABLED = true;
    public static boolean FREE_TELEPORTS = true;
    public static boolean DEBUG_CONTEXT = true;
    public static String SERVER_DISPLAY_NAME = "Magic Rune";
    public static boolean DEBUG_WIDGETS = false;
    private static boolean SOUND_MUTED = true;

    public static void read() {
        File configFile = new File(clientConfigPath);
        try {
            Yaml yaml = new Yaml();
            FileInputStream inputStream = new FileInputStream(configFile);
            Map obj = (Map)yaml.load(inputStream);
            Map net = (Map)obj.get("net");
            Map cache = (Map)obj.get("cache");
            Map rsa = (Map)obj.get("rsa");
            Map login = (Map)obj.get("login");
            Map game = (Map)obj.get("game");
            SERVER_ADDRESS = (String)net.get("address");
            GAME_PORT = (Integer)net.get("game_port");
            CACHE_NAME = (String)cache.get("cacheDir");
            RSA_PUBLIC_KEY = new BigInteger(String.valueOf((Integer)rsa.get("rsaPub")));
            RSA_MODULUS = (BigInteger)rsa.get("rsaModulus");
            USE_STATIC_DETAILS = (Boolean)login.get("useStaticCredentials");
            USERNAME = (String)login.get("username");
            PASSWORD = (String)login.get("password");
            ROOFS_ENABLED = (Boolean)game.get("roofsEnabled");
            SOUND_MUTED = (Boolean)game.get("soundMuted");
            FREE_TELEPORTS = (Boolean)game.get("freeTeleports");
            DEBUG_CONTEXT = (Boolean)game.get("debugContextMenu");
            SERVER_DISPLAY_NAME = (String)obj.get("serverDisplayName");
            if (USERNAME == null) {
                USERNAME = "";
            }
            if (PASSWORD == null) {
                PASSWORD = "";
            }
            if (SERVER_DISPLAY_NAME == null) {
                SERVER_DISPLAY_NAME = "Magic Rune";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to load client config - using defaults.");
            HashMap<String, Object> net = new HashMap<String, Object>();
            net.put("address", SERVER_ADDRESS);
            net.put("game_port", GAME_PORT);
            HashMap<String, String> cache = new HashMap<String, String>();
            cache.put("cacheDir", CACHE_NAME);
            HashMap<String, BigInteger> rsa = new HashMap<String, BigInteger>();
            rsa.put("rsaPub", RSA_PUBLIC_KEY);
            rsa.put("rsaModulus", RSA_MODULUS);
            HashMap<String, Object> login = new HashMap<String, Object>();
            login.put("useStaticCredentials", USE_STATIC_DETAILS);
            login.put("username", USERNAME);
            login.put("password", PASSWORD);
            HashMap<String, Boolean> game = new HashMap<String, Boolean>();
            game.put("roofsEnabled", ROOFS_ENABLED);
            game.put("freeTeleports", FREE_TELEPORTS);
            game.put("debugContextMenu", DEBUG_CONTEXT);
            game.put("soundMuted", SOUND_MUTED);
            HashMap<String, Object> clientConfig = new HashMap<String, Object>();
            clientConfig.put("serverDisplayName", SERVER_DISPLAY_NAME);
            clientConfig.put("net", net);
            clientConfig.put("cache", cache);
            clientConfig.put("rsa", rsa);
            clientConfig.put("login", login);
            clientConfig.put("game", game);
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            Yaml yaml = new Yaml(options);
            try {
                FileWriter writer = new FileWriter(configFile);
                yaml.dump(clientConfig, writer);
            }
            catch (Exception writeExeption) {
                System.out.println("Failed to write default configuration to disk.");
            }
        }
    }

    public static boolean isSoundMuted() {
        return SOUND_MUTED;
    }

    public static void setSoundMuted(boolean soundMuted) {
        SOUND_MUTED = soundMuted;
        File configFile = new File(clientConfigPath);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        try {
            FileInputStream inputStream = new FileInputStream(configFile);
            Map obj = (Map)yaml.load(inputStream);
            Map game = (Map)obj.get("game");
            game.put("soundMuted", SOUND_MUTED);
            obj.put("game", game);
            FileWriter writer = new FileWriter(configFile);
            yaml.dump(obj, writer);
        }
        catch (Exception e) {
            System.out.println("Could not write client config.");
        }
    }

    public static RSString getUsername() {
        if (USE_STATIC_DETAILS) {
            return RSString.CreateString(USERNAME);
        }
        return Native.string_blank;
    }

    public static RSString getPassword() {
        if (USE_STATIC_DETAILS) {
            return RSString.CreateString(PASSWORD);
        }
        return Native.string_blank;
    }
}

